/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import org.japura.gui.calendar.DayOfWeek;

public final class CalendarProperties {
    private static CalendarProperties dcp;
    boolean getFromDefault = true;
    private HashMap<DayOfWeek, Color> dayOfWeekForegrounds;
    private HashMap<DayOfWeek, Color> dayOfWeekBackgrounds = new HashMap();
    private Insets dayOfWeekMargin;
    private Color dayOfMonthBackground;
    private Color dayOfMonthForeground;
    private Color dayOfNonCurrentMonthBackground;
    private Color dayOfNonCurrentMonthForeground;
    private Insets dayOfMonthMargin;
    private Font dayOfMonthFont;
    private Font dayOfWeekFont;
    private Color selectedDayOfMonthBackground;
    private Color selectedDayOfMonthForeground;
    private Color buttonColor;
    private Color disabledButtonColor;
    private Color mouseOverButtonColor;
    private Color monthForeground;
    private Color yearForeground;
    private Color topBarBackground;
    private Color topDayOfWeekSeparatorColor;
    private Color bottomDayOfWeekSeparatorColor;
    private DayOfWeek startDayOfWeek;

    public static CalendarProperties getDefaultCalendarProperties() {
        if (dcp == null) {
            dcp = CalendarProperties.buildCalendarProperties();
        }
        return dcp;
    }

    private static CalendarProperties buildCalendarProperties() {
        CalendarProperties calendarProperties = new CalendarProperties();
        calendarProperties.getFromDefault = false;
        Color color = new Color(50, 122, 244);
        Color color2 = new Color(0, 80, 160);
        Color color3 = new Color(0, 95, 190);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.MONDAY, Color.WHITE);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.TUESDAY, Color.WHITE);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.WEDNESDAY, Color.WHITE);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.THURSDAY, Color.WHITE);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.FRIDAY, Color.WHITE);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.SATURDAY, Color.WHITE);
        calendarProperties.setDayOfWeekForeground(DayOfWeek.SUNDAY, Color.WHITE);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.MONDAY, color3);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.TUESDAY, color3);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.WEDNESDAY, color3);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.THURSDAY, color3);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.FRIDAY, color3);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.SATURDAY, color);
        calendarProperties.setDayOfWeekBackground(DayOfWeek.SUNDAY, color);
        calendarProperties.setDayOfWeekMargin(new Insets(2, 2, 2, 2));
        calendarProperties.setDayOfMonthMargin(new Insets(2, 2, 2, 2));
        calendarProperties.setDayOfMonthBackground(Color.WHITE);
        calendarProperties.setDayOfMonthForeground(Color.BLACK);
        calendarProperties.setDayOfNonCurrentMonthBackground(Color.WHITE);
        calendarProperties.setDayOfNonCurrentMonthForeground(Color.LIGHT_GRAY);
        calendarProperties.setSelectedDayOfMonthBackground(new Color(146, 190, 255));
        calendarProperties.setSelectedDayOfMonthForeground(Color.BLACK);
        calendarProperties.setDayOfMonthFont(new Font("Dialog", 0, 12));
        calendarProperties.setDayOfWeekFont(new Font("Dialog", 1, 12));
        calendarProperties.setButtonColor(Color.WHITE);
        calendarProperties.setMouseOverButtonColor(new Color(220, 220, 255));
        calendarProperties.setDisabledButtonColor(Color.LIGHT_GRAY);
        calendarProperties.setMonthForeground(Color.WHITE);
        calendarProperties.setYearForeground(Color.WHITE);
        calendarProperties.setTopBarBackground(color2);
        calendarProperties.setTopDayOfWeekSeparatorColor(Color.WHITE);
        calendarProperties.setBottomDayOfWeekSeparatorColor(Color.BLACK);
        calendarProperties.setStartDayOfWeek(DayOfWeek.MONDAY);
        return calendarProperties;
    }

    public static void setDefaultCalendarProperties(CalendarProperties calendarProperties) {
        calendarProperties.getFromDefault = false;
        dcp = calendarProperties;
    }

    public CalendarProperties() {
        this.dayOfWeekForegrounds = new HashMap();
    }

    public void setDayOfWeekForeground(DayOfWeek dayOfWeek, Color color) {
        if (color != null) {
            this.dayOfWeekForegrounds.put(dayOfWeek, color);
        }
    }

    public void setDayOfWeekBackground(DayOfWeek dayOfWeek, Color color) {
        if (color != null) {
            this.dayOfWeekBackgrounds.put(dayOfWeek, color);
        }
    }

    public void setDayOfWeekMargin(Insets insets) {
        if (insets != null) {
            this.dayOfWeekMargin = insets = this.validateMargin(insets);
        }
    }

    private Insets validateMargin(Insets insets) {
        insets.left = Math.max(insets.left, 0);
        insets.right = Math.max(insets.right, 0);
        insets.top = Math.max(insets.top, 0);
        insets.bottom = Math.max(insets.bottom, 0);
        return insets;
    }

    public Color getDayOfWeekForeground(DayOfWeek dayOfWeek) {
        Color color = this.dayOfWeekForegrounds.get((Object)dayOfWeek);
        if (this.getFromDefault && color == null && (color = CalendarProperties.getDefaultCalendarProperties().getDayOfWeekForeground(dayOfWeek)) == null) {
            throw new RuntimeException("Null foreground color for " + dayOfWeek.name());
        }
        return color;
    }

    public Color getDayOfWeekBackground(DayOfWeek dayOfWeek) {
        Color color = this.dayOfWeekBackgrounds.get((Object)dayOfWeek);
        if (this.getFromDefault && color == null && (color = CalendarProperties.getDefaultCalendarProperties().getDayOfWeekBackground(dayOfWeek)) == null) {
            throw new RuntimeException("Null background color for " + (Object)((Object)dayOfWeek));
        }
        return color;
    }

    public Insets getDayOfWeekMargin() {
        if (this.getFromDefault && this.dayOfWeekMargin == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfWeekMargin() != null) {
                return CalendarProperties.getDefaultCalendarProperties().getDayOfWeekMargin();
            }
            throw new RuntimeException("Null margin for day of week ");
        }
        return this.dayOfWeekMargin;
    }

    public Color getDayOfMonthBackground() {
        if (this.getFromDefault && this.dayOfMonthBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthBackground() == null) {
                throw new RuntimeException("Null background color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthBackground();
        }
        return this.dayOfMonthBackground;
    }

    public void setDayOfMonthBackground(Color color) {
        this.dayOfMonthBackground = color;
    }

    public Color getDayOfMonthForeground() {
        if (this.getFromDefault && this.dayOfMonthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthForeground() == null) {
                throw new RuntimeException("Null foreground color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthForeground();
        }
        return this.dayOfMonthForeground;
    }

    public void setDayOfMonthForeground(Color color) {
        this.dayOfMonthForeground = color;
    }

    public Color getDayOfNonCurrentMonthBackground() {
        if (this.getFromDefault && this.dayOfNonCurrentMonthBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthBackground() == null) {
                throw new RuntimeException("Null background color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthBackground();
        }
        return this.dayOfNonCurrentMonthBackground;
    }

    public void setDayOfNonCurrentMonthBackground(Color color) {
        this.dayOfNonCurrentMonthBackground = color;
    }

    public Color getDayOfNonCurrentMonthForeground() {
        if (this.getFromDefault && this.dayOfNonCurrentMonthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthForeground() == null) {
                throw new RuntimeException("Null foreground color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthForeground();
        }
        return this.dayOfNonCurrentMonthForeground;
    }

    public void setDayOfNonCurrentMonthForeground(Color color) {
        this.dayOfNonCurrentMonthForeground = color;
    }

    public Insets getDayOfMonthMargin() {
        if (this.getFromDefault && this.dayOfMonthMargin == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthMargin() == null) {
                throw new RuntimeException("Null margin for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthMargin();
        }
        return this.dayOfMonthMargin;
    }

    public void setDayOfMonthMargin(Insets insets) {
        this.dayOfMonthMargin = insets = this.validateMargin(insets);
    }

    public Color getSelectedDayOfMonthBackground() {
        if (this.getFromDefault && this.selectedDayOfMonthBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthBackground() == null) {
                throw new RuntimeException("Null background color for selected day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthBackground();
        }
        return this.selectedDayOfMonthBackground;
    }

    public void setSelectedDayOfMonthBackground(Color color) {
        this.selectedDayOfMonthBackground = color;
    }

    public Color getButtonColor() {
        if (this.getFromDefault && this.buttonColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getButtonColor() == null) {
                throw new RuntimeException("Null button color");
            }
            return CalendarProperties.getDefaultCalendarProperties().getButtonColor();
        }
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    public Color getDisabledButtonColor() {
        if (this.getFromDefault && this.disabledButtonColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDisabledButtonColor() == null) {
                throw new RuntimeException("Null disabled button color");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDisabledButtonColor();
        }
        return this.disabledButtonColor;
    }

    public void setDisabledButtonColor(Color color) {
        this.disabledButtonColor = color;
    }

    public Color getMouseOverButtonColor() {
        if (this.getFromDefault && this.mouseOverButtonColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getMouseOverButtonColor() == null) {
                throw new RuntimeException("Null mouse over button color");
            }
            return CalendarProperties.getDefaultCalendarProperties().getMouseOverButtonColor();
        }
        return this.mouseOverButtonColor;
    }

    public void setMouseOverButtonColor(Color color) {
        this.mouseOverButtonColor = color;
    }

    public Color getMonthForeground() {
        if (this.getFromDefault && this.monthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getMonthForeground() == null) {
                throw new RuntimeException("Null month foreground");
            }
            return CalendarProperties.getDefaultCalendarProperties().getMonthForeground();
        }
        return this.monthForeground;
    }

    public void setMonthForeground(Color color) {
        this.monthForeground = color;
    }

    public Color getYearForeground() {
        if (this.getFromDefault && this.yearForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getYearForeground() == null) {
                throw new RuntimeException("Null year foreground");
            }
            return CalendarProperties.getDefaultCalendarProperties().getYearForeground();
        }
        return this.yearForeground;
    }

    public void setYearForeground(Color color) {
        this.yearForeground = color;
    }

    public Color getTopBarBackground() {
        if (this.getFromDefault && this.topBarBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getTopBarBackground() == null) {
                throw new RuntimeException("Null top bar background");
            }
            return CalendarProperties.getDefaultCalendarProperties().getTopBarBackground();
        }
        return this.topBarBackground;
    }

    public void setTopBarBackground(Color color) {
        this.topBarBackground = color;
    }

    public Color getSelectedDayOfMonthForeground() {
        if (this.getFromDefault && this.selectedDayOfMonthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthForeground() == null) {
                throw new RuntimeException("Null foreground color for selected day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthForeground();
        }
        return this.selectedDayOfMonthForeground;
    }

    public void setSelectedDayOfMonthForeground(Color color) {
        this.selectedDayOfMonthForeground = color;
    }

    public Font getDayOfMonthFont() {
        if (this.getFromDefault && this.dayOfMonthFont == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthFont() == null) {
                throw new RuntimeException("Null font for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthFont();
        }
        return this.dayOfMonthFont;
    }

    public void setDayOfMonthFont(Font font) {
        this.dayOfMonthFont = font;
    }

    public Font getDayOfWeekFont() {
        if (this.getFromDefault && this.dayOfWeekFont == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfWeekFont() == null) {
                throw new RuntimeException("Null font for day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfWeekFont();
        }
        return this.dayOfWeekFont;
    }

    public void setDayOfWeekFont(Font font) {
        this.dayOfWeekFont = font;
    }

    public Color getTopDayOfWeekSeparatorColor() {
        if (this.getFromDefault && this.topDayOfWeekSeparatorColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getTopDayOfWeekSeparatorColor() == null) {
                throw new RuntimeException("Null separator color for top day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getTopDayOfWeekSeparatorColor();
        }
        return this.topDayOfWeekSeparatorColor;
    }

    public void setTopDayOfWeekSeparatorColor(Color color) {
        this.topDayOfWeekSeparatorColor = color;
    }

    public Color getBottomDayOfWeekSeparatorColor() {
        if (this.getFromDefault && this.bottomDayOfWeekSeparatorColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getBottomDayOfWeekSeparatorColor() == null) {
                throw new RuntimeException("Null separator color for bottom day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getBottomDayOfWeekSeparatorColor();
        }
        return this.bottomDayOfWeekSeparatorColor;
    }

    public void setBottomDayOfWeekSeparatorColor(Color color) {
        this.bottomDayOfWeekSeparatorColor = color;
    }

    public DayOfWeek getStartDayOfWeek() {
        if (this.getFromDefault && this.startDayOfWeek == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getStartDayOfWeek() == null) {
                throw new RuntimeException("Null start day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getStartDayOfWeek();
        }
        return this.startDayOfWeek;
    }

    public void setStartDayOfWeek(DayOfWeek dayOfWeek) {
        this.startDayOfWeek = dayOfWeek;
    }
}

