/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.japura.gui.I18nStringKeys;
import org.japura.gui.Images;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.PropertiesProvider;
import org.japura.gui.model.DateDocument;
import org.japura.i18n.I18nManager;

public class CalendarField
extends JComponent {
    private static final long serialVersionUID = -3037260699569201200L;
    private DateDocument dateDocument;
    private JTextField textField;
    private JLabel calendarButton;
    private String calendarWindowTitle;
    private PropertiesProvider propertiesProvider;

    public CalendarField() {
        this(new DateDocument());
    }

    public CalendarField(DateDocument dateDocument) {
        if (dateDocument == null) {
            dateDocument = new DateDocument();
        }
        this.setDateDocument(dateDocument);
        this.setLayout(new BorderLayout(3, 0));
        this.add((Component)this.getTextField(), "Center");
        this.add((Component)this.getCalendarButton(), "East");
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public void setCalendarButtonIcon(URL uRL) {
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.getCalendarButton().setIcon(imageIcon);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setDateDocument(DateDocument dateDocument) {
        if (dateDocument != null) {
            this.dateDocument = dateDocument;
            this.setLocale(dateDocument.getLocale());
        }
    }

    public DateDocument getDateDocument() {
        return this.dateDocument;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getTextField().setEnabled(bl);
        this.getCalendarButton().setEnabled(false);
    }

    protected JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(8);
            this.textField.setDocument(this.getDateDocument());
        }
        return this.textField;
    }

    public void setCalendarWindowTitle(String string) {
        this.calendarWindowTitle = string;
    }

    public String getCalendarWindowTitle() {
        return this.calendarWindowTitle;
    }

    private JLabel getCalendarButton() {
        if (this.calendarButton == null) {
            this.calendarButton = new JLabel();
            URL uRL = Images.CALENDAR;
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.calendarButton.setIcon(imageIcon);
            this.calendarButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Long l;
                    String string;
                    if (!CalendarField.this.isEnabled()) {
                        return;
                    }
                    Date date = CalendarField.this.getDateDocument().getDate();
                    if (date == null) {
                        date = new Date(System.currentTimeMillis());
                    }
                    if ((string = CalendarField.this.getCalendarWindowTitle()) == null) {
                        string = I18nManager.getString(I18nStringKeys.CALENDAR_WINDOW_TITLE.getKey());
                    }
                    if ((l = Calendar.showAsDialog(CalendarField.this.getDateDocument().getLocale(), date.getTime(), string, CalendarField.this, CalendarField.this.getPropertiesProvider())) != null) {
                        CalendarField.this.getDateDocument().setDate(l);
                    }
                }
            });
        }
        return this.calendarButton;
    }
}

