/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.japura.gui.Images;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.DefaultPropertiesProvider;
import org.japura.gui.calendar.PropertiesProvider;
import org.japura.gui.calendar.components.CalendarButton;
import org.japura.gui.calendar.components.CalendarSlot;
import org.japura.gui.calendar.components.DayOfMonthSlot;
import org.japura.gui.calendar.components.DayOfWeekSlot;
import org.japura.gui.calendar.components.MonthLabel;
import org.japura.gui.calendar.components.TopBar;
import org.japura.gui.calendar.components.WeekHeaderSlot;
import org.japura.gui.calendar.components.WeekSlot;
import org.japura.gui.calendar.components.YearLabel;
import org.japura.gui.event.DateEvent;
import org.japura.gui.event.DateListener;

public class Calendar
extends JComponent {
    private static final long serialVersionUID = -3245248937315409078L;
    public static final DayOfWeek SUNDAY = DayOfWeek.SUNDAY;
    public static final DayOfWeek MONDAY = DayOfWeek.MONDAY;
    public static final DayOfWeek THURSDAY = DayOfWeek.THURSDAY;
    public static final DayOfWeek WEDNESDAY = DayOfWeek.WEDNESDAY;
    public static final DayOfWeek TUESDAY = DayOfWeek.TUESDAY;
    public static final DayOfWeek FRIDAY = DayOfWeek.FRIDAY;
    public static final DayOfWeek SATURDAY = DayOfWeek.SATURDAY;
    private PropertiesProvider propertiesProvider = new DefaultPropertiesProvider();
    private HashMap<CalendarComponentType, List<CalendarSlot>> slots;
    private CalendarButton previousMonthButton;
    private CalendarButton previousYearButton;
    private CalendarButton nextMonthButton;
    private CalendarButton nextYearButton;
    private MonthLabel monthLabel;
    private YearLabel yearLabel;
    private TopBar topPanel;
    private JPanel slotsPanel;
    private PopupMenuBuilder<CalendarComponent> popupMenuBuilder;
    private String[] weekNames;
    private String[] monthNames;
    private Long date;
    private boolean weeksEnabled = false;
    boolean dialogMode;
    private JDialog modalDialog;
    Long selectedDialogDate;

    public Calendar() {
        this(null);
    }

    public Calendar(Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        super.setLayout(new BorderLayout());
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.getSlotsPanel(), "Center");
        this.updateNames();
        this.slots = new HashMap();
        this.rebuild();
        this.setDate(System.currentTimeMillis());
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        if (propertiesProvider == null) {
            propertiesProvider = new DefaultPropertiesProvider();
        }
        this.propertiesProvider = propertiesProvider;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public PopupMenuBuilder<CalendarComponent> getPopupMenuBuilder() {
        return this.popupMenuBuilder;
    }

    public void setPopupMenuBuilder(PopupMenuBuilder<CalendarComponent> popupMenuBuilder) {
        this.popupMenuBuilder = popupMenuBuilder;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getNextYearButton().setEnabled(bl);
        this.getNextMonthButton().setEnabled(bl);
        this.getPreviousMonthButton().setEnabled(bl);
        this.getPreviousYearButton().setEnabled(bl);
        this.getMonthLabel().setEnabled(bl);
        this.getYearLabel().setEnabled(bl);
        for (List<CalendarSlot> list : this.slots.values()) {
            for (CalendarSlot calendarSlot : list) {
                calendarSlot.setEnabled(bl);
            }
        }
        super.setEnabled(bl);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateNames();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    private void updateNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.getLocale());
        this.weekNames = dateFormatSymbols.getShortWeekdays();
        this.monthNames = dateFormatSymbols.getMonths();
        Font font = this.getMonthLabel().getFont();
        FontMetrics fontMetrics = this.getMonthLabel().getFontMetrics(font);
        int n = 0;
        for (String string : this.monthNames) {
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        Dimension dimension = new Dimension(n, fontMetrics.getHeight());
        this.getMonthLabel().setPreferredSize(dimension);
    }

    protected void fireAllListeners(Date date, Date date2) {
        DateListener[] dateListenerArray;
        DateEvent dateEvent = new DateEvent(date2, date);
        for (DateListener dateListener : dateListenerArray = (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            dateListener.dateChanged(dateEvent);
        }
    }

    public void addDateListener(DateListener dateListener) {
        this.listenerList.add(DateListener.class, dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.listenerList.remove(DateListener.class, dateListener);
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
    }

    private TopBar getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new TopBar(this);
            this.topPanel.setBackground(this.getPropertiesProvider().getBackground(this.topPanel));
            this.topPanel.add(this.getPreviousYearButton());
            this.topPanel.add(this.getPreviousMonthButton());
            this.topPanel.add(this.getMonthLabel());
            this.topPanel.add(this.getYearLabel());
            this.topPanel.add(this.getNextMonthButton());
            this.topPanel.add(this.getNextYearButton());
        }
        return this.topPanel;
    }

    private JPanel getSlotsPanel() {
        if (this.slotsPanel == null) {
            this.slotsPanel = new JPanel();
            this.slotsPanel.setOpaque(false);
        }
        return this.slotsPanel;
    }

    private CalendarButton getPreviousYearButton() {
        if (this.previousYearButton == null) {
            this.previousYearButton = new CalendarButton(this, CalendarComponentType.PREVIOUS_YEAR_BUTTON);
            PropertiesProvider propertiesProvider = this.getPropertiesProvider();
            this.previousYearButton.setForeground(propertiesProvider.getForeground(this.previousYearButton));
            this.previousYearButton.setDisabledForeground(propertiesProvider.getDisabledForeground(this.previousYearButton));
            this.previousYearButton.setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.previousYearButton));
            this.previousYearButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.previousYear();
                    }
                }
            });
        }
        return this.previousYearButton;
    }

    private CalendarButton getPreviousMonthButton() {
        if (this.previousMonthButton == null) {
            this.previousMonthButton = new CalendarButton(this, CalendarComponentType.PREVIOUS_MONTH_BUTTON);
            PropertiesProvider propertiesProvider = this.getPropertiesProvider();
            this.previousMonthButton.setForeground(propertiesProvider.getForeground(this.previousMonthButton));
            this.previousMonthButton.setDisabledForeground(propertiesProvider.getDisabledForeground(this.previousMonthButton));
            this.previousMonthButton.setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.previousMonthButton));
            this.previousMonthButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.previousMonth();
                    }
                }
            });
        }
        return this.previousMonthButton;
    }

    private CalendarButton getNextMonthButton() {
        if (this.nextMonthButton == null) {
            this.nextMonthButton = new CalendarButton(this, CalendarComponentType.NEXT_MONTH_BUTTON);
            PropertiesProvider propertiesProvider = this.getPropertiesProvider();
            this.nextMonthButton.setForeground(propertiesProvider.getForeground(this.nextMonthButton));
            this.nextMonthButton.setDisabledForeground(propertiesProvider.getDisabledForeground(this.nextMonthButton));
            this.nextMonthButton.setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.nextMonthButton));
            this.nextMonthButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.nextMonth();
                    }
                }
            });
        }
        return this.nextMonthButton;
    }

    private CalendarButton getNextYearButton() {
        if (this.nextYearButton == null) {
            this.nextYearButton = new CalendarButton(this, CalendarComponentType.NEXT_YEAR_BUTTON);
            PropertiesProvider propertiesProvider = this.getPropertiesProvider();
            this.nextYearButton.setForeground(propertiesProvider.getForeground(this.nextYearButton));
            this.nextYearButton.setDisabledForeground(propertiesProvider.getDisabledForeground(this.nextYearButton));
            this.nextYearButton.setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.nextYearButton));
            this.nextYearButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.nextYear();
                    }
                }
            });
        }
        return this.nextYearButton;
    }

    private MonthLabel getMonthLabel() {
        if (this.monthLabel == null) {
            this.monthLabel = new MonthLabel(this);
            this.monthLabel.setForeground(this.getPropertiesProvider().getForeground(this.monthLabel));
        }
        return this.monthLabel;
    }

    private YearLabel getYearLabel() {
        if (this.yearLabel == null) {
            this.yearLabel = new YearLabel(this);
            this.yearLabel.setForeground(this.getPropertiesProvider().getForeground(this.yearLabel));
        }
        return this.yearLabel;
    }

    private boolean isWeeksEnabled() {
        return this.weeksEnabled;
    }

    private void addSlot(CalendarSlot calendarSlot, CalendarComponentType calendarComponentType) {
        List<CalendarSlot> list = this.slots.get((Object)calendarComponentType);
        if (list == null) {
            list = new ArrayList<CalendarSlot>();
            this.slots.put(calendarComponentType, list);
        }
        list.add(calendarSlot);
        this.getSlotsPanel().add(calendarSlot);
    }

    private void rebuild() {
        int n;
        int n2 = 7;
        if (this.isWeeksEnabled()) {
            ++n2;
        }
        this.getSlotsPanel().removeAll();
        this.getSlotsPanel().setLayout(new GridLayout(0, n2, 0, 0));
        this.slots.clear();
        if (this.isWeeksEnabled()) {
            this.addSlot(new WeekHeaderSlot(this), CalendarComponentType.WEEK_HEADER);
        }
        DayOfWeek dayOfWeek = this.getPropertiesProvider().getStartDayOfWeek();
        for (n = 0; n < 7; ++n) {
            String string = this.weekNames[dayOfWeek.getJUDayOfWeek()];
            this.addSlot(new DayOfWeekSlot(this, string, dayOfWeek), CalendarComponentType.DAY_WEEK_HEADER);
            dayOfWeek = dayOfWeek.nextDayOfWeek();
        }
        for (n = 0; n < n2 * 6; ++n) {
            if (this.isWeeksEnabled() && n % 8 == 0) {
                this.addSlot(new WeekSlot(this), CalendarComponentType.WEEK);
                continue;
            }
            this.addSlot(new DayOfMonthSlot(this), CalendarComponentType.DAY_MONTH);
        }
        this.getSlotsPanel().revalidate();
    }

    public void update() {
        this.rebuild();
        this.updateDate();
        PropertiesProvider propertiesProvider = this.getPropertiesProvider();
        this.getPreviousYearButton().setForeground(propertiesProvider.getForeground(this.getPreviousYearButton()));
        this.getPreviousMonthButton().setForeground(propertiesProvider.getForeground(this.getPreviousMonthButton()));
        this.getNextMonthButton().setForeground(propertiesProvider.getForeground(this.getNextMonthButton()));
        this.getNextYearButton().setForeground(propertiesProvider.getForeground(this.getNextYearButton()));
        this.getPreviousYearButton().setDisabledForeground(propertiesProvider.getDisabledForeground(this.getPreviousYearButton()));
        this.getPreviousMonthButton().setDisabledForeground(propertiesProvider.getDisabledForeground(this.getPreviousMonthButton()));
        this.getNextMonthButton().setDisabledForeground(propertiesProvider.getDisabledForeground(this.getNextMonthButton()));
        this.getNextYearButton().setDisabledForeground(propertiesProvider.getDisabledForeground(this.getNextYearButton()));
        this.getPreviousYearButton().setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.getPreviousYearButton()));
        this.getPreviousMonthButton().setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.getPreviousMonthButton()));
        this.getNextMonthButton().setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.getNextMonthButton()));
        this.getNextYearButton().setMouseOverForeground(propertiesProvider.getMouseOverForeground(this.getNextYearButton()));
        this.getMonthLabel().setForeground(propertiesProvider.getForeground(this.getMonthLabel()));
        this.getYearLabel().setForeground(propertiesProvider.getForeground(this.getYearLabel()));
        this.getTopPanel().setBackground(propertiesProvider.getBackground(this.getTopPanel()));
        this.repaint();
    }

    private void updateDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        this.date = gregorianCalendar.getTimeInMillis();
        int n = gregorianCalendar.get(5);
        int n2 = gregorianCalendar.get(2);
        String string = this.monthNames[n2];
        this.getMonthLabel().setText(string);
        int n3 = gregorianCalendar.get(1);
        this.getYearLabel().setText(Integer.toString(n3));
        gregorianCalendar.set(5, 1);
        int n4 = gregorianCalendar.get(7);
        DayOfWeek dayOfWeek = DayOfWeek.getDayOfWeek(n4);
        DayOfWeek dayOfWeek2 = this.getPropertiesProvider().getStartDayOfWeek();
        int n5 = 0;
        while (!dayOfWeek2.equals((Object)dayOfWeek)) {
            dayOfWeek2 = dayOfWeek2.nextDayOfWeek();
            ++n5;
        }
        gregorianCalendar.add(5, -1 * n5);
        List<CalendarSlot> list = this.slots.get((Object)CalendarComponentType.DAY_MONTH);
        for (CalendarSlot calendarSlot : list) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarSlot;
            int n6 = gregorianCalendar.get(5);
            int n7 = gregorianCalendar.get(2);
            int n8 = gregorianCalendar.get(1);
            dayOfMonthSlot.setDate(n6, n7, n8);
            if (n7 == n2) {
                dayOfMonthSlot.setCurrentMonth(true);
                dayOfMonthSlot.setSelected(n6 == n);
            } else {
                dayOfMonthSlot.setCurrentMonth(false);
                dayOfMonthSlot.setSelected(false);
            }
            gregorianCalendar.add(5, 1);
        }
        this.repaint();
    }

    public void previousYear() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.date);
        gregorianCalendar.add(1, -1);
        this.setDate(gregorianCalendar.getTimeInMillis());
    }

    public void nextYear() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.date);
        gregorianCalendar.add(1, 1);
        this.setDate(gregorianCalendar.getTimeInMillis());
    }

    public void nextMonth() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.date);
        gregorianCalendar.add(2, 1);
        this.setDate(gregorianCalendar.getTimeInMillis());
    }

    public void previousMonth() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.date);
        gregorianCalendar.add(2, -1);
        this.setDate(gregorianCalendar.getTimeInMillis());
    }

    public DayOfWeek getDayOfWeek(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.getDayOfWeek();
        }
        if (calendarComponent instanceof DayOfWeekSlot) {
            DayOfWeekSlot dayOfWeekSlot = (DayOfWeekSlot)calendarComponent;
            return dayOfWeekSlot.getDayOfWeek();
        }
        return null;
    }

    public boolean isSelected(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.isSelected();
        }
        return false;
    }

    public boolean isCurrentMonth(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.isCurrentMonth();
        }
        return false;
    }

    public Integer getYear(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.getYear();
        }
        return null;
    }

    public Integer getMonth(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.getMonth();
        }
        return null;
    }

    public Integer getDay(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.getDay();
        }
        return null;
    }

    public Date getDate(CalendarComponent calendarComponent) {
        if (calendarComponent instanceof DayOfMonthSlot) {
            DayOfMonthSlot dayOfMonthSlot = (DayOfMonthSlot)calendarComponent;
            return dayOfMonthSlot.getDate();
        }
        return null;
    }

    public void setDate(long l) {
        Date date = null;
        if (this.date != null) {
            date = new Date(this.date);
        }
        Date date2 = new Date(l);
        this.date = l;
        this.updateDate();
        this.fireAllListeners(date, date2);
    }

    public Date getDate() {
        return new Date(this.date);
    }

    public boolean isDialogMode() {
        return this.dialogMode;
    }

    public void disposeDialog(long l) {
        if (this.isDialogMode()) {
            this.selectedDialogDate = l;
            this.getModalDialog().dispose();
        }
    }

    JDialog getModalDialog() {
        if (this.modalDialog == null) {
            this.modalDialog = new JDialog();
            ImageIcon imageIcon = new ImageIcon(Images.CALENDAR);
            this.modalDialog.setIconImage(imageIcon.getImage());
            this.modalDialog.add(this);
            this.modalDialog.pack();
            this.modalDialog.setResizable(false);
            this.modalDialog.setModal(true);
        }
        return this.modalDialog;
    }

    public static Long showAsDialog(Locale locale, long l, String string, Component component) {
        return Calendar.showAsDialog(locale, l, string, component, null);
    }

    public static Long showAsDialog(Locale locale, long l, String string, Component component, PropertiesProvider propertiesProvider) {
        Calendar calendar = new Calendar(locale);
        calendar.setDate(l);
        if (propertiesProvider != null) {
            calendar.setPropertiesProvider(propertiesProvider);
        }
        calendar.dialogMode = true;
        calendar.getModalDialog().setTitle(string);
        calendar.getModalDialog().setLocationRelativeTo(component);
        calendar.getModalDialog().setVisible(true);
        return calendar.selectedDialogDate;
    }
}

