/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WrapLabel
extends JLabel {
    public static final Align LEFT = Align.LEFT;
    public static final Align RIGHT = Align.RIGHT;
    public static final Align CENTER = Align.CENTER;
    private Align align = Align.LEFT;
    private int wrapWidth = 0;
    private String text;

    public WrapLabel() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WrapLabel.this.wrapText();
            }
        });
    }

    public WrapLabel(String string) {
        this();
        this.setText(string);
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.wrapText();
    }

    private void wrapText() {
        int n;
        if (this.getFont() == null || this.text == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("<html>");
        stringBuilder2.append("<STYLE type='text/css'>BODY { text-align: ");
        stringBuilder2.append(this.align.name().toLowerCase());
        stringBuilder2.append("}</STYLE><BODY>");
        ArrayList<String> arrayList = new ArrayList<String>();
        this.text = this.text.replaceAll("\n", "<BR>");
        String[] stringArray = this.text.split("<BR>");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0) {
                String[] stringArray2 = stringArray[i].split("[ \\t\\x0B\\f\\r]+");
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= 0) continue;
                    arrayList.add(stringArray2[n]);
                }
            }
            if (i >= stringArray.length - 1) continue;
            arrayList.add("<BR>");
        }
        for (String string : arrayList) {
            if (string.equals("<BR>")) {
                stringBuilder2.append("<BR>");
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(" ");
            stringBuilder.append(string);
            n = SwingUtilities.computeStringWidth(fontMetrics, stringBuilder.toString().trim());
            if (this.wrapWidth > 0 && n > this.wrapWidth) {
                int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
                if (n2 >= this.wrapWidth) {
                    stringBuilder2.append("...");
                    break;
                }
                stringBuilder2.append("<BR>");
                stringBuilder.setLength(0);
                stringBuilder.append(string);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder2.append(" ");
            }
            stringBuilder2.append(string);
        }
        stringBuilder2.append("</BODY></html>");
        super.setText(stringBuilder2.toString());
    }

    public int getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(int n) {
        this.wrapWidth = n;
        this.wrapText();
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
        this.wrapText();
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

