/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class ToolTipButton
extends JPanel {
    private static final long serialVersionUID = 2679673685756193717L;
    private static Color DEFAULT_BACKGROUND = new Color(255, 255, 220);
    private Color borderColor = Color.BLACK;
    private Color toolTipBackground;
    private Icon image;
    private Icon imageMouseOver;
    private int toolTipWrapWidth = 300;
    private JLabel imageComponent;
    private Insets margin;
    private int borderThickness = 2;
    private Timer timer;
    private String text;

    public ToolTipButton(Icon icon) {
        this(icon, null, null, DEFAULT_BACKGROUND);
    }

    public ToolTipButton(Icon icon, String string) {
        this(icon, null, string, DEFAULT_BACKGROUND);
    }

    public ToolTipButton(Icon icon, Icon icon2, String string) {
        this(icon, icon2, string, DEFAULT_BACKGROUND);
    }

    public ToolTipButton(Icon icon, Icon icon2, String string, Color color) {
        this.setTooltipMargin(null);
        this.setLayout(new GridBagLayout());
        this.imageComponent = new JLabel(icon);
        this.add(this.imageComponent);
        this.image = icon;
        this.imageMouseOver = icon2;
        this.toolTipBackground = color;
        this.setText(string);
        ToolTipEvent toolTipEvent = new ToolTipEvent();
        this.timer = new Timer(2000, toolTipEvent);
        this.addMouseListener(toolTipEvent);
        if (icon2 != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    ToolTipButton.this.imageComponent.setIcon(ToolTipButton.this.imageMouseOver);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ToolTipButton.this.imageComponent.setIcon(ToolTipButton.this.image);
                }
            });
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.text = string;
    }

    @Override
    public void setToolTipText(String string) {
        this.setText(string);
    }

    public int getTooltipDelay() {
        return this.timer.getInitialDelay();
    }

    public void setTooltipDelay(int n) {
        this.timer.setInitialDelay(n);
    }

    public Insets getTooltipMargin() {
        return this.margin;
    }

    public void setTooltipMargin(Insets insets) {
        if (insets == null) {
            insets = new Insets(10, 10, 10, 10);
        }
        insets.bottom = Math.max(insets.bottom, 0);
        insets.top = Math.max(insets.top, 0);
        insets.right = Math.max(insets.right, 0);
        insets.left = Math.max(insets.left, 0);
        this.margin = insets;
    }

    public void setTooltipBorderThickness(int n) {
        this.borderThickness = Math.max(0, n);
    }

    public int getTooltipBorderThickness() {
        return this.borderThickness;
    }

    public Color getTooltipBorderColor() {
        return this.borderColor;
    }

    public void setTooltipBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getToolTipBackground() {
        return this.toolTipBackground;
    }

    public void setToolTipBackground(Color color) {
        this.toolTipBackground = color;
    }

    public int getToolTipWrapWidth() {
        return this.toolTipWrapWidth;
    }

    public void setToolTipWrapWidth(int n) {
        this.toolTipWrapWidth = Math.max(200, n);
    }

    private static class Wrap
    extends JTextPane {
        private static final long serialVersionUID = 2849635511260534304L;
        private View view;
        private int width;

        public Wrap(int n) {
            this.width = n;
            this.setText("");
            this.setContentType("text/html");
            this.setOpaque(false);
            this.setEditable(false);
            this.setEnabled(false);
            this.setDisabledTextColor(Color.BLACK);
        }

        private void setHTMLFont(Font font) {
            MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
            StyleConstants.setFontFamily(mutableAttributeSet, font.getFamily());
            StyleConstants.setFontSize(mutableAttributeSet, font.getSize());
            StyleConstants.setForeground(mutableAttributeSet, this.getForeground());
            StyledDocument styledDocument = this.getStyledDocument();
            styledDocument.setCharacterAttributes(0, styledDocument.getLength() + 1, mutableAttributeSet, false);
        }

        @Override
        public void setText(String string) {
            super.setText(string);
            this.view = BasicHTML.createHTMLView(this, string);
            this.setHTMLFont(this.getFont());
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            this.view.setSize(this.width, 0.0f);
            Insets insets = this.getInsets();
            Insets insets2 = this.getMargin();
            float f = this.view.getPreferredSpan(0) + (float)insets.left + (float)insets.right + (float)insets2.left + (float)insets2.right;
            float f2 = this.view.getPreferredSpan(1) + (float)insets.bottom + (float)insets.top + (float)insets2.bottom + (float)insets2.top;
            return new Dimension((int)Math.ceil(f), (int)Math.ceil(f2));
        }
    }

    private class ToolTipEvent
    extends MouseAdapter
    implements ActionListener {
        private JPopupMenu popup;

        private ToolTipEvent() {
        }

        private void disposeWindow() {
            if (this.popup != null) {
                this.popup.setVisible(false);
                this.popup = null;
            }
        }

        private void showHint() {
            this.disposeWindow();
            Wrap wrap = new Wrap(ToolTipButton.this.toolTipWrapWidth);
            wrap.setForeground(ToolTipButton.this.getForeground());
            wrap.setFont(ToolTipButton.this.getFont());
            wrap.setText(ToolTipButton.this.text);
            Border border = BorderFactory.createLineBorder(ToolTipButton.this.borderColor, ToolTipButton.this.borderThickness);
            Border border2 = BorderFactory.createEmptyBorder(((ToolTipButton)ToolTipButton.this).margin.top, ((ToolTipButton)ToolTipButton.this).margin.left, ((ToolTipButton)ToolTipButton.this).margin.bottom, ((ToolTipButton)ToolTipButton.this).margin.right);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
            wrap.setBorder(compoundBorder);
            wrap.setBackground(ToolTipButton.this.toolTipBackground);
            wrap.setOpaque(true);
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            this.popup.add(wrap);
            this.popup.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ToolTipEvent.this.disposeWindow();
                }
            });
            this.popup.show(ToolTipButton.this, 0, ToolTipButton.this.getHeight());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipButton.this.timer.stop();
            this.showHint();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ToolTipButton.this.timer.start();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ToolTipButton.this.timer.stop();
            this.showHint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ToolTipButton.this.timer.stop();
            if (this.popup != null) {
                if (this.popup.isShowing()) {
                    Point point = ToolTipButton.this.getLocationOnScreen();
                    Dimension dimension = ToolTipButton.this.getSize();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(point.getX(), point.getY(), dimension.getWidth(), dimension.getHeight());
                    point = this.popup.getLocationOnScreen();
                    dimension = this.popup.getSize();
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(point.getX(), point.getY(), dimension.getWidth(), dimension.getHeight());
                    if (!double_2.contains(double_)) {
                        this.disposeWindow();
                    }
                } else {
                    this.disposeWindow();
                }
            }
        }
    }
}

