/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.japura.gui.Gradient;
import org.japura.gui.PaintedPanel;

public class TitlePanel
extends JComponent {
    private static final long serialVersionUID = -2767246232683839619L;
    private static Object defaultTitleBackground = new Gradient(Gradient.TOP_TO_BOTTOM, new Color(160, 190, 255), new Color(240, 240, 255));
    private int borderY;
    private int titleSeparatorY;
    private PaintedPanel paintedPanel;
    private JLabel titleIcon;
    private JLabel titleLabel;
    private int titleSeparator = 1;
    private Insets titleMargin = new Insets(3, 3, 3, 3);
    private int iconAndTitleGap = 5;
    private int titleAndComponentsGap = 5;
    private int componentsGap = 5;
    private Component component;
    private Object titleBackground;
    private Color separatorColor = new Color(0, 0, 0, 80);
    private JComponent[] titleComponents;

    public TitlePanel(String string) {
        this(null, string, null);
    }

    public TitlePanel(Icon icon, String string) {
        this(icon, string, null);
    }

    public TitlePanel(String string, JComponent[] jComponentArray) {
        this(null, string, jComponentArray);
    }

    public TitlePanel(Icon icon, String string, JComponent[] jComponentArray) {
        this.paintedPanel = new PaintedPanel();
        if (defaultTitleBackground instanceof Gradient) {
            this.setTitleBackground((Gradient)defaultTitleBackground);
        } else if (defaultTitleBackground instanceof Color) {
            this.setTitleBackground((Color)defaultTitleBackground);
        }
        this.titleBackground = defaultTitleBackground;
        this.setBorder(BorderFactory.createLineBorder(this.separatorColor));
        super.setLayout(new TitlePanelLayout());
        this.setOpaque(false);
        if (icon != null) {
            this.titleIcon = new JLabel(icon);
        }
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.titleLabel = new JLabel(string);
        this.titleComponents = jComponentArray;
        this.build();
    }

    private void build() {
        super.add(this.paintedPanel);
        if (this.titleIcon != null) {
            super.add(this.titleIcon);
        }
        super.add(this.titleLabel);
        if (this.titleComponents != null) {
            for (JComponent jComponent : this.titleComponents) {
                super.add(jComponent);
            }
        }
        this.updateZOrders();
    }

    private void updateZOrders() {
        int n = 0;
        if (this.titleIcon != null) {
            this.setComponentZOrder(this.titleIcon, n++);
        }
        this.setComponentZOrder(this.titleLabel, n++);
        if (this.titleComponents != null) {
            for (JComponent jComponent : this.titleComponents) {
                this.setComponentZOrder(jComponent, n++);
            }
        }
        if (this.component != null) {
            this.setComponentZOrder(this.component, n++);
        }
        this.setComponentZOrder(this.paintedPanel, n++);
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        Insets insets = this.getInsets();
        if (this.titleSeparator > 0) {
            graphics2D.setColor(this.getSeparatorColor());
            graphics2D.fillRect(insets.left, this.titleSeparatorY, this.getWidth() - (insets.left + insets.right), this.titleSeparator);
        }
    }

    @Override
    protected final void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, this.borderY, this.getWidth(), this.getHeight() - this.borderY);
        }
    }

    public void setTitleGaps(int n, int n2, int n3) {
        this.iconAndTitleGap = Math.max(n, 0);
        this.titleAndComponentsGap = Math.max(n2, 0);
        this.componentsGap = Math.max(n3, 0);
    }

    public int getGapBetweenIconAndTitle() {
        return this.iconAndTitleGap;
    }

    public int getGapBetweenTitleAndTitleComponents() {
        return this.titleAndComponentsGap;
    }

    public int getGapBetweenTitleComponents() {
        return this.componentsGap;
    }

    public void setSeparatorThickness(int n) {
        this.titleSeparator = Math.max(0, n);
    }

    @Override
    public void remove(Component component) {
        if (this.component.equals(component)) {
            this.removeView();
        }
    }

    @Override
    public void remove(int n) {
    }

    @Override
    public void removeAll() {
        this.removeView();
    }

    private void removeView() {
        if (this.component != null) {
            super.remove(this.component);
            this.component = null;
            this.updateZOrders();
        }
    }

    private void setView(Component component) {
        this.removeView();
        if (component != null) {
            this.component = component;
            super.add(component);
            this.updateZOrders();
        }
    }

    @Override
    public Component add(Component component, int n) {
        this.setView(component);
        return component;
    }

    @Override
    public void add(Component component, Object object, int n) {
        this.setView(component);
    }

    @Override
    public void add(Component component, Object object) {
        this.setView(component);
    }

    @Override
    public Component add(Component component) {
        this.setView(component);
        return component;
    }

    @Override
    public Component add(String string, Component component) {
        this.setView(component);
        return component;
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color color) {
        this.separatorColor = color;
    }

    @Override
    public Font getFont() {
        return this.titleLabel.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public void setTitleForeground(Color color) {
        this.titleLabel.setForeground(color);
    }

    public Color getTitleForeground() {
        return this.titleLabel.getForeground();
    }

    public void setTitleBackground(Color color) {
        if (color != null) {
            this.titleBackground = color;
            this.paintedPanel.removeBackgrounds();
            this.paintedPanel.addBackground(color);
        }
    }

    public void setTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            this.titleBackground = gradient;
            this.paintedPanel.removeBackgrounds();
            this.paintedPanel.addBackground(gradient);
        }
    }

    public Object getTitleBackground() {
        return this.titleBackground;
    }

    public boolean hasTitleBackgroundGradient() {
        return this.titleBackground instanceof Gradient;
    }

    public Insets getTitleMargin() {
        return (Insets)this.titleMargin.clone();
    }

    public void setTitleMargin(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n = Math.max(insets.top, 0);
        int n2 = Math.max(insets.left, 0);
        int n3 = Math.max(insets.bottom, 0);
        int n4 = Math.max(insets.right, 0);
        this.titleMargin = new Insets(n, n2, n3, n4);
    }

    public static Object getDefaultTitleBackground() {
        return defaultTitleBackground;
    }

    public static void setDefaultTitleBackground(Color color) {
        if (color != null) {
            defaultTitleBackground = color;
        }
    }

    public static void setDefaultTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            defaultTitleBackground = gradient;
        }
    }

    private class TitlePanelLayout
    implements LayoutManager {
        private TitlePanelLayout() {
        }

        private Dimension getTitlePreferredSize() {
            Dimension dimension = TitlePanel.this.titleLabel.getPreferredSize();
            if (TitlePanel.this.titleIcon != null) {
                JComponent[] jComponentArray = TitlePanel.this.titleIcon.getPreferredSize();
                dimension.width += jComponentArray.width;
                dimension.width += TitlePanel.this.iconAndTitleGap;
            }
            if (TitlePanel.this.titleComponents != null && TitlePanel.this.titleComponents.length > 0) {
                dimension.width += TitlePanel.this.titleAndComponentsGap;
                dimension.width += TitlePanel.this.componentsGap * (TitlePanel.this.titleComponents.length - 1);
                for (JComponent jComponent : TitlePanel.this.titleComponents) {
                    Dimension dimension2 = jComponent.getPreferredSize();
                    dimension.width += dimension2.width;
                }
            }
            dimension.width += ((TitlePanel)TitlePanel.this).titleMargin.left + ((TitlePanel)TitlePanel.this).titleMargin.right;
            dimension.height += ((TitlePanel)TitlePanel.this).titleMargin.top + ((TitlePanel)TitlePanel.this).titleMargin.bottom;
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.minimumLayoutSize(container);
            Insets insets = TitlePanel.this.getInsets();
            dimension.height += TitlePanel.this.titleSeparator;
            if (TitlePanel.this.component != null) {
                Dimension dimension2 = TitlePanel.this.component.getPreferredSize();
                dimension.height += dimension2.height;
                dimension.width = Math.max(dimension.width, dimension2.width);
            }
            dimension.width += insets.left + insets.right;
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = this.getTitlePreferredSize();
            Insets insets = TitlePanel.this.getInsets();
            if (TitlePanel.this.titleIcon != null) {
                Dimension dimension2 = TitlePanel.this.titleIcon.getPreferredSize();
                dimension.height = Math.max(dimension.height + insets.top, dimension2.height + ((TitlePanel)TitlePanel.this).titleMargin.bottom);
            } else {
                dimension.height += insets.top;
            }
            dimension.height += insets.bottom;
            return dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = TitlePanel.this.getTreeLock();
            synchronized (object) {
                Dimension dimension = container.getSize();
                Dimension dimension2 = this.getTitlePreferredSize();
                Insets insets = TitlePanel.this.getInsets();
                int n = dimension2.height;
                int n2 = insets.left + ((TitlePanel)TitlePanel.this).titleMargin.left;
                if (TitlePanel.this.titleIcon != null) {
                    Dimension dimension3 = TitlePanel.this.titleIcon.getPreferredSize();
                    n = Math.max(n + insets.top, dimension3.height + ((TitlePanel)TitlePanel.this).titleMargin.bottom);
                    TitlePanel.this.titleIcon.setBounds(n2, n - (dimension3.height + ((TitlePanel)TitlePanel.this).titleMargin.bottom), dimension3.width, dimension3.height);
                    n2 += dimension3.width;
                    n2 += TitlePanel.this.iconAndTitleGap;
                } else {
                    n += insets.top;
                }
                TitlePanel.this.paintedPanel.setBounds(insets.left, n - dimension2.height, dimension.width - (insets.left + insets.right), dimension2.height);
                TitlePanel.this.borderY = n - (dimension2.height + insets.top);
                int n3 = n - ((TitlePanel)TitlePanel.this).titleMargin.bottom;
                Dimension dimension4 = TitlePanel.this.titleLabel.getPreferredSize();
                TitlePanel.this.titleLabel.setBounds(n2, n3 - dimension4.height, dimension4.width, dimension4.height);
                if (TitlePanel.this.titleComponents != null && TitlePanel.this.titleComponents.length > 0) {
                    Dimension dimension5;
                    int n4 = 0;
                    for (JComponent jComponent : TitlePanel.this.titleComponents) {
                        dimension5 = jComponent.getPreferredSize();
                        n4 += dimension5.width;
                    }
                    n2 = Math.max(dimension.width - (insets.right + (n4 += TitlePanel.this.componentsGap * (TitlePanel.this.titleComponents.length - 1)) + ((TitlePanel)TitlePanel.this).titleMargin.right), n2 + dimension4.width);
                    for (JComponent jComponent : TitlePanel.this.titleComponents) {
                        dimension5 = jComponent.getPreferredSize();
                        jComponent.setBounds(n2, n3 - dimension4.height, dimension5.width, dimension5.height);
                        n2 += dimension5.width + TitlePanel.this.componentsGap;
                    }
                }
                if (TitlePanel.this.component != null) {
                    n3 += ((TitlePanel)TitlePanel.this).titleMargin.bottom;
                    if (TitlePanel.this.titleSeparator > 0) {
                        TitlePanel.this.titleSeparatorY = n3;
                        n3 += TitlePanel.this.titleSeparator;
                    }
                    n2 = insets.left;
                    TitlePanel.this.component.setBounds(n2, n3, dimension.width - (insets.left + insets.right), dimension.height - (n3 + insets.bottom));
                }
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }
}

