/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.japura.gui.renderer.DefaultSplitButtonRenderer;
import org.japura.gui.renderer.SplitButtonRenderer;

public class SplitButton
extends JButton {
    private static final long serialVersionUID = -3517516731022272314L;
    public static final Mode BUTTON = Mode.BUTTON;
    public static final Mode MENU = Mode.MENU;
    private Mode mode;
    private int maxLabelWidth;
    private int alignment = 0;
    private int imageWidth = 13;
    private int gap = 5;
    private int separatorGap = 7;
    private String actualButton;
    private boolean fireBlocked;
    private boolean buttonChooserVisible;
    private boolean mouseIn;
    private List<Button> buttons;
    private DefaultListModel listModel;
    private JPopupMenu buttonsChooser;
    private JPanel buttonsRoot;
    private JList buttonsList;
    private ListRenderer listRenderer;
    private SplitButtonRenderer splitButtonRenderer;
    private transient MouseListener originalMouseListener;
    private transient MouseListener handlerMouseListener;

    public SplitButton() {
        this(Mode.BUTTON);
    }

    public SplitButton(Mode mode) {
        this.mode = mode != null ? mode : BUTTON;
        this.buttons = new ArrayList<Button>();
        this.splitButtonRenderer = new DefaultSplitButtonRenderer();
        URL uRL = this.getClass().getResource("/resources/images/jpr_splitbuttondown.png");
        Insets insets = this.getMargin();
        insets.right = this.gap;
        insets.left = this.gap;
        this.setMargin(insets);
        super.setHorizontalTextPosition(2);
        super.setHorizontalAlignment(4);
        super.setIcon(new ImageIcon(uRL));
        this.setFocusPainted(false);
        this.originalMouseListener = this.getMouseListeners()[0];
        this.removeMouseListener(this.originalMouseListener);
        this.addMouseListener(this.getHandlerMouseListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SplitButton.this.reajustTextGap();
            }
        });
    }

    private Button get(String string) {
        if ((string = this.ajustName(string)) == null) {
            return null;
        }
        for (Button button : this.buttons) {
            if (button.isSeparator() || !button.getName().equals(string)) continue;
            return button;
        }
        return null;
    }

    private DefaultListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private void showButtonsChooser() {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        this.buttonChooserVisible = true;
        this.fireBlocked = true;
        DefaultListModel defaultListModel = this.getListModel();
        defaultListModel.removeAllElements();
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = this.buttons.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((Button)object).isSeparator() && bl2) {
                defaultListModel.addElement(object);
                bl2 = false;
                bl = true;
                continue;
            }
            if (!((Button)object).isVisible() || ((Button)object).isSeparator()) continue;
            defaultListModel.addElement(object);
            bl2 = true;
            bl = false;
        }
        while (bl) {
            defaultListModel.remove(defaultListModel.size() - 1);
            bl = false;
            if (defaultListModel.size() <= 0 || !((Button)(object2 = (Button)defaultListModel.get(defaultListModel.size() - 1))).isSeparator()) continue;
            bl = true;
        }
        if (defaultListModel.size() == 0) {
            this.buttonChooserVisible = false;
            this.fireBlocked = false;
            return;
        }
        object2 = this.getSize();
        object = this.getButtonsRoot().getPreferredSize();
        Insets insets = this.getButtonsChooser().getInsets();
        int n = ((Dimension)object2).width;
        int n2 = ((Dimension)object).height + insets.bottom + insets.top;
        Dimension dimension = new Dimension(n, n2);
        this.getButtonsChooser().setPreferredSize(dimension);
        this.getButtonsChooser().show(this, 0, ((Dimension)object2).height);
    }

    private JPopupMenu getButtonsChooser() {
        if (this.buttonsChooser == null) {
            this.buttonsChooser = new JPopupMenu();
            this.buttonsChooser.add(this.getButtonsRoot());
            this.buttonsChooser.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (SplitButton.this.mouseIn) {
                        SplitButton.this.buttonChooserVisible = true;
                    } else {
                        SplitButton.this.buttonChooserVisible = false;
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        return this.buttonsChooser;
    }

    private JPanel getButtonsRoot() {
        if (this.buttonsRoot == null) {
            this.buttonsRoot = new JPanel();
            this.buttonsRoot.setLayout(new BorderLayout());
            this.buttonsRoot.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
            this.buttonsRoot.add((Component)this.getButtonsList(), "Center");
        }
        return this.buttonsRoot;
    }

    private JList getButtonsList() {
        if (this.buttonsList == null) {
            this.buttonsList = new JList();
            this.listRenderer = new ListRenderer();
            this.buttonsList.setCellRenderer(this.listRenderer);
            this.buttonsList.setSelectionMode(0);
            this.buttonsList.setModel(this.getListModel());
            this.buttonsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Button button;
                    if (!(listSelectionEvent.getValueIsAdjusting() || SplitButton.this.buttonsList.getSelectedIndex() <= -1 || (button = (Button)SplitButton.this.buttonsList.getSelectedValue()).isSeparator() || button.isDisabled())) {
                        SplitButton.this.setButton(button.getName());
                        SplitButton.this.doClick();
                        SplitButton.this.buttonsList.clearSelection();
                    }
                }
            });
            this.buttonsList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    ((SplitButton)SplitButton.this).listRenderer.mouseOverIndex = SplitButton.this.buttonsList.locationToIndex(mouseEvent.getPoint());
                    SplitButton.this.buttonsList.repaint();
                }
            });
            this.buttonsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ((SplitButton)SplitButton.this).listRenderer.mouseOverIndex = -1;
                    SplitButton.this.buttonsList.repaint();
                }
            });
        }
        return this.buttonsList;
    }

    private void removeSuperListeners() {
        Button button;
        if (this.actualButton != null && (button = this.get(this.actualButton)) != null) {
            for (ActionListener actionListener : button.getListeners()) {
                super.removeActionListener(actionListener);
            }
        }
    }

    private void removeActualListeners() {
        Button button;
        if (this.actualButton != null && (button = this.get(this.actualButton)) != null) {
            for (ActionListener actionListener : button.getListeners()) {
                super.removeActionListener(actionListener);
            }
        }
    }

    public void setButton(String string) {
        this.removeSuperListeners();
        string = this.ajustName(string);
        this.fireBlocked = false;
        this.getButtonsChooser().setVisible(false);
        this.listRenderer.mouseOverIndex = -1;
        Button button = this.get(string);
        if (string == null) {
            this.actualButton = null;
            if (this.mode.equals((Object)Mode.BUTTON)) {
                super.setText("");
            }
        } else if (button != null && !button.isDisabled()) {
            this.actualButton = string;
            for (ActionListener actionListener : button.getListeners()) {
                super.addActionListener(actionListener);
            }
            if (this.mode.equals((Object)Mode.BUTTON)) {
                super.setText(string);
            }
        }
        this.reajustTextGap();
    }

    private void reajustTextGap() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = null;
        dimension = this.isShowing() ? this.getSize() : this.getPreferredSize();
        Insets insets = this.getInsets();
        int n = dimension.width - insets.left - insets.right - this.imageWidth - this.separatorGap - 3 - this.gap;
        int n2 = this.gap + 3 + this.separatorGap;
        int n3 = fontMetrics.stringWidth(this.getText());
        if (this.alignment == 2) {
            super.setIconTextGap(n - n3 + n2);
        } else if (this.alignment == 0) {
            super.setIconTextGap(n / 2 - n3 / 2 + n2);
        } else if (this.alignment == 4) {
            super.setIconTextGap(this.gap + 3 + this.separatorGap);
        }
    }

    @Override
    public final void setHorizontalTextPosition(int n) {
    }

    @Override
    public final void setHorizontalAlignment(int n) {
        if (n != 2 && n != 0 && n != 4) {
            throw new IllegalArgumentException();
        }
        this.alignment = n;
        this.reajustTextGap();
    }

    @Override
    public final void setIconTextGap(int n) {
    }

    private void calculateMaxLabelWidth() {
        this.maxLabelWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        for (Button button : this.buttons) {
            if (button.isSeparator()) continue;
            String string = button.getName();
            this.maxLabelWidth = Math.max(this.maxLabelWidth, fontMetrics.stringWidth(string));
        }
        if (this.mode.equals((Object)Mode.MENU)) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, fontMetrics.stringWidth(this.getText()));
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.calculatePreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.calculatePreferredSize();
    }

    private Dimension calculatePreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.maxLabelWidth;
        Insets insets = this.getInsets();
        n += insets.left + insets.right;
        dimension.width = n += this.gap + this.imageWidth + this.separatorGap + 3;
        return dimension;
    }

    @Override
    public final void setIcon(Icon icon) {
    }

    private String ajustName(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public void addButton(String string) {
        if ((string = this.ajustName(string)) != null && string.length() > 0 && this.get(string) == null) {
            this.buttons.add(new Button(string));
            this.calculateMaxLabelWidth();
            if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton == null) {
                this.setButton(string);
            }
            this.reajustTextGap();
        }
    }

    public void removeSeparators() {
        ArrayList<Button> arrayList = new ArrayList<Button>();
        for (Button button : this.buttons) {
            if (!button.isSeparator()) continue;
            arrayList.add(button);
        }
        for (Button button : arrayList) {
            this.buttons.remove(button);
        }
    }

    public void removeButton(String string) {
        Button button = this.get(string);
        if (button != null) {
            this.buttons.remove(button);
            if (this.actualButton.equals(string)) {
                this.removeActualListeners();
            }
            this.calculateMaxLabelWidth();
            if (this.actualButton.equals(string)) {
                this.setButton(null);
            }
            this.reajustTextGap();
        }
    }

    public void addSeparator() {
        this.buttons.add(new Button());
    }

    @Override
    public final void addActionListener(ActionListener actionListener) {
        if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null) {
            this.addActionListener(this.actualButton, actionListener);
        }
    }

    public final void addActionListener(String string, ActionListener actionListener) {
        List<ActionListener> list;
        Button button = this.get(string);
        if (button != null && !(list = button.getListeners()).contains(actionListener)) {
            list.add(actionListener);
            if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null && this.actualButton.equals(string)) {
                super.addActionListener(actionListener);
            }
        }
    }

    @Override
    public final void removeActionListener(ActionListener actionListener) {
        if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null) {
            this.removeActionListener(this.actualButton, actionListener);
        }
    }

    public final void removeActionListener(String string, ActionListener actionListener) {
        Button button = this.get(string);
        if (button != null) {
            List<ActionListener> list = button.getListeners();
            list.remove(actionListener);
            if (this.actualButton.equals(string)) {
                super.removeActionListener(actionListener);
            }
        }
    }

    @Override
    public final ActionListener[] getActionListeners() {
        return this.getActionListeners(this.actualButton);
    }

    public final ActionListener[] getActionListeners(String string) {
        Button button = this.get(string);
        if (button != null) {
            List<ActionListener> list = button.getListeners();
            return list.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    @Override
    protected final void fireActionPerformed(ActionEvent actionEvent) {
        if (!this.fireBlocked) {
            super.fireActionPerformed(actionEvent);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public final void setText(String string) {
        if (this.mode.equals((Object)Mode.MENU)) {
            super.setText(string);
            this.calculateMaxLabelWidth();
        }
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mode.equals((Object)Mode.BUTTON)) {
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            int n = dimension.width - insets.right - this.imageWidth - this.separatorGap;
            int n2 = 6;
            graphics.setColor(Color.white);
            graphics.fillRect(n, n2, 3, dimension.height - 2 * n2);
            graphics.setColor(Color.gray);
            graphics.drawLine(n + 1, n2, n + 1, dimension.height - n2);
        }
    }

    public void setButtonEnabled(String string, boolean bl) {
        Button button = this.get(string);
        if (button != null) {
            button.setDisabled(!bl);
            if (bl) {
                if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton == null) {
                    this.setButton(string);
                }
            } else if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null && this.actualButton.equals(string)) {
                boolean bl2 = false;
                for (Button button2 : this.buttons) {
                    if (button2.isDisabled()) continue;
                    bl2 = true;
                    this.setButton(button2.getName());
                    break;
                }
                if (!bl2) {
                    this.setButton(null);
                }
            }
        }
    }

    public void setButtonVisible(String string, boolean bl) {
        Button button = this.get(string);
        if (button != null) {
            button.setVisible(bl);
        }
    }

    public boolean isButtonVisible(String string) {
        Button button = this.get(string);
        if (button != null) {
            return button.isVisible();
        }
        return false;
    }

    public boolean isButtonEnabled(String string) {
        Button button = this.get(string);
        if (button != null) {
            return !button.isDisabled();
        }
        return false;
    }

    public String getSelectedButton() {
        return this.actualButton;
    }

    private MouseListener getHandlerMouseListener() {
        if (this.handlerMouseListener == null) {
            this.handlerMouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SplitButton.this.originalMouseListener.mouseClicked(mouseEvent);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    SplitButton.this.mouseIn = true;
                    SplitButton.this.originalMouseListener.mouseEntered(mouseEvent);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    SplitButton.this.mouseIn = false;
                    SplitButton.this.originalMouseListener.mouseExited(mouseEvent);
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    SplitButton.this.originalMouseListener.mousePressed(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SplitButton.this.mode.equals((Object)Mode.MENU)) {
                        SplitButton.this.removeActualListeners();
                    }
                    Dimension dimension = SplitButton.this.getSize();
                    int n = dimension.width - SplitButton.this.getInsets().right - SplitButton.this.imageWidth - SplitButton.this.separatorGap;
                    if (!SplitButton.this.buttonChooserVisible && SplitButton.this.buttons.size() > 0 && (SplitButton.this.mode.equals((Object)Mode.MENU) || mouseEvent.getPoint().x > n)) {
                        if (SplitButton.this.isEnabled()) {
                            SplitButton.this.showButtonsChooser();
                        }
                    } else {
                        SplitButton.this.getButtonsChooser().setVisible(false);
                        ((SplitButton)SplitButton.this).listRenderer.mouseOverIndex = -1;
                        SplitButton.this.buttonChooserVisible = false;
                    }
                    if (mouseEvent.getPoint().x < n) {
                        SplitButton.this.fireBlocked = false;
                    }
                    SplitButton.this.originalMouseListener.mouseReleased(mouseEvent);
                }
            };
        }
        return this.handlerMouseListener;
    }

    public SplitButtonRenderer getRenderer() {
        return this.splitButtonRenderer;
    }

    public void setRenderer(SplitButtonRenderer splitButtonRenderer) {
        if (splitButtonRenderer == null) {
            splitButtonRenderer = new DefaultSplitButtonRenderer();
        }
        this.splitButtonRenderer = splitButtonRenderer;
    }

    private static class Button {
        private String id = UUID.randomUUID().toString();
        private boolean separator;
        private boolean visible;
        private boolean disabled;
        private String name;
        private List<ActionListener> listeners = new Vector<ActionListener>();

        public Button() {
            this(null);
            this.separator = true;
        }

        public Button(String string) {
            this.name = string;
            this.visible = true;
        }

        public boolean isSeparator() {
            return this.separator;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public List<ActionListener> getListeners() {
            return this.listeners;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public void setDisabled(boolean bl) {
            this.disabled = bl;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Button button = (Button)object;
            return !(this.id == null ? button.id != null : !this.id.equals(button.id));
        }
    }

    public static enum Mode {
        BUTTON,
        MENU;

    }

    private class ListRenderer
    implements ListCellRenderer {
        public int mouseOverIndex;

        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Button button = (Button)object;
            bl2 = this.mouseOverIndex == n;
            String string = null;
            if (!button.isSeparator()) {
                string = button.getName();
            }
            return SplitButton.this.splitButtonRenderer.getCellRendererComponent(string, button.isSeparator(), bl2, !button.isDisabled());
        }
    }
}

