/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.japura.gui.Anchor;
import org.japura.gui.Gradient;

public class PaintedPanel
extends JPanel {
    private static final long serialVersionUID = -4090857463216178976L;
    private LinkedHashMap<Object, Paint> paints = new LinkedHashMap();

    public PaintedPanel() {
    }

    public PaintedPanel(boolean bl) {
        super(bl);
    }

    public PaintedPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public PaintedPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void removeBackgrounds() {
        this.paints.clear();
    }

    public void addBackground(Color color) {
        this.add(color, null);
    }

    public void removeBackground(Color color) {
        this.remove(color);
    }

    public void addBackground(Icon icon) {
        this.add(icon, null);
    }

    public void addBackground(Icon icon, Anchor anchor) {
        this.add(icon, anchor);
    }

    public void removeBackground(Icon icon) {
        this.remove(icon);
    }

    public void addBackground(Gradient gradient) {
        this.add(gradient, null);
    }

    public void removeBackground(Gradient gradient) {
        this.remove(gradient);
    }

    private void remove(Object object) {
        if (object != null) {
            this.paints.remove(object);
        }
    }

    private void add(Object object, Anchor anchor) {
        if (object != null && !this.paints.containsKey(object)) {
            if (anchor == null) {
                anchor = Anchor.CENTER;
            }
            Paint paint = new Paint();
            paint.anchor = anchor;
            paint.background = object;
            this.paints.put(object, paint);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (Object object : this.paints.keySet()) {
            Paint paint = this.paints.get(object);
            if (paint.background instanceof Icon) {
                this.paintIcon(paint, graphics);
                continue;
            }
            if (paint.background instanceof Gradient) {
                this.paintGradient((Gradient)paint.background, graphics);
                continue;
            }
            if (!(paint.background instanceof Color)) continue;
            this.paintColor((Color)paint.background, graphics);
        }
    }

    private void paintColor(Color color, Graphics graphics) {
        Insets insets = this.getInsets();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = insets.top;
        int n2 = insets.left;
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getHeight() - (insets.bottom + insets.top);
        graphics2D.setColor(color);
        graphics2D.fillRect(n2, n, n3, n4);
    }

    private void paintGradient(Gradient gradient, Graphics graphics) {
        Insets insets = this.getInsets();
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = null;
        Gradient.Direction direction = gradient.getDirection();
        Color color = gradient.getFirstColor();
        Color color2 = gradient.getSecondColor();
        int n = insets.top;
        int n2 = insets.left;
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getHeight() - (insets.bottom + insets.top);
        if (direction.equals((Object)Gradient.Direction.TOP_TO_BOTTOM)) {
            gradientPaint = new GradientPaint(0.0f, n, color, 0.0f, n4, color2);
        } else if (direction.equals((Object)Gradient.Direction.BOTTOM_TO_TOP)) {
            gradientPaint = new GradientPaint(0.0f, n, color2, 0.0f, n4, color);
        } else if (direction.equals((Object)Gradient.Direction.LEFT_TO_RIGHT)) {
            gradientPaint = new GradientPaint(n2, 0.0f, color, n3, 0.0f, color2);
        } else if (direction.equals((Object)Gradient.Direction.RIGHT_TO_LEFT)) {
            gradientPaint = new GradientPaint(n2, 0.0f, color2, n3, 0.0f, color);
        }
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n2, n, n3, n4);
    }

    private void paintIcon(Paint paint, Graphics graphics) {
        Insets insets = this.getInsets();
        Icon icon = (Icon)paint.background;
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = 0;
        int n4 = 0;
        if (paint.anchor.equals((Object)Anchor.CENTER)) {
            n3 = (this.getWidth() - n) / 2;
            n4 = (this.getHeight() - n2) / 2;
        } else if (paint.anchor.equals((Object)Anchor.NORTH)) {
            n3 = (this.getWidth() - n) / 2;
            n4 = insets.top;
        } else if (paint.anchor.equals((Object)Anchor.NORTH_WEST)) {
            n3 = insets.left;
            n4 = insets.top;
        } else if (paint.anchor.equals((Object)Anchor.NORTH_EAST)) {
            n3 = this.getWidth() - n - insets.right;
            n4 = insets.top;
        } else if (paint.anchor.equals((Object)Anchor.SOUTH)) {
            n3 = (this.getWidth() - n) / 2;
            n4 = this.getHeight() - n2 - insets.bottom;
        } else if (paint.anchor.equals((Object)Anchor.SOUTH_WEST)) {
            n3 = insets.left;
            n4 = this.getHeight() - n2 - insets.bottom;
        } else if (paint.anchor.equals((Object)Anchor.SOUTH_EAST)) {
            n3 = this.getWidth() - n - insets.right;
            n4 = this.getHeight() - n2 - insets.bottom;
        } else if (paint.anchor.equals((Object)Anchor.EAST)) {
            n3 = this.getWidth() - n - insets.right;
            n4 = (this.getHeight() - n2) / 2;
        } else if (paint.anchor.equals((Object)Anchor.WEST)) {
            n3 = insets.left;
            n4 = (this.getHeight() - n2) / 2;
        }
        icon.paintIcon(this, graphics, n3, n4);
    }

    private static class Paint {
        private Object background;
        private Anchor anchor;

        private Paint() {
        }
    }
}

