/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.japura.gui.Images;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = -260221785668861855L;
    private Cursor mouseOverCursor;

    public LinkLabel() {
        ImageIcon imageIcon = new ImageIcon(Images.LINK_HAND);
        this.mouseOverCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(12, 6), "linkHand");
        this.putClientProperty("html.disable", Boolean.TRUE);
        this.setForeground(Color.BLUE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LinkLabel.this.doClick();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LinkLabel.this.setCursor(LinkLabel.this.mouseOverCursor);
            }
        });
    }

    public void doClick() {
        if (this.isEnabled()) {
            this.fireActionPerformed();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Insets insets = this.getInsets();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String string = this.getText();
        if (string.length() > 0) {
            if (this.isEnabled()) {
                graphics2D.setColor(this.getForeground());
            } else {
                Color color = UIManager.getColor("Label.disabledForeground");
                if (color == null) {
                    color = Color.LIGHT_GRAY;
                }
                graphics2D.setColor(color);
            }
            int n = insets.left;
            Icon icon = this.getIcon();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, string.length());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (this.getVerticalTextPosition() == 0) {
                int n2;
                if (icon != null) {
                    n2 = (this.getHeight() - icon.getIconHeight()) / 2;
                    n2 = Math.max(0, n2);
                    icon.paintIcon(this, graphics2D, n, n2);
                    n += icon.getIconWidth() + this.getIconTextGap();
                }
                n2 = (this.getHeight() - (insets.bottom + insets.top + fontMetrics.getHeight())) / 2;
                graphics2D.drawString(attributedString.getIterator(), n, insets.top + fontMetrics.getAscent() + fontMetrics.getLeading() + n2);
            } else if (this.getVerticalTextPosition() == 1) {
                if (icon != null) {
                    icon.paintIcon(this, graphics2D, n, insets.top);
                    n += icon.getIconWidth() + this.getIconTextGap();
                }
                graphics2D.drawString(attributedString.getIterator(), n, insets.top + fontMetrics.getAscent() + fontMetrics.getLeading());
            } else if (this.getVerticalTextPosition() == 3) {
                if (icon != null) {
                    icon.paintIcon(this, graphics2D, n, this.getHeight() - (insets.bottom + icon.getIconHeight()));
                    n += icon.getIconWidth() + this.getIconTextGap();
                }
                graphics2D.drawString(attributedString.getIterator(), n, this.getHeight() - (insets.bottom + fontMetrics.getDescent()));
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listenerList.add(ActionListener.class, actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listenerList.remove(ActionListener.class, actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        ActionListener[] actionListenerArray;
        ActionEvent actionEvent = new ActionEvent(this, 1001, "linkClicked", System.currentTimeMillis(), 0);
        for (ActionListener actionListener : actionListenerArray = (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

