/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.japura.gui.renderer.HorizontalLineFactory;
import org.japura.gui.renderer.HorizontalLineRenderer;

public class LabelSeparator
extends JComponent {
    public static final Align LEFT = Align.LEFT;
    public static final Align RIGHT = Align.RIGHT;
    private JLabel label;
    private int leftSeparatorWidth = 10;
    private int rightSeparatorWidth = 30;
    private int separatorGap = 5;
    private Align align = Align.LEFT;
    private HorizontalLineRenderer lineRenderer;

    public LabelSeparator(String string) {
        this();
        this.label.setText(string);
    }

    public void setText(String string) {
        this.label.setText(string);
        this.revalidate();
    }

    public LabelSeparator() {
        this.setLayout(null);
        this.setOpaque(false);
        this.label = new JLabel();
        this.add(this.label);
        this.lineRenderer = HorizontalLineFactory.createLoweredEtchedLine();
    }

    @Override
    public final void setForeground(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public final void setFont(Font font) {
        this.label.setFont(font);
    }

    @Override
    public final Font getFont() {
        return this.label.getFont();
    }

    @Override
    public final FontMetrics getFontMetrics(Font font) {
        return this.label.getFontMetrics(font);
    }

    public HorizontalLineRenderer getLineRenderer() {
        return this.lineRenderer;
    }

    public void setLineRenderer(HorizontalLineRenderer horizontalLineRenderer) {
        this.lineRenderer = horizontalLineRenderer;
    }

    public int getLeftSeparatorWidth() {
        return this.leftSeparatorWidth;
    }

    public final void setLeftSeparatorWidth(int n) {
        this.leftSeparatorWidth = Math.max(0, n);
    }

    public int getRightSeparatorWidth() {
        return this.rightSeparatorWidth;
    }

    public final void setRightSeparatorWidth(int n) {
        this.rightSeparatorWidth = Math.max(0, n);
    }

    public int getSeparatorGap() {
        return this.separatorGap;
    }

    public final void setSeparatorGap(int n) {
        this.separatorGap = Math.max(0, n);
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        boolean bl = true;
        if (this.label.getText() == null || this.label.getText().length() == 0) {
            bl = false;
        }
        Dimension dimension = this.label.getMinimumSize();
        if (this.leftSeparatorWidth > 0) {
            dimension.width += this.leftSeparatorWidth;
            if (bl) {
                dimension.width += this.separatorGap;
            }
        }
        if (this.rightSeparatorWidth > 0) {
            dimension.width += this.rightSeparatorWidth;
            if (bl) {
                dimension.width += this.separatorGap;
            }
        }
        return dimension;
    }

    @Override
    public final void doLayout() {
        int n = 0;
        if (this.align.equals((Object)Align.LEFT)) {
            if (this.leftSeparatorWidth > 0) {
                n = this.leftSeparatorWidth + this.separatorGap;
            }
        } else if (this.align.equals((Object)Align.RIGHT)) {
            n = this.getWidth();
            Font font = this.label.getFont();
            FontMetrics fontMetrics = this.label.getFontMetrics(font);
            n -= fontMetrics.stringWidth(this.label.getText());
            if (this.rightSeparatorWidth > 0) {
                n -= this.rightSeparatorWidth + this.separatorGap;
            }
        }
        this.label.setBounds(n, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.lineRenderer == null) {
            return;
        }
        boolean bl = true;
        if (this.label.getText() == null || this.label.getText().length() == 0) {
            bl = false;
        }
        Font font = this.label.getFont();
        FontMetrics fontMetrics = this.label.getFontMetrics(font);
        int n = this.getHeight() / 2;
        if (bl) {
            int n2 = 0;
            if (this.align.equals((Object)Align.LEFT)) {
                if (this.leftSeparatorWidth > 0) {
                    n2 = this.leftSeparatorWidth;
                }
            } else if (this.align.equals((Object)Align.RIGHT)) {
                n2 = this.getWidth();
                n2 -= fontMetrics.stringWidth(this.label.getText());
                if (this.rightSeparatorWidth > 0) {
                    n2 -= this.separatorGap;
                    n2 -= this.rightSeparatorWidth;
                }
                if (this.getWidth() - n2 > 0) {
                    n2 -= this.separatorGap;
                }
            }
            if (n2 > 0) {
                this.lineRenderer.drawLine(graphics2D, 0, n2, n);
                n2 += this.separatorGap;
            }
            this.lineRenderer.drawLine(graphics2D, n2 += this.separatorGap + fontMetrics.stringWidth(this.label.getText()), this.getWidth(), n);
        } else {
            this.lineRenderer.drawLine(graphics2D, 0, this.getWidth(), n);
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        boolean bl = true;
        if (this.label.getText() == null || this.label.getText().length() == 0) {
            bl = false;
        }
        Dimension dimension = this.label.getPreferredSize();
        if (this.leftSeparatorWidth > 0) {
            dimension.width += this.leftSeparatorWidth;
            if (bl) {
                dimension.width += this.separatorGap;
            }
        }
        if (this.rightSeparatorWidth > 0) {
            dimension.width += this.separatorGap + this.rightSeparatorWidth;
            if (bl) {
                dimension.width += this.separatorGap;
            }
        }
        return dimension;
    }

    public static enum Align {
        LEFT,
        RIGHT;

    }
}

