/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.japura.gui.ButtonTextField;
import org.japura.gui.renderer.HighlightCellRenderer;

public class DynamicList<T> {
    private JPopupMenu optionsPopup;
    private JComponent invoker;
    private JTextField field;
    private JPanel root;
    private JList list;
    private DefaultListModel model;
    private List<T> options;
    private boolean caseSensitive;

    public DynamicList(ButtonTextField buttonTextField, List<T> list) {
        this(buttonTextField, list, false);
    }

    public DynamicList(ButtonTextField buttonTextField, List<T> list, boolean bl) {
        this.invoker = buttonTextField;
        this.init(buttonTextField.getField(), list, bl);
    }

    public DynamicList(JTextField jTextField, List<T> list) {
        this(jTextField, list, false);
    }

    public DynamicList(JTextField jTextField, List<T> list, boolean bl) {
        this.invoker = jTextField;
        this.init(jTextField, list, bl);
    }

    private void init(JTextField jTextField, List<T> list, boolean bl) {
        this.field = jTextField;
        this.caseSensitive = bl;
        this.options = list;
        this.setCellRenderer(new HighlightCellRenderer(bl));
        this.model = new DefaultListModel();
        for (T t : list) {
            String string = t.toString();
            this.model.addElement(string);
        }
        this.getList().setModel(this.model);
        this.getOptionsPopup().setPreferredSize(this.getOptionsPopup().getPreferredSize());
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 27) {
                    DynamicList.this.rebuildModel(true);
                }
                if (keyEvent.getKeyCode() == 40) {
                    DynamicList.this.getList().requestFocus();
                    if (DynamicList.this.getList().getSelectedIndex() == -1 && DynamicList.this.model.size() > 0) {
                        DynamicList.this.getList().setSelectedIndex(0);
                    }
                } else {
                    DynamicList.this.getField().requestFocus();
                }
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return this.getList().getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.getList().setCellRenderer(listCellRenderer);
    }

    private void chooseSelectedListItem() {
        if (this.getList().getSelectedIndex() > -1) {
            Object e = this.getList().getSelectedValue();
            this.getField().setText(e.toString());
            this.rebuildModel(false);
        }
    }

    private JTextField getField() {
        return this.field;
    }

    private JPopupMenu getOptionsPopup() {
        if (this.optionsPopup == null) {
            this.optionsPopup = new JPopupMenu();
            this.optionsPopup.add(this.getRoot());
        }
        return this.optionsPopup;
    }

    private JPanel getRoot() {
        if (this.root == null) {
            this.root = new JPanel();
            this.root.setLayout(new GridLayout(1, 1));
            JScrollPane jScrollPane = new JScrollPane(this.getList());
            jScrollPane.setBorder(null);
            this.root.add(jScrollPane);
        }
        return this.root;
    }

    private void rebuildModel(boolean bl) {
        String string = this.getField().getText();
        if (!this.caseSensitive) {
            string = string.toLowerCase();
        }
        if (this.getCellRenderer() instanceof HighlightCellRenderer) {
            HighlightCellRenderer highlightCellRenderer = (HighlightCellRenderer)this.getCellRenderer();
            highlightCellRenderer.setHighlightText(string);
        }
        this.model = new DefaultListModel();
        for (Object e : this.options) {
            String string2 = e.toString();
            if (!this.caseSensitive) {
                string2 = string2.toLowerCase();
            }
            if (string2.length() != 0 && string2.indexOf(string) <= -1) continue;
            this.model.addElement(e);
        }
        this.getList().setModel(this.model);
        if (bl && this.model.getSize() > 0) {
            this.getOptionsPopup().show(this.invoker, 0, this.invoker.getHeight());
        } else {
            this.getOptionsPopup().setVisible(false);
        }
    }

    public T getItem() {
        String string = this.getField().getText();
        if (!this.caseSensitive) {
            string = string.toLowerCase();
        }
        for (T t : this.options) {
            String string2 = t.toString();
            if (!this.caseSensitive) {
                string2 = string2.toLowerCase();
            }
            if (!string2.equals(string)) continue;
            return t;
        }
        return null;
    }

    public void setItem(T t) {
        if (t == null) {
            this.getField().setText("");
        } else if (this.options.contains(t)) {
            this.getField().setText(t.toString());
        }
    }

    public int getAvailableItemsCount() {
        return this.model.getSize();
    }

    public void showDynamicList() {
        this.rebuildModel(true);
    }

    private JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        DynamicList.this.chooseSelectedListItem();
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        DynamicList.this.chooseSelectedListItem();
                    }
                }
            });
        }
        return this.list;
    }
}

