/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import org.japura.gui.Anchor;

public class Decorator
extends JLayeredPane {
    private static final long serialVersionUID = -3654610014150907569L;
    public static final Direction VERTICAL = Direction.VERTICAL;
    public static final Direction HORIZONTAL = Direction.HORIZONTAL;
    private LinkedHashMap<String, Component> decorations = new LinkedHashMap();
    private Component component;
    private Anchor anchor;
    private Direction direction;
    private Insets margin;
    private int gap = 3;

    public Decorator(Component component) {
        this(component, Anchor.SOUTH_EAST, Direction.HORIZONTAL);
    }

    public Decorator(Component component, Anchor anchor) {
        this(component, anchor, Direction.HORIZONTAL);
    }

    public Decorator(Component component, Anchor anchor, Direction direction) {
        this.component = component;
        this.anchor = anchor;
        this.direction = direction;
        this.margin = new Insets(0, 0, 0, 0);
        super.add(component);
        if (component instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)component;
            jScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    Decorator.this.revalidate();
                }
            });
        }
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDecorationVisible(String string, boolean bl) {
        if (this.decorations.containsKey(string)) {
            this.decorations.get(string).setVisible(bl);
        }
    }

    public final void setDecorationsVisible(boolean bl) {
        for (String string : this.decorations.keySet()) {
            this.decorations.get(string).setVisible(bl);
        }
    }

    public final void addDecoration(String string, ImageIcon imageIcon) {
        this.put(string, new JLabel(imageIcon));
    }

    public final String addDecoration(ImageIcon imageIcon) {
        return this.addWithRandomID(new JLabel(imageIcon));
    }

    public final void addDecoration(String string, Component component) {
        this.put(string, component);
    }

    public final String addDecoration(Component component) {
        return this.addWithRandomID(component);
    }

    public final void removeDecoration(String string) {
        if (this.decorations.containsKey(string)) {
            Component component = (Component)this.decorations.remove(string);
            super.remove(component);
        }
    }

    public final void removeDecorations() {
        for (Component component : this.decorations.values()) {
            super.remove(component);
        }
        this.decorations.clear();
    }

    private void put(String string, Component component) {
        if (string != null && !this.decorations.containsKey(string)) {
            this.decorations.put(string, component);
            super.add(component, (Object)(JLayeredPane.MODAL_LAYER - 1));
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public final void setMargin(Insets insets) {
        if (insets != null) {
            insets.bottom = Math.max(0, insets.bottom);
            insets.left = Math.max(0, insets.left);
            insets.right = Math.max(0, insets.right);
            insets.top = Math.max(0, insets.top);
            this.margin = insets;
        } else {
            this.margin = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension dimension = this.component.getPreferredSize();
        dimension.height += this.margin.bottom + this.margin.top;
        dimension.width += this.margin.left + this.margin.right;
        return dimension;
    }

    @Override
    public final Component add(Component component, int n) {
        this.addWithRandomID(component);
        return null;
    }

    @Override
    public final void add(Component component, Object object, int n) {
        this.addWithRandomID(component);
    }

    @Override
    public final void add(Component component, Object object) {
        this.addWithRandomID(component);
    }

    @Override
    public final Component add(Component component) {
        this.addWithRandomID(component);
        return null;
    }

    @Override
    public final Component add(String string, Component component) {
        this.addWithRandomID(component);
        return null;
    }

    private String addWithRandomID(Component component) {
        Random random = new Random();
        String string = Long.toString(random.nextLong());
        while (this.decorations.containsKey(string)) {
            string = Long.toString(random.nextLong());
        }
        this.addDecoration(string, component);
        return string;
    }

    @Override
    public final void remove(Component component) {
    }

    @Override
    public final void removeAll() {
    }

    @Override
    public final void doLayout() {
        block42: {
            Dimension dimension;
            block40: {
                block49: {
                    block48: {
                        block47: {
                            int n;
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block41: {
                                                dimension = this.getSize();
                                                this.component.setBounds(this.margin.left, this.margin.top, dimension.width - (this.margin.left + this.margin.right), dimension.height - (this.margin.bottom + this.margin.top));
                                                if (this.component instanceof JScrollPane) {
                                                    JScrollPane jScrollPane = (JScrollPane)this.component;
                                                    dimension = jScrollPane.getSize();
                                                    if (jScrollPane.getVerticalScrollBar().isShowing()) {
                                                        dimension.width -= jScrollPane.getVerticalScrollBar().getSize().width;
                                                    }
                                                    if (jScrollPane.getHorizontalScrollBar().isShowing()) {
                                                        dimension.height -= jScrollPane.getHorizontalScrollBar().getSize().height;
                                                    }
                                                }
                                                if (!this.direction.equals((Object)Direction.HORIZONTAL)) break block40;
                                                int n2 = 0;
                                                n = 0;
                                                for (Component object : this.decorations.values()) {
                                                    if (!object.isVisible()) continue;
                                                    Dimension dimension2 = object.getPreferredSize();
                                                    n += dimension2.width;
                                                    ++n2;
                                                }
                                                n += this.gap * (n2 - 1);
                                                if (!this.anchor.equals((Object)Anchor.CENTER)) break block41;
                                                int n3 = (dimension.width - n) / 2;
                                                for (Component component : this.decorations.values()) {
                                                    if (!component.isVisible()) continue;
                                                    Dimension dimension3 = component.getPreferredSize();
                                                    int n4 = (dimension.height - dimension3.height) / 2;
                                                    component.setBounds(n3, n4, dimension3.width, dimension3.height);
                                                    n3 += this.gap + dimension3.width;
                                                }
                                                break block42;
                                            }
                                            if (!this.anchor.equals((Object)Anchor.NORTH)) break block43;
                                            int n5 = (dimension.width - n) / 2;
                                            for (Component component : this.decorations.values()) {
                                                if (!component.isVisible()) continue;
                                                Dimension dimension4 = component.getPreferredSize();
                                                component.setBounds(n5, 0, dimension4.width, dimension4.height);
                                                n5 += this.gap + dimension4.width;
                                            }
                                            break block42;
                                        }
                                        if (!this.anchor.equals((Object)Anchor.SOUTH)) break block44;
                                        int n6 = (dimension.width - n) / 2;
                                        for (Component component : this.decorations.values()) {
                                            if (!component.isVisible()) continue;
                                            Dimension dimension5 = component.getPreferredSize();
                                            component.setBounds(n6, dimension.height - dimension5.height - 1, dimension5.width, dimension5.height);
                                            n6 += this.gap + dimension5.width;
                                        }
                                        break block42;
                                    }
                                    if (!this.anchor.equals((Object)Anchor.EAST)) break block45;
                                    for (Component component : this.decorations.values()) {
                                        if (!component.isVisible()) continue;
                                        Dimension dimension6 = component.getPreferredSize();
                                        int n5 = dimension.width - n - 1;
                                        int n6 = (dimension.height - dimension6.height) / 2;
                                        component.setBounds(n5, n6, dimension6.width, dimension6.height);
                                        n -= this.gap + dimension6.width;
                                    }
                                    break block42;
                                }
                                if (!this.anchor.equals((Object)Anchor.NORTH_EAST)) break block46;
                                for (Component component : this.decorations.values()) {
                                    if (!component.isVisible()) continue;
                                    Dimension dimension7 = component.getPreferredSize();
                                    int n7 = dimension.width - n - 1;
                                    component.setBounds(n7, 0, dimension7.width, dimension7.height);
                                    n -= this.gap + dimension7.width;
                                }
                                break block42;
                            }
                            if (!this.anchor.equals((Object)Anchor.SOUTH_EAST)) break block47;
                            for (Component component : this.decorations.values()) {
                                if (!component.isVisible()) continue;
                                Dimension dimension8 = component.getPreferredSize();
                                int n8 = dimension.width - n - 1;
                                int n9 = dimension.height - dimension8.height - 1;
                                component.setBounds(n8, n9, dimension8.width, dimension8.height);
                                n -= this.gap + dimension8.width;
                            }
                            break block42;
                        }
                        if (!this.anchor.equals((Object)Anchor.WEST)) break block48;
                        int n = 0;
                        for (Component component : this.decorations.values()) {
                            if (!component.isVisible()) continue;
                            Dimension dimension9 = component.getPreferredSize();
                            int n10 = (dimension.height - dimension9.height) / 2;
                            component.setBounds(n, n10, dimension9.width, dimension9.height);
                            n += this.gap + dimension9.width;
                        }
                        break block42;
                    }
                    if (!this.anchor.equals((Object)Anchor.NORTH_WEST)) break block49;
                    int n = 0;
                    for (Component component : this.decorations.values()) {
                        if (!component.isVisible()) continue;
                        Dimension dimension10 = component.getPreferredSize();
                        component.setBounds(n, 0, dimension10.width, dimension10.height);
                        n += this.gap + dimension10.width;
                    }
                    break block42;
                }
                if (!this.anchor.equals((Object)Anchor.SOUTH_WEST)) break block42;
                int n = 0;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension11 = component.getPreferredSize();
                    component.setBounds(n, dimension.height - dimension11.height - 1, dimension11.width, dimension11.height);
                    n += this.gap + dimension11.width;
                }
                break block42;
            }
            int n = 0;
            int n13 = 0;
            for (Component component : this.decorations.values()) {
                if (!component.isVisible()) continue;
                Dimension dimension12 = component.getPreferredSize();
                n13 += dimension12.height;
                ++n;
            }
            n13 += this.gap * (n - 1);
            if (this.anchor.equals((Object)Anchor.SOUTH_EAST)) {
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension13 = component.getPreferredSize();
                    component.setBounds(dimension.width - dimension13.width - 1, dimension.height - n13 - 1, dimension13.width, dimension13.height);
                    n13 -= this.gap + dimension13.height;
                }
            } else if (this.anchor.equals((Object)Anchor.EAST)) {
                int n14 = (dimension.height - n13) / 2;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension14 = component.getPreferredSize();
                    component.setBounds(dimension.width - dimension14.width - 1, n14, dimension14.width, dimension14.height);
                    n14 += this.gap + dimension14.height;
                }
            } else if (this.anchor.equals((Object)Anchor.NORTH_EAST)) {
                int n15 = 0;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension15 = component.getPreferredSize();
                    component.setBounds(dimension.width - dimension15.width - 1, n15, dimension15.width, dimension15.height);
                    n15 += this.gap + dimension15.height;
                }
            } else if (this.anchor.equals((Object)Anchor.SOUTH)) {
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension16 = component.getPreferredSize();
                    int n11 = (dimension.width - dimension16.width) / 2;
                    component.setBounds(n11, dimension.height - n13 - 1, dimension16.width, dimension16.height);
                    n13 -= this.gap + dimension16.height;
                }
            } else if (this.anchor.equals((Object)Anchor.CENTER)) {
                int n17 = (dimension.height - n13) / 2;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension17 = component.getPreferredSize();
                    int n12 = (dimension.width - dimension17.width) / 2;
                    component.setBounds(n12, n17, dimension17.width, dimension17.height);
                    n17 += this.gap + dimension17.height;
                }
            } else if (this.anchor.equals((Object)Anchor.NORTH)) {
                int n19 = 0;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension18 = component.getPreferredSize();
                    int n14 = (dimension.width - dimension18.width) / 2;
                    component.setBounds(n14, n19, dimension18.width, dimension18.height);
                    n19 += this.gap + dimension18.height;
                }
            } else if (this.anchor.equals((Object)Anchor.SOUTH_WEST)) {
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension19 = component.getPreferredSize();
                    component.setBounds(0, dimension.height - n13 - 1, dimension19.width, dimension19.height);
                    n13 -= this.gap + dimension19.height;
                }
            } else if (this.anchor.equals((Object)Anchor.WEST)) {
                int n21 = (dimension.height - n13) / 2;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension20 = component.getPreferredSize();
                    component.setBounds(0, n21, dimension20.width, dimension20.height);
                    n21 += this.gap + dimension20.height;
                }
            } else if (this.anchor.equals((Object)Anchor.NORTH_WEST)) {
                int n22 = 0;
                for (Component component : this.decorations.values()) {
                    if (!component.isVisible()) continue;
                    Dimension dimension21 = component.getPreferredSize();
                    component.setBounds(0, n22, dimension21.width, dimension21.height);
                    n22 += this.gap + dimension21.height;
                }
            }
        }
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

