/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

class CompoundComponent
extends JLayeredPane
implements MouseListener {
    private static final long serialVersionUID = 2895107538779323011L;
    private JComponent component;
    private JPanel glassPanel = new JPanel();
    private MouseListener mouseHandler;

    public CompoundComponent(JComboBox jComboBox) {
        this(jComboBox, null);
    }

    public CompoundComponent(JComboBox jComboBox, MouseListener mouseListener) {
        this.glassPanel.setOpaque(false);
        this.mouseHandler = mouseListener;
        this.component = jComboBox;
        this.add((Component)jComboBox, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.glassPanel, (Object)(JLayeredPane.DEFAULT_LAYER + 1));
        this.glassPanel.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.component.getPreferredSize();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.component.setEnabled(bl);
        this.glassPanel.setEnabled(bl);
    }

    @Override
    public void doLayout() {
        this.component.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.glassPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.mouseHandler != null) {
            mouseEvent.setSource(this.component);
            this.mouseHandler.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.component.requestFocusInWindow();
            if (this.mouseHandler != null) {
                mouseEvent.setSource(this.component);
                this.mouseHandler.mousePressed(mouseEvent);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            mouseEvent.setSource(this.component);
            this.component.dispatchEvent(mouseEvent);
            if (this.mouseHandler != null) {
                this.mouseHandler.mouseExited(mouseEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            mouseEvent.setSource(this.component);
            this.component.dispatchEvent(mouseEvent);
            if (this.mouseHandler != null) {
                this.mouseHandler.mouseEntered(mouseEvent);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.mouseHandler != null) {
            mouseEvent.setSource(this.component);
            this.mouseHandler.mouseClicked(mouseEvent);
        }
    }
}

