/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import org.japura.gui.CollapsiblePanel;

public class CollapsibleRootPanel
extends JPanel
implements Scrollable {
    public static final Mode FILL = Mode.FILL;
    public static final Mode SCROLL_BAR = Mode.SCROLL_BAR;
    private Mode mode;
    private List<CollapsiblePanel> panels;
    private int maxWidth;
    private int maxHeight;
    private Insets margin;
    private int panelGap = 10;

    public CollapsibleRootPanel() {
        this(Mode.SCROLL_BAR);
    }

    public CollapsibleRootPanel(Mode mode) {
        this.mode = mode;
        this.setMargin(new Insets(10, 10, 10, 10));
        this.setBackground(Color.WHITE);
        this.panels = new ArrayList<CollapsiblePanel>();
        super.setLayout(null);
        if (mode.equals((Object)FILL)) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    CollapsibleRootPanel.this.adjustEndHeights();
                }
            });
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            dimension = new Dimension();
            for (int i = 0; i < this.panels.size(); ++i) {
                CollapsiblePanel collapsiblePanel = this.panels.get(i);
                if (!collapsiblePanel.isVisible()) continue;
                Dimension dimension2 = collapsiblePanel.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += dimension2.height;
                if (i >= this.panels.size() - 1) continue;
                dimension.height += this.panelGap;
            }
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.bottom + insets.top;
            dimension.width += this.margin.left + this.margin.right;
            dimension.height += this.margin.top + this.margin.bottom;
        }
        if (!(this.getParent() instanceof JViewport)) {
            dimension.width += UIManager.getInt("ScrollBar.width");
            this.applyMax(dimension);
        }
        return dimension;
    }

    private void applyMax(Dimension dimension) {
        if (this.getMaxHeight() > 0) {
            dimension.height = Math.min(dimension.height, this.getMaxHeight());
        }
        if (this.getMaxWidth() > 0) {
            dimension.width = Math.min(dimension.width, this.getMaxWidth());
        }
    }

    @Override
    public void doLayout() {
        if (this.mode.equals((Object)Mode.FILL)) {
            this.adjustCalculatedHeights();
        }
        int n = this.margin.left;
        int n2 = this.margin.top;
        for (int i = 0; i < this.panels.size(); ++i) {
            CollapsiblePanel collapsiblePanel = this.panels.get(i);
            if (!collapsiblePanel.isVisible()) continue;
            int n3 = collapsiblePanel.getCalculatedHeight();
            collapsiblePanel.setBounds(n, n2, this.getWidth() - (this.margin.left + this.margin.right), n3);
            n2 += n3;
            if (i >= this.panels.size() - 1) continue;
            n2 += this.panelGap;
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public Component add(Component component, int n) {
        return null;
    }

    @Override
    public void add(Component component, Object object, int n) {
    }

    @Override
    public void add(Component component, Object object) {
    }

    @Override
    public Component add(Component component) {
        return null;
    }

    @Override
    public Component add(String string, Component component) {
        return null;
    }

    public void add(CollapsiblePanel collapsiblePanel, int n) {
        if (!this.panels.contains(collapsiblePanel)) {
            collapsiblePanel.weightY = Math.max(0, n);
            this.panels.add(collapsiblePanel);
            super.add(collapsiblePanel);
        }
    }

    public void remove(CollapsiblePanel collapsiblePanel) {
        this.panels.remove(collapsiblePanel);
        super.remove(collapsiblePanel);
    }

    @Override
    public void removeAll() {
        this.panels.clear();
        super.removeAll();
    }

    void adjustEndHeights() {
        double d = 0.0;
        int n = 0;
        for (CollapsiblePanel object : this.panels) {
            if (!object.isVisible()) continue;
            ++n;
            if (!object.isExpanded() && !object.isExpanding()) continue;
            d += (double)object.weightY;
        }
        int n2 = this.getHeight();
        n2 -= this.margin.top + this.margin.bottom;
        n2 -= Math.max(0, n - 1) * this.panelGap;
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            if (!collapsiblePanel.isVisible()) continue;
            if (collapsiblePanel.isCollapsed()) {
                if (collapsiblePanel.weightY > 0) {
                    n2 -= collapsiblePanel.getCalculatedHeight();
                    continue;
                }
                n2 -= collapsiblePanel.getPreferredSize().height;
                continue;
            }
            if (collapsiblePanel.isCollapsing()) {
                n2 -= collapsiblePanel.getCalculatedHeight();
                continue;
            }
            if (!collapsiblePanel.isCollapsed() && collapsiblePanel.weightY != 0) continue;
            n2 -= collapsiblePanel.getPreferredSize().height;
        }
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            if (!collapsiblePanel.isVisible() || !collapsiblePanel.isExpanding()) continue;
            if (collapsiblePanel.weightY > 0) {
                double d2 = 100.0 * (double)collapsiblePanel.weightY / d;
                double d3 = (double)n2 * d2 / 100.0;
                collapsiblePanel.setEndHeight((int)d3);
                continue;
            }
            collapsiblePanel.setEndHeight(collapsiblePanel.getPreferredSize((boolean)false).height);
        }
    }

    private void adjustCalculatedHeights() {
        double d = 0.0;
        int n = 0;
        for (CollapsiblePanel object : this.panels) {
            if (!object.isVisible()) continue;
            ++n;
            if (!object.isExpanded()) continue;
            d += (double)object.weightY;
        }
        int n2 = this.getHeight();
        n2 -= this.margin.top + this.margin.bottom;
        n2 -= Math.max(0, n - 1) * this.panelGap;
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            if (!collapsiblePanel.isVisible()) continue;
            if (collapsiblePanel.weightY > 0) {
                if (collapsiblePanel.isExpanded()) continue;
                n2 -= collapsiblePanel.getCalculatedHeight();
                continue;
            }
            if (collapsiblePanel.isCollapsed() || collapsiblePanel.isExpanded()) {
                n2 -= collapsiblePanel.getPreferredSize().height;
                continue;
            }
            n2 -= collapsiblePanel.getCalculatedHeight();
        }
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            if (!collapsiblePanel.isVisible() || !collapsiblePanel.isExpanded()) continue;
            if (collapsiblePanel.weightY > 0) {
                double d2 = 100.0 * (double)collapsiblePanel.weightY / d;
                double d3 = (double)n2 * d2 / 100.0;
                collapsiblePanel.setCalculatedHeight((int)d3);
                continue;
            }
            collapsiblePanel.setCalculatedHeight(collapsiblePanel.getPreferredSize((boolean)false).height);
        }
    }

    public void add(CollapsiblePanel collapsiblePanel) {
        this.add(collapsiblePanel, 1);
    }

    public void expandAll() {
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            collapsiblePanel.expand();
        }
    }

    public void collapseAll() {
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            collapsiblePanel.collapse();
        }
    }

    public void setLockAllEnabled(boolean bl) {
        for (CollapsiblePanel collapsiblePanel : this.panels) {
            collapsiblePanel.setLockEnabled(bl);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width += UIManager.getInt("ScrollBar.width");
        this.applyMax(dimension);
        return dimension;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        JViewport jViewport;
        return this.getParent() instanceof JViewport && (jViewport = (JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = Math.max(n, 0);
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = Math.max(n, 0);
    }

    public Mode getMode() {
        return this.mode;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public final void setMargin(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.bottom = Math.max(insets.bottom, 0);
            insets.left = Math.max(insets.left, 0);
            insets.top = Math.max(insets.top, 0);
            insets.right = Math.max(insets.right, 0);
        }
        this.margin = insets;
    }

    public int getPanelGap() {
        return this.panelGap;
    }

    public void setPanelGap(int n) {
        this.panelGap = Math.max(0, n);
    }

    public static enum Mode {
        SCROLL_BAR,
        FILL;

    }
}

