/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.japura.gui.CollapsibleRootPanel;
import org.japura.gui.Gradient;
import org.japura.gui.Images;
import org.japura.gui.event.CollapsiblePanelEvent;
import org.japura.gui.event.CollapsiblePanelListener;

public class CollapsiblePanel
extends JComponent {
    private static Icon defaultExpandIcon = new ImageIcon(Images.EXPAND_BLACK);
    private static Icon defaultCollapseIcon = new ImageIcon(Images.COLLAPSE_BLACK);
    private static Object defaultTitleBackground = new Gradient(Gradient.TOP_TO_BOTTOM, new Color(160, 190, 255), new Color(240, 240, 255));
    private Icon iconDown;
    private Icon iconUp;
    private JLabel titleIcon;
    private JLabel titleLabel;
    private JLabel titleButton;
    private int titleSeparator = 1;
    private int titleMargin = 3;
    private int iconTitlePadding = 5;
    private int titleButtonsPadding = 5;
    private int buttonsPadding = 5;
    private JLayeredPane layeredPane;
    private JPanel modal;
    private Component component;
    private boolean collapsed;
    private boolean inAction;
    private boolean locked;
    private boolean animationEnabled = true;
    private transient ActionListener collapseListener;
    private transient ActionListener expandListener;
    private Timer collapseTimer;
    private Timer expandTimer;
    private int incremental = 3;
    private int pixels;
    private Object titleBackground;
    private Color separatorColor = new Color(0, 0, 0, 80);
    private JPanel titlePanel;
    private JPanel innerTitlePanel;
    private EventListenerList listeners = new EventListenerList();
    private JComponent[] extraButtons;
    private Icon icon;
    private int endHeight;
    private int calculatedHeight = -1;
    int weightY = 1;

    public CollapsiblePanel() {
        this(null, "", null);
    }

    public CollapsiblePanel(String string) {
        this(null, string, null);
    }

    public CollapsiblePanel(Icon icon, String string) {
        this(icon, string, null);
    }

    public CollapsiblePanel(String string, JComponent[] jComponentArray) {
        this(null, string, jComponentArray);
    }

    public CollapsiblePanel(Icon icon, String string, JComponent[] jComponentArray) {
        this.modal = new JPanel();
        this.modal.setOpaque(false);
        this.modal.addMouseListener(new MouseAdapter(){});
        this.titleBackground = defaultTitleBackground;
        this.layeredPane = new JLayeredPane();
        this.layeredPane.add((Component)this.modal, JLayeredPane.MODAL_LAYER);
        super.add(this.layeredPane);
        this.setBorder(BorderFactory.createLineBorder(this.separatorColor));
        this.setLayout(null);
        this.setOpaque(false);
        this.icon = icon;
        this.setTitle(string);
        this.iconDown = defaultExpandIcon;
        this.iconUp = defaultCollapseIcon;
        this.titleButton = new JLabel();
        this.titleButton.setIcon(this.iconUp);
        super.add(this.getTitlePanel());
        this.extraButtons = jComponentArray;
        this.buildTitlePanel();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = CollapsiblePanel.this.getInnerTitlePanel().getY() - CollapsiblePanel.this.titleMargin;
                int n2 = CollapsiblePanel.this.getInnerTitlePanel().getY() + CollapsiblePanel.this.getInnerTitlePanel().getHeight() + CollapsiblePanel.this.titleMargin;
                if (mouseEvent.getPoint().y > n && mouseEvent.getPoint().y < n2) {
                    CollapsiblePanel.this.buttonAction();
                }
            }
        });
    }

    public void removeExtraButtons() {
        this.extraButtons = null;
        this.buildTitlePanel();
    }

    public void setExtraButtons(JComponent[] jComponentArray) {
        this.extraButtons = jComponentArray;
        this.buildTitlePanel();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = 0;
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getNorthPreferredHeight();
        this.getTitlePanel().setBounds(n, n2, n3, n4);
        if (this.component != null) {
            if (!this.collapsed || this.inAction) {
                Dimension dimension = this.component.getPreferredSize();
                n = insets.left;
                n2 += n4 + this.titleSeparator;
                n4 = this.getHeight() - n2 - insets.bottom;
                this.layeredPane.setBounds(n, n2, n3, n4);
                n2 = Math.min(this.layeredPane.getHeight() - dimension.height, 0);
                if (this.isFillMode()) {
                    this.component.setBounds(0, 0, n3, n4);
                } else {
                    this.component.setBounds(0, n2, n3, this.layeredPane.getHeight() - n2);
                }
                if (this.inAction) {
                    this.modal.setBounds(0, n2, n3, this.layeredPane.getHeight() - n2);
                } else {
                    this.modal.setBounds(0, 0, 0, 0);
                }
            } else {
                this.layeredPane.setBounds(0, 0, 0, 0);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n = this.getInnerTitlePanel().getY() - this.titleMargin;
        int n2 = this.getInnerTitlePanel().getHeight() + 2 * this.titleMargin;
        if (this.hasTitleBackgroundGradient()) {
            GradientPaint gradientPaint = null;
            Gradient gradient = (Gradient)this.getTitleBackground();
            Gradient.Direction direction = gradient.getDirection();
            Color color = gradient.getFirstColor();
            Color color2 = gradient.getSecondColor();
            if (direction.equals((Object)Gradient.Direction.TOP_TO_BOTTOM)) {
                gradientPaint = new GradientPaint(0.0f, n, color, 0.0f, n + n2, color2);
            } else if (direction.equals((Object)Gradient.Direction.BOTTOM_TO_TOP)) {
                gradientPaint = new GradientPaint(0.0f, n, color2, 0.0f, n + n2, color);
            } else if (direction.equals((Object)Gradient.Direction.LEFT_TO_RIGHT)) {
                gradientPaint = new GradientPaint(insets.left, 0.0f, color, this.getWidth() - (insets.left + insets.right), 0.0f, color2);
            } else if (direction.equals((Object)Gradient.Direction.RIGHT_TO_LEFT)) {
                gradientPaint = new GradientPaint(insets.left, 0.0f, color2, this.getWidth() - (insets.left + insets.right), 0.0f, color);
            }
            graphics2D.setPaint(gradientPaint);
        } else {
            Color color = (Color)this.getTitleBackground();
            graphics2D.setColor(color);
        }
        graphics2D.fillRect(insets.left, n, this.getWidth() - (insets.left + insets.right), n2);
        graphics2D.setColor(this.getSeparatorColor());
        graphics2D.fillRect(insets.left, n += n2, this.getWidth() - (insets.left + insets.right), this.titleSeparator);
    }

    @Override
    protected final void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            int n = this.getInnerTitlePanel().getY() - this.getInsets().top - this.titleMargin;
            border.paintBorder(this, graphics, 0, n, this.getWidth(), this.getHeight() - n);
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.getPreferredSize(this.collapsed);
    }

    protected Dimension getPreferredSize(boolean bl) {
        Dimension dimension = new Dimension(this.titlePanel.getPreferredSize());
        dimension.height = this.getNorthPreferredHeight();
        Dimension dimension2 = null;
        dimension2 = this.component != null ? this.component.getPreferredSize() : new Dimension();
        if (!bl && this.component != null) {
            dimension.height += this.titleSeparator;
            dimension.height += dimension2.height;
        }
        dimension.width = Math.max(dimension.width, dimension2.width);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.bottom;
        return dimension;
    }

    public void removeIcon() {
        this.icon = null;
        this.buildTitlePanel();
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.buildTitlePanel();
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel();
        }
        return this.titleLabel;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setOpaque(false);
            this.titlePanel.setLayout(new GridBagLayout());
        }
        return this.titlePanel;
    }

    private void buildTitlePanel() {
        this.getTitlePanel().removeAll();
        this.titleIcon = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        if (this.icon != null) {
            this.titleIcon = new JLabel(this.icon);
            gridBagConstraints.insets = new Insets(this.titleMargin, this.titleMargin, this.titleMargin, this.iconTitlePadding);
            this.getTitlePanel().add((Component)this.titleIcon, gridBagConstraints);
            gridBagConstraints.insets = new Insets(this.titleMargin, 0, this.titleMargin, this.titleMargin);
        } else {
            gridBagConstraints.insets = new Insets(this.titleMargin, this.titleMargin, this.titleMargin, this.titleMargin);
        }
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.buildInnerTitlePanel();
        this.getTitlePanel().add((Component)this.getInnerTitlePanel(), gridBagConstraints);
        this.getTitlePanel().revalidate();
    }

    private void buildInnerTitlePanel() {
        this.getInnerTitlePanel().removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, this.titleButtonsPadding);
        this.getInnerTitlePanel().add((Component)this.getTitleLabel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        if (this.extraButtons != null) {
            for (int i = 0; i < this.extraButtons.length; ++i) {
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, this.buttonsPadding);
                this.getInnerTitlePanel().add((Component)this.extraButtons[i], gridBagConstraints);
            }
        }
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getInnerTitlePanel().add((Component)this.titleButton, gridBagConstraints);
        this.getInnerTitlePanel().revalidate();
    }

    private JPanel getInnerTitlePanel() {
        if (this.innerTitlePanel == null) {
            this.innerTitlePanel = new JPanel();
            this.innerTitlePanel.setOpaque(false);
            this.innerTitlePanel.setLayout(new GridBagLayout());
        }
        return this.innerTitlePanel;
    }

    private int getNorthPreferredHeight() {
        Insets insets = this.getInsets();
        int n = this.getInnerTitlePanel().getPreferredSize().height;
        n += 2 * this.titleMargin;
        int n2 = 0;
        if (this.titleIcon != null) {
            n2 = this.titleIcon.getPreferredSize().height;
            n2 += this.titleMargin + insets.top;
        } else {
            n += insets.top;
        }
        return Math.max(n, n2);
    }

    public void setSeparatorThickness(int n) {
        this.titleSeparator = Math.max(0, n);
    }

    public boolean isCollapsed() {
        return this.collapsed && !this.inAction;
    }

    public boolean isCollapsing() {
        return !this.collapsed && this.inAction;
    }

    public boolean isExpanded() {
        return !this.collapsed && !this.inAction;
    }

    public boolean isExpanding() {
        return this.collapsed && this.inAction;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean bl) {
        if (!this.inAction) {
            this.animationEnabled = bl;
        }
    }

    public void setSpeed(int n) {
        this.incremental = Math.max(n, 1);
    }

    public int getSpeed() {
        return this.incremental;
    }

    @Override
    public void remove(Component component) {
        if (this.component.equals(component)) {
            this.removeView();
        }
    }

    @Override
    public void remove(int n) {
    }

    @Override
    public void removeAll() {
        this.removeView();
    }

    private void removeView() {
        if (this.component != null) {
            super.remove(this.component);
            this.component = null;
        }
    }

    private void setView(Component component) {
        this.removeView();
        if (component != null) {
            this.component = component;
            this.layeredPane.add(component, JLayeredPane.DEFAULT_LAYER);
        }
    }

    @Override
    public Component add(Component component, int n) {
        this.setView(component);
        return component;
    }

    @Override
    public void add(Component component, Object object, int n) {
        this.setView(component);
    }

    @Override
    public void add(Component component, Object object) {
        this.setView(component);
    }

    @Override
    public Component add(Component component) {
        this.setView(component);
        return component;
    }

    @Override
    public Component add(String string, Component component) {
        this.setView(component);
        return component;
    }

    private ActionListener getExpandListener() {
        if (this.expandListener == null) {
            this.expandListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CollapsiblePanel.this.calculatedHeight += CollapsiblePanel.this.pixels;
                    CollapsiblePanel.this.pixels += CollapsiblePanel.this.incremental;
                    CollapsiblePanel.this.revalidate();
                    if (CollapsiblePanel.this.calculatedHeight >= CollapsiblePanel.this.endHeight) {
                        CollapsiblePanel.this.changeStatus();
                    }
                }
            };
        }
        return this.expandListener;
    }

    private ActionListener getCollapseListener() {
        if (this.collapseListener == null) {
            this.collapseListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CollapsiblePanel.this.calculatedHeight -= CollapsiblePanel.this.pixels;
                    CollapsiblePanel.this.pixels += CollapsiblePanel.this.incremental;
                    CollapsiblePanel.this.revalidate();
                    if (CollapsiblePanel.this.calculatedHeight <= CollapsiblePanel.this.endHeight) {
                        CollapsiblePanel.this.changeStatus();
                    }
                }
            };
        }
        return this.collapseListener;
    }

    private void changeStatus() {
        CollapsiblePanelListener[] collapsiblePanelListenerArray;
        if (this.collapsed) {
            this.getExpandTimer().stop();
            this.setIconUp();
            this.calculatedHeight = -1;
        } else {
            this.calculatedHeight = this.getCollapsedHeight();
            this.getCollapseTimer().stop();
            this.setIconDown();
        }
        this.revalidate();
        this.collapsed = !this.collapsed;
        this.inAction = false;
        for (CollapsiblePanelListener collapsiblePanelListener : collapsiblePanelListenerArray = (CollapsiblePanelListener[])this.listeners.getListeners(CollapsiblePanelListener.class)) {
            if (this.collapsed) {
                collapsiblePanelListener.panelCollapsed(new CollapsiblePanelEvent(this));
                continue;
            }
            collapsiblePanelListener.panelExpanded(new CollapsiblePanelEvent(this));
        }
    }

    private Timer getCollapseTimer() {
        if (this.collapseTimer == null) {
            this.collapseTimer = new Timer(25, this.getCollapseListener());
        }
        return this.collapseTimer;
    }

    private Timer getExpandTimer() {
        if (this.expandTimer == null) {
            this.expandTimer = new Timer(25, this.getExpandListener());
        }
        return this.expandTimer;
    }

    public boolean isLockEnabled() {
        return this.locked;
    }

    public void setLockEnabled(boolean bl) {
        this.locked = bl;
        this.titleButton.setVisible(!bl);
    }

    public void collapseImmediately() {
        this.collapse(true);
    }

    public void collapse() {
        this.collapse(false);
    }

    private int getCollapsedHeight() {
        Insets insets = this.getInsets();
        return this.getNorthPreferredHeight() + insets.bottom;
    }

    private void collapse(boolean bl) {
        if (!(this.locked || this.inAction || this.collapsed)) {
            CollapsiblePanelListener[] collapsiblePanelListenerArray;
            this.inAction = true;
            for (CollapsiblePanelListener collapsiblePanelListener : collapsiblePanelListenerArray = (CollapsiblePanelListener[])this.listeners.getListeners(CollapsiblePanelListener.class)) {
                collapsiblePanelListener.panelWillCollapse(new CollapsiblePanelEvent(this));
            }
            this.pixels = this.incremental;
            if (this.isAnimationEnabled() && !bl) {
                this.calculatedHeight = this.getSize().height;
                this.endHeight = this.getCollapsedHeight();
                this.getCollapseTimer().start();
            } else {
                this.changeStatus();
            }
        }
    }

    public void expandImmediately() {
        this.expand(true);
    }

    public void expand() {
        this.expand(false);
    }

    private void expand(boolean bl) {
        if (!this.locked && !this.inAction && this.collapsed) {
            CollapsiblePanelListener[] collapsiblePanelListenerArray;
            this.inAction = true;
            for (CollapsiblePanelListener collapsiblePanelListener : collapsiblePanelListenerArray = (CollapsiblePanelListener[])this.listeners.getListeners(CollapsiblePanelListener.class)) {
                collapsiblePanelListener.panelWillExpand(new CollapsiblePanelEvent(this));
            }
            this.pixels = this.incremental;
            if (this.isAnimationEnabled() && !bl) {
                this.calculatedHeight = this.getSize().height;
                if (this.isFillMode()) {
                    this.setEndHeights();
                } else {
                    this.endHeight = this.getPreferredSize((boolean)false).height;
                }
                this.getExpandTimer().start();
            } else {
                this.changeStatus();
            }
        }
    }

    private boolean isCollapsiblePanelRootExists() {
        return SwingUtilities.getAncestorOfClass(CollapsibleRootPanel.class, this) != null;
    }

    private void buttonAction() {
        if (this.isCollapsiblePanelRootExists() && !this.locked && !this.inAction) {
            if (this.collapsed) {
                this.expand();
            } else {
                this.collapse();
            }
        }
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color color) {
        this.separatorColor = color;
    }

    @Override
    public Font getFont() {
        return this.getTitleLabel().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getTitleLabel().setFont(font);
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.getTitleLabel().setText(string);
    }

    public void setTitleForeground(Color color) {
        this.getTitleLabel().setForeground(color);
    }

    public Color getTitleForeground() {
        return this.getTitleLabel().getForeground();
    }

    public void setTitleBackground(Color color) {
        if (color != null) {
            this.titleBackground = color;
        }
    }

    public void setTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            this.titleBackground = gradient;
        }
    }

    public Object getTitleBackground() {
        return this.titleBackground;
    }

    public boolean hasTitleBackgroundGradient() {
        return this.titleBackground instanceof Gradient;
    }

    public int getTitleMargin() {
        return this.titleMargin;
    }

    public void setTitleMargin(int n) {
        this.titleMargin = Math.max(0, n);
    }

    private void setIconDown() {
        this.titleButton.setIcon(this.iconDown);
    }

    private void setIconUp() {
        this.titleButton.setIcon(this.iconUp);
    }

    public void setIcons(Icon icon, Icon icon2) {
        if (!this.inAction) {
            this.iconUp = icon;
            this.iconDown = icon2;
            if (this.collapsed) {
                this.setIconDown();
            } else {
                this.setIconUp();
            }
        }
    }

    public void addCollapsiblePanelListener(CollapsiblePanelListener collapsiblePanelListener) {
        this.listeners.add(CollapsiblePanelListener.class, collapsiblePanelListener);
    }

    public void removeCollapsiblePanelListener(CollapsiblePanelListener collapsiblePanelListener) {
        this.listeners.remove(CollapsiblePanelListener.class, collapsiblePanelListener);
    }

    public boolean isInAction() {
        return this.inAction;
    }

    private void setEndHeights() {
        Container container = this.getParent();
        if (container != null && container instanceof CollapsibleRootPanel) {
            CollapsibleRootPanel collapsibleRootPanel = (CollapsibleRootPanel)container;
            collapsibleRootPanel.adjustEndHeights();
        }
    }

    private boolean isFillMode() {
        CollapsibleRootPanel collapsibleRootPanel;
        Container container = this.getParent();
        return container != null && container instanceof CollapsibleRootPanel && (collapsibleRootPanel = (CollapsibleRootPanel)container).getMode().equals((Object)CollapsibleRootPanel.FILL);
    }

    void setCalculatedHeight(int n) {
        this.calculatedHeight = n;
    }

    int getCalculatedHeight() {
        if (this.calculatedHeight == -1) {
            this.calculatedHeight = this.getPreferredSize().height;
        }
        return this.calculatedHeight;
    }

    void setEndHeight(int n) {
        this.endHeight = n;
    }

    @Override
    public void invalidate() {
        if (!this.inAction) {
            this.calculatedHeight = -1;
        }
        super.invalidate();
    }

    public static void setDefaultExpandIcon(Icon icon) {
        if (icon == null) {
            icon = new ImageIcon(Images.EXPAND_BLACK);
        }
        defaultExpandIcon = icon;
    }

    public static void setDefaultCollapseIcon(Icon icon) {
        if (icon == null) {
            icon = new ImageIcon(Images.COLLAPSE_BLACK);
        }
        defaultCollapseIcon = icon;
    }

    public static void setDefaultBlackIcons() {
        defaultExpandIcon = new ImageIcon(Images.EXPAND_BLACK);
        defaultCollapseIcon = new ImageIcon(Images.COLLAPSE_BLACK);
    }

    public static void setDefaultWhiteIcons() {
        defaultExpandIcon = new ImageIcon(Images.EXPAND_WHITE);
        defaultCollapseIcon = new ImageIcon(Images.COLLAPSE_WHITE);
    }

    public static Object getDefaultTitleBackground() {
        return defaultTitleBackground;
    }

    public static void setDefaultTitleBackground(Color color) {
        if (color != null) {
            defaultTitleBackground = color;
        }
    }

    public static void setDefaultTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            defaultTitleBackground = gradient;
        }
    }
}

