/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.dnd.CheckListTransferHandler;
import org.japura.gui.dnd.CheckListTransferable;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.event.ListLockListener;
import org.japura.gui.event.ListModelListener;
import org.japura.gui.model.DefaultListCheckModel;
import org.japura.gui.model.ListCheckModel;
import org.japura.gui.renderer.CheckListRenderer;

public class CheckList
extends JList {
    private static final long serialVersionUID = 7562297704191604289L;
    private ListCheckModel model;
    private PopupMenuBuilder<CheckList> popupMenuBuilder;

    public CheckList() {
        InputMap inputMap = this.getInputMap(0);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = -7299012786614721676L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CheckListTransferable.toString(CheckList.this.getModel(), ", ");
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(string), null);
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(67, 2), "Copy");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("Copy", abstractAction);
        this.setModel(new DefaultListCheckModel());
        this.setCellRenderer(new CheckListRenderer());
        super.setSelectionMode(0);
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        EventListener[] eventListenerArray = mouseMotionListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            MouseMotionListener mouseMotionListener = eventListenerArray[i];
        }
        for (EventListener eventListener : eventListenerArray = this.getMouseListeners()) {
        }
        this.setTransferHandler(new CheckListTransferHandler());
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                CheckList.this.updateSelection(mouseEvent.getPoint());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CheckList.this.updateSelection(null);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = CheckList.this.locationToIndex(mouseEvent.getPoint());
                    if (n > -1) {
                        Object object = CheckList.this.getModel().getElementAt(n);
                        if (!CheckList.this.getModel().isLocked(object)) {
                            boolean bl = CheckList.this.getModel().isChecked(object);
                            if (bl) {
                                CheckList.this.getModel().removeCheck(object);
                            } else {
                                CheckList.this.getModel().addCheck(object);
                            }
                        }
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && CheckList.this.getPopupMenuBuilder() != null && (jPopupMenu = CheckList.this.getPopupMenuBuilder().buildPopupMenu(CheckList.this)) != null) {
                    jPopupMenu.show(CheckList.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public final void setSelectionModel(ListSelectionModel listSelectionModel) {
        super.setSelectionModel(new DefaultListSelectionModel());
    }

    @Override
    public final void setSelectionMode(int n) {
        super.setSelectionMode(0);
    }

    private void updateSelection(Point point) {
        if (point != null) {
            int n = this.locationToIndex(point);
            this.setSelectedIndex(n);
        } else {
            this.clearSelection();
        }
        this.repaint();
    }

    public ListCheckModel getModel() {
        if (this.model == null) {
            this.setModel(new DefaultListCheckModel());
        }
        return this.model;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer instanceof CheckListRenderer) {
            super.setCellRenderer(listCellRenderer);
        }
    }

    public void setCellRenderer(CheckListRenderer checkListRenderer) {
        super.setCellRenderer(checkListRenderer);
    }

    public CheckListRenderer getCellRenderer() {
        return (CheckListRenderer)super.getCellRenderer();
    }

    public void setPopupMenuBuilder(PopupMenuBuilder<CheckList> popupMenuBuilder) {
        this.popupMenuBuilder = popupMenuBuilder;
    }

    public PopupMenuBuilder<CheckList> getPopupMenuBuilder() {
        return this.popupMenuBuilder;
    }

    public void setModel(ListModel listModel) {
        if (!(listModel instanceof ListCheckModel)) {
            throw new IllegalArgumentException("model must be ListCheckModel");
        }
        this.setModel((ListCheckModel)listModel);
    }

    public void setModel(ListCheckModel listCheckModel) {
        if (listCheckModel == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListCheckModel listCheckModel2 = this.model;
        this.model = listCheckModel;
        if (listCheckModel2 != null) {
            this.firePropertyChange("model", listCheckModel2, listCheckModel);
        }
        listCheckModel.addListModelListener(new ListModelListener(){

            @Override
            public void valueAdded(ListEvent listEvent) {
                CheckList.this.repaint();
            }

            @Override
            public void valueRemoved(ListEvent listEvent) {
                CheckList.this.repaint();
            }
        });
        listCheckModel.addListCheckListener(new ListCheckListener(){

            @Override
            public void addCheck(ListEvent listEvent) {
                CheckList.this.repaint();
            }

            @Override
            public void removeCheck(ListEvent listEvent) {
                CheckList.this.repaint();
            }
        });
        listCheckModel.addListLockListener(new ListLockListener(){

            @Override
            public void addLock(ListEvent listEvent) {
                CheckList.this.repaint();
            }

            @Override
            public void removeLock(ListEvent listEvent) {
                CheckList.this.repaint();
            }
        });
        this.repaint();
    }
}

