/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.japura.gui.AbstractComboBox;
import org.japura.gui.BatchSelection;
import org.japura.gui.CheckList;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.model.DefaultListCheckModel;
import org.japura.gui.model.ListCheckModel;
import org.japura.gui.renderer.CheckListRenderer;

public class CheckComboBox
extends AbstractComboBox {
    private static final long serialVersionUID = 8289247356412690742L;
    public static final CheckState NONE = CheckState.NONE;
    public static final CheckState MULTIPLE = CheckState.MULTIPLE;
    public static final CheckState ALL = CheckState.ALL;
    private JScrollPane scrollPane;
    private CheckList checkList;
    private ListDataListener listDataListener;
    private ListCheckListener listCheckListener;
    private int visibleRowCount = 8;
    private HashMap<CheckState, String> texts = new HashMap();

    public CheckComboBox() {
        this.setRenderer(new CheckListRenderer());
        this.setModel(new DefaultListCheckModel());
    }

    public void setRenderer(CheckListRenderer checkListRenderer) {
        this.getCheckList().setCellRenderer(checkListRenderer);
        this.updateCellPanelWidth();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = Math.max(3, n);
        this.getCheckList().setVisibleRowCount(this.getVisibleRowCount());
    }

    @Override
    public void setPopupVisible(boolean bl) {
        if (bl) {
            if (this.getModel().getSize() > 0) {
                int n = Math.min(this.getVisibleRowCount(), this.getModel().getSize());
                this.getCheckList().setVisibleRowCount(n);
                this.getCheckList().setPreferredSize(null);
                Dimension dimension = this.getCheckList().getPreferredSize();
                Dimension dimension2 = this.getSize();
                if (dimension.width < dimension2.width) {
                    this.getCheckList().setPreferredSize(new Dimension(dimension2.width, dimension.height));
                }
                this.getPopup().show(this, 0, dimension2.height);
            }
        } else {
            this.getPopup().setVisible(false);
        }
    }

    @Override
    protected void unregisterEmbeddedComponent(JComponent jComponent) {
        if (jComponent instanceof BatchSelection) {
            BatchSelection batchSelection = (BatchSelection)jComponent;
            batchSelection.unregisterModel();
        }
    }

    @Override
    protected void registerEmbeddedComponent(JComponent jComponent) {
        if (jComponent instanceof BatchSelection) {
            BatchSelection batchSelection = (BatchSelection)jComponent;
            batchSelection.registerModel(this.getModel());
        }
    }

    public void setModel(ListCheckModel listCheckModel) {
        this.getCheckList().setModel(listCheckModel);
        listCheckModel.removeListDataListener(this.getListDataListener());
        listCheckModel.removeListCheckListener(this.getListCheckListener());
        listCheckModel.addListDataListener(this.getListDataListener());
        listCheckModel.addListCheckListener(this.getListCheckListener());
        if (this.getEmbeddedComponent() != null) {
            JComponent jComponent = this.getEmbeddedComponent().getComponent();
            this.unregisterEmbeddedComponent(jComponent);
            this.registerEmbeddedComponent(jComponent);
        }
        this.updateCellPanelWidth();
    }

    public ListCheckModel getModel() {
        return this.getCheckList().getModel();
    }

    protected void updateCellPanelWidth() {
        if (this.getPrototypeDisplayValue() != null) {
            this.getComboBox().setPrototypeDisplayValue(this.getPrototypeDisplayValue());
            return;
        }
        String string = null;
        for (CheckState checkState : CheckState.values()) {
            String string2 = this.getTextFor(checkState);
            if (string2 == null) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        ListCheckModel listCheckModel = this.getModel();
        for (int i = 0; i < listCheckModel.getSize(); ++i) {
            String string3 = listCheckModel.getElementAt(i).toString();
            if (string == null) {
                string = string3;
                continue;
            }
            if (string3.length() <= string.length()) continue;
            string = string3;
        }
        this.getComboBox().setPrototypeDisplayValue(string);
    }

    private CheckList getCheckList() {
        if (this.checkList == null) {
            this.checkList = new CheckList();
        }
        return this.checkList;
    }

    private ListCheckListener getListCheckListener() {
        if (this.listCheckListener == null) {
            this.listCheckListener = new ListCheckListener(){

                @Override
                public void addCheck(ListEvent listEvent) {
                    CheckComboBox.this.updateComboBox();
                }

                @Override
                public void removeCheck(ListEvent listEvent) {
                    CheckComboBox.this.updateComboBox();
                }
            };
        }
        return this.listCheckListener;
    }

    @Override
    protected void updateComboBox() {
        this.getComboBox().removeAllItems();
        CheckListRenderer checkListRenderer = this.getCheckList().getCellRenderer();
        List<Object> list = this.getModel().getCheckeds();
        int n = this.getModel().getSize();
        if (n > 0) {
            if (list.size() == 0 && this.texts.containsKey((Object)CheckState.NONE)) {
                this.getComboBox().addItem(this.getTextFor(CheckState.NONE));
            } else if (list.size() == 1) {
                this.getComboBox().addItem(checkListRenderer.getText(list.get(0)));
            } else if (list.size() == n && this.texts.containsKey((Object)CheckState.ALL)) {
                this.getComboBox().addItem(this.getTextFor(CheckState.ALL));
            } else if (list.size() > 1 && this.texts.containsKey((Object)CheckState.MULTIPLE)) {
                this.getComboBox().addItem(this.getTextFor(CheckState.MULTIPLE));
            }
        }
    }

    private ListDataListener getListDataListener() {
        if (this.listDataListener == null) {
            this.listDataListener = new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent listDataEvent) {
                }

                @Override
                public void intervalAdded(ListDataEvent listDataEvent) {
                    CheckComboBox.this.updateComboBox();
                    CheckComboBox.this.updateCellPanelWidth();
                    CheckComboBox.this.repaint();
                }

                @Override
                public void intervalRemoved(ListDataEvent listDataEvent) {
                    CheckComboBox.this.updateComboBox();
                    CheckComboBox.this.updateCellPanelWidth();
                    CheckComboBox.this.repaint();
                }
            };
        }
        return this.listDataListener;
    }

    public String getTextFor(CheckState checkState) {
        if (checkState != null) {
            return this.texts.get((Object)checkState);
        }
        return null;
    }

    public void removeTextFor(CheckState checkState) {
        if (checkState != null) {
            this.texts.remove((Object)checkState);
            if (checkState.equals((Object)NONE)) {
                this.updateComboBox();
            }
        }
    }

    public void setTextFor(CheckState checkState, String string) {
        if (checkState == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        this.texts.put(checkState, string);
        if (checkState.equals((Object)NONE)) {
            this.updateComboBox();
        }
        this.updateCellPanelWidth();
        this.repaint();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
            this.scrollPane.setViewportView(this.getCheckList());
        }
        return this.scrollPane;
    }

    @Override
    protected JComponent getPopupComponent() {
        return this.getScrollPane();
    }

    public static enum CheckState {
        NONE,
        ALL,
        MULTIPLE;

    }
}

