/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.japura.gui.event.ButtonTextFieldEvent;
import org.japura.gui.event.ButtonTextFieldListener;

public class ButtonTextField
extends JPanel {
    private static final long serialVersionUID = -4795575628553448760L;
    private EventListenerList listeners = new EventListenerList();
    private JTextField field;
    private IconLabel icon;
    private IconLabel selectedDropDownIcon;
    private JPanel dropDownButtonPanel;
    private JLabel dropDownButton;
    private LinkedHashMap<String, Action> actions;
    private String currentButton;
    private MouseAdapter popupMouseAdapter;
    private JPopupMenu actionsChooser;
    private JPanel actionsRoot;
    private DefaultListModel listModel;
    private JList actionsList;
    private ListRenderer listRenderer;
    private URL fixedIcon;
    private int maxWidth;
    private int maxHeight;
    private static int marginGap = 3;

    public ButtonTextField(String string) {
        this(new JTextField(string));
        this.updateMargin();
    }

    public ButtonTextField(int n) {
        this(new JTextField(n));
        this.updateMargin();
    }

    public ButtonTextField(String string, int n) {
        this(new JTextField(string, n));
        this.updateMargin();
    }

    public ButtonTextField() {
        this(new JTextField());
        this.updateMargin();
    }

    public ButtonTextField(JTextField jTextField) {
        if (jTextField == null) {
            jTextField = new JTextField();
        }
        this.field = jTextField;
        this.setBorder(jTextField.getBorder());
        jTextField.setBorder(null);
        jTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("margin")) {
                    Insets insets = ButtonTextField.this.getField().getMargin();
                    if (insets == null) {
                        ButtonTextField.this.getField().setBorder(null);
                    } else {
                        Border border = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
                        ButtonTextField.this.getField().setBorder(border);
                    }
                }
            }
        });
        this.updateMargin();
        this.actions = new LinkedHashMap();
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.getDropDownButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getField(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.getIcon(), gridBagConstraints);
    }

    public void addButtonTextFieldListener(ButtonTextFieldListener buttonTextFieldListener) {
        this.listeners.add(ButtonTextFieldListener.class, buttonTextFieldListener);
    }

    public void removeButtonTextFieldListener(ButtonTextFieldListener buttonTextFieldListener) {
        this.listeners.remove(ButtonTextFieldListener.class, buttonTextFieldListener);
    }

    private void updateMargin() {
        this.getField().setMargin(new Insets(0, marginGap, 0, marginGap));
    }

    public URL getFixedIcon() {
        return this.fixedIcon;
    }

    public void setFixedIcon(URL uRL) {
        this.fixedIcon = uRL;
        if (this.getFixedIcon() != null) {
            this.getIcon().setIcon(new ImageIcon(this.getFixedIcon()));
        } else if (this.icon != null) {
            Action action = this.actions.get(this.currentButton);
            ImageIcon imageIcon = action.getIcon();
            this.getIcon().setIcon(imageIcon);
        } else {
            this.getIcon().setIcon(null);
        }
        this.updateMaxSizes();
    }

    public boolean isDropDownVisible() {
        return this.getDropDownButtonPanel().isVisible();
    }

    public void setDropDownVisible(boolean bl) {
        this.getDropDownButtonPanel().setVisible(bl);
        this.updateDropDownIconBorder();
    }

    @Override
    public Dimension getPreferredSize() {
        Cloneable cloneable;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = new Dimension();
        Dimension dimension2 = this.field.getPreferredSize();
        Insets insets = this.field.getInsets();
        dimension.width += dimension2.width + insets.left + insets.right;
        dimension.height += dimension2.height + insets.top + insets.bottom;
        if (this.isDropDownVisible()) {
            cloneable = this.getDropDownButtonPanel().getPreferredSize();
            Insets insets2 = this.getDropDownButtonPanel().getInsets();
            int n = cloneable.height + insets2.top + insets2.bottom;
            dimension.width += cloneable.width + insets2.left + insets2.right;
            dimension.height = Math.max(dimension.height, n);
        }
        if (this.isIconVisible()) {
            if (this.getFixedIcon() != null) {
                cloneable = this.getIcon().getPreferredSize();
                dimension.width += cloneable.width;
                dimension.height = Math.max(dimension.height, cloneable.height);
            } else {
                cloneable = this.getIcon().getInsets();
                int n = this.maxHeight + ((Insets)cloneable).top + ((Insets)cloneable).bottom;
                dimension.width += this.maxWidth + ((Insets)cloneable).left + ((Insets)cloneable).right;
                dimension.height = Math.max(dimension.height, n);
            }
        }
        cloneable = this.getInsets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).bottom + ((Insets)cloneable).top;
        return dimension;
    }

    public void fireCurrentButtonActionListeners() {
        Action action;
        ActionListener actionListener;
        if (this.currentButton != null && this.isEnabled() && (actionListener = (action = this.actions.get(this.currentButton)).getListener()) != null) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    private void showButtonsChooser() {
        if (this.isEnabled()) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getActionsRoot().getPreferredSize();
            Insets insets = this.getActionsChooser().getInsets();
            int n = dimension.width;
            n = dimension2.width + insets.left + insets.right;
            int n2 = dimension2.height + insets.bottom + insets.top;
            Dimension dimension3 = new Dimension(n, n2);
            this.getActionsChooser().setPreferredSize(dimension3);
            this.getActionsChooser().show(this, 0, dimension.height);
        }
    }

    private JPopupMenu getActionsChooser() {
        if (this.actionsChooser == null) {
            this.actionsChooser = new JPopupMenu();
            this.actionsChooser.add(this.getActionsRoot());
        }
        return this.actionsChooser;
    }

    private JPanel getActionsRoot() {
        if (this.actionsRoot == null) {
            this.actionsRoot = new JPanel();
            this.actionsRoot.setLayout(new BorderLayout());
            this.actionsRoot.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
            this.actionsRoot.add((Component)this.getActionsList(), "Center");
        }
        return this.actionsRoot;
    }

    private DefaultListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private ListRenderer getListRenderer() {
        if (this.listRenderer == null) {
            this.listRenderer = new ListRenderer();
        }
        return this.listRenderer;
    }

    private JList getActionsList() {
        if (this.actionsList == null) {
            this.actionsList = new JList();
            this.actionsList.setCellRenderer(this.getListRenderer());
            this.actionsList.setSelectionMode(0);
            this.actionsList.setModel(this.getListModel());
            this.actionsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting() && ButtonTextField.this.actionsList.getSelectedIndex() > -1) {
                        ButtonTextField.this.actionsList.clearSelection();
                    }
                }
            });
            this.actionsList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex = ButtonTextField.this.actionsList.locationToIndex(mouseEvent.getPoint());
                    ButtonTextField.this.actionsList.repaint();
                }
            });
            this.actionsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    String string = null;
                    if (((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex >= 0 && ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex < ButtonTextField.this.getListModel().size()) {
                        string = (String)ButtonTextField.this.getListModel().get(((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex);
                    }
                    ButtonTextField.this.getActionsChooser().setVisible(false);
                    ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex = -1;
                    if (string != null) {
                        ButtonTextField.this.setCurrentButton(string);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex = -1;
                    ButtonTextField.this.actionsList.repaint();
                }
            });
        }
        return this.actionsList;
    }

    public void addButton(String string, ActionListener actionListener) {
        this.addButton(string, null, actionListener);
    }

    public void addButton(String string, URL uRL, ActionListener actionListener) {
        Action action = new Action(actionListener, uRL);
        this.actions.put(string, action);
        this.getListModel().addElement(string);
        if (this.currentButton == null) {
            this.setCurrentButton(string);
        }
        this.updateMaxSizes();
        this.updateDropDownIconBorder();
    }

    private void updateDropDownIconBorder() {
        if (this.isDropDownVisible()) {
            for (Action action : this.actions.values()) {
                if (action.getIcon() == null) continue;
                this.selectedDropDownIcon.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 3));
                return;
            }
        }
        this.selectedDropDownIcon.setBorder(BorderFactory.createEmptyBorder());
    }

    private void updateMaxSizes() {
        this.maxWidth = 0;
        this.maxHeight = 0;
        for (Action action : this.actions.values()) {
            if (action.getIcon() == null) continue;
            this.maxWidth = Math.max(this.maxWidth, action.getIcon().getIconWidth());
            this.maxHeight = Math.max(this.maxHeight, action.getIcon().getIconHeight());
        }
    }

    public JTextField getField() {
        return this.field;
    }

    public boolean isIconVisible() {
        return this.getIcon().isVisible();
    }

    public void setIconVisible(boolean bl) {
        this.getIcon().setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.field.setEnabled(bl);
        this.getIcon().setEnabled(bl);
        this.getDropDownButton().setEnabled(bl);
    }

    public void setCurrentButton(String string) {
        Action action = this.actions.get(string);
        if (action != null) {
            ButtonTextFieldEvent buttonTextFieldEvent = new ButtonTextFieldEvent(this.currentButton, string, System.currentTimeMillis());
            for (ButtonTextFieldListener buttonTextFieldListener : (ButtonTextFieldListener[])this.listeners.getListeners(ButtonTextFieldListener.class)) {
                buttonTextFieldListener.buttonChanged(buttonTextFieldEvent);
            }
            this.currentButton = string;
            ImageIcon imageIcon = action.getIcon();
            if (imageIcon != null) {
                this.getSelectedDropDownIcon().setIcon(imageIcon);
            } else {
                this.getSelectedDropDownIcon().setIcon(null);
            }
            if (this.getFixedIcon() == null) {
                this.getIcon().setIcon(imageIcon);
            }
            this.getField().setCaretPosition(0);
        }
    }

    public String getCurrentButtonName() {
        return this.currentButton;
    }

    private IconLabel getIcon() {
        if (this.icon == null) {
            this.icon = new IconLabel(true);
            this.icon.setCursor(new Cursor(12));
            this.icon.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
            this.icon.setBackground(this.field.getBackground());
            this.icon.setOpaque(true);
            this.icon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ButtonTextField.this.fireCurrentButtonActionListeners();
                }
            });
        }
        return this.icon;
    }

    public void setIconCursor(Cursor cursor) {
        this.getIcon().setCursor(cursor);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.field != null) {
            this.field.setBackground(color);
            this.getIcon().setBackground(color);
        }
    }

    private MouseAdapter getPopupMouseAdapter() {
        if (this.popupMouseAdapter == null) {
            this.popupMouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ButtonTextField.this.showButtonsChooser();
                }
            };
        }
        return this.popupMouseAdapter;
    }

    private JLabel getDropDownButton() {
        if (this.dropDownButton == null) {
            URL uRL = this.getClass().getResource("/resources/images/jpr_splitbuttondown.png");
            this.dropDownButton = new JLabel();
            this.dropDownButton.setIcon(new ImageIcon(uRL));
            this.dropDownButton.addMouseListener(this.getPopupMouseAdapter());
        }
        return this.dropDownButton;
    }

    public boolean isSelectedDropDownIconVisible() {
        return this.getSelectedDropDownIcon().isVisible();
    }

    public void setDropDownButtonBackground(Color color) {
        this.getDropDownButtonPanel().setBackground(color);
    }

    public Color getDropDownButtonBackground() {
        return this.getDropDownButtonPanel().getBackground();
    }

    public void setSelectedDropDownIconVisible(boolean bl) {
        this.getSelectedDropDownIcon().setVisible(bl);
    }

    private IconLabel getSelectedDropDownIcon() {
        if (this.selectedDropDownIcon == null) {
            this.selectedDropDownIcon = new IconLabel(false);
            this.selectedDropDownIcon.addMouseListener(this.getPopupMouseAdapter());
        }
        return this.selectedDropDownIcon;
    }

    private JPanel getDropDownButtonPanel() {
        if (this.dropDownButtonPanel == null) {
            this.dropDownButtonPanel = new JPanel(new BorderLayout());
            this.dropDownButtonPanel.addMouseListener(this.getPopupMouseAdapter());
            this.dropDownButtonPanel.add((Component)this.getSelectedDropDownIcon(), "West");
            this.dropDownButtonPanel.add((Component)this.getDropDownButton(), "Center");
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY);
            Border border = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
            this.dropDownButtonPanel.setBorder(compoundBorder);
        }
        return this.dropDownButtonPanel;
    }

    public void setText(String string) {
        this.getField().setText(string);
    }

    public String getText() {
        return this.getField().getText();
    }

    public void setDocument(Document document) {
        this.getField().setDocument(document);
    }

    public Document getDocument() {
        return this.getField().getDocument();
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        this.getField().addFocusListener(focusListener);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.getField().addKeyListener(keyListener);
    }

    public void addCaretListener(CaretListener caretListener) {
        this.getField().addCaretListener(caretListener);
    }

    private class ListRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7811567885926598910L;
        public int mouseOverIndex;
        private Border mouseOverBorder;
        private Border mouseOutBorder;
        private JLabel label = new JLabel();
        private IconLabel icon;

        public ListRenderer() {
            this.icon = new IconLabel(false);
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.label, "Center");
            this.add((Component)this.icon, "West");
            this.setBackground(Color.WHITE);
            this.label.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.label.setText(string);
            Action action = (Action)ButtonTextField.this.actions.get(string);
            if (action.getIcon() != null) {
                this.icon.setIcon(action.getIcon());
            } else {
                this.icon.setIcon(null);
            }
            if (n == this.mouseOverIndex) {
                this.label.setBorder(this.getMouseOverBorder());
                this.label.setBackground(Color.BLACK);
                this.label.setForeground(Color.WHITE);
            } else {
                this.label.setBorder(this.getMouseOutBorder());
                this.label.setBackground(Color.WHITE);
                this.label.setForeground(Color.BLACK);
            }
            return this;
        }

        public Border getMouseOverBorder() {
            if (this.mouseOverBorder == null) {
                this.mouseOverBorder = BorderFactory.createLineBorder(Color.BLACK, 3);
            }
            return this.mouseOverBorder;
        }

        public Border getMouseOutBorder() {
            if (this.mouseOutBorder == null) {
                this.mouseOutBorder = BorderFactory.createLineBorder(Color.WHITE, 3);
            }
            return this.mouseOutBorder;
        }
    }

    private class IconLabel
    extends JLabel {
        private static final long serialVersionUID = 729241592604471900L;
        private boolean fieldIcon;

        public IconLabel(boolean bl) {
            super("", null, 0);
            this.fieldIcon = bl;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.fieldIcon) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            int n = insets.left + insets.right + ButtonTextField.this.maxWidth;
            int n2 = insets.top + insets.bottom + ButtonTextField.this.maxHeight;
            return new Dimension(n, n2);
        }
    }

    private static class Action {
        private ActionListener listener;
        private ImageIcon icon;

        public Action(ActionListener actionListener, URL uRL) {
            this.listener = actionListener;
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        }

        protected ActionListener getListener() {
            return this.listener;
        }

        protected ImageIcon getIcon() {
            return this.icon;
        }
    }
}

