/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class ArrowButton
extends JComponent {
    public static final ArrowType UP = ArrowType.UP;
    public static final ArrowType DOWN = ArrowType.DOWN;
    public static final ArrowType LEFT = ArrowType.LEFT;
    public static final ArrowType RIGHT = ArrowType.RIGHT;
    public static final ArrowType DOUBLE_LEFT = ArrowType.DOUBLE_LEFT;
    public static final ArrowType DOUBLE_RIGHT = ArrowType.DOUBLE_RIGHT;
    public static final ArrowType DOUBLE_DOWN = ArrowType.DOUBLE_DOWN;
    public static final ArrowType DOUBLE_UP = ArrowType.DOUBLE_UP;
    public static final ArrowType FIRST = ArrowType.FIRST;
    public static final ArrowType LAST = ArrowType.LAST;
    private static final long serialVersionUID = -7741558416297551179L;
    private int arrowScale;
    private Dimension preferredSize;
    private GeneralPath gp;
    private Color disabledForeground;
    private Color mouseOverForeground;
    private ArrowType arrowType;
    private boolean mouseOver;

    public ArrowButton() {
        this(null, 12);
    }

    public ArrowButton(int n) {
        this(null, n);
    }

    public ArrowButton(ArrowType arrowType) {
        this(arrowType, 12);
    }

    public ArrowButton(ArrowType arrowType, int n) {
        this.arrowScale = Math.max(5, n);
        this.setArrowType(arrowType);
        this.disabledForeground = Color.LIGHT_GRAY;
        this.mouseOverForeground = new Color(90, 90, 90);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ArrowButton.this.mouseOver = true;
                ArrowButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ArrowButton.this.mouseOver = false;
                ArrowButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ArrowButton.this.doClick();
            }
        });
    }

    public void doClick() {
        if (this.isEnabled()) {
            this.fireActionPerformed();
        }
    }

    public int getArrowScale() {
        return this.arrowScale;
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    private int getShiftScale() {
        return 2 * this.getArrowScale() / 3;
    }

    public void setArrowType(ArrowType arrowType) {
        if (arrowType == null) {
            arrowType = ArrowType.DOUBLE_LEFT;
        }
        this.arrowType = arrowType;
        this.gp = new GeneralPath();
        if (arrowType.equals((Object)ArrowType.DOUBLE_LEFT)) {
            for (int i = 0; i < this.getArrowScale(); i += this.getShiftScale()) {
                this.gp.moveTo(i, this.getArrowScale() / 2);
                this.gp.lineTo(i + this.getArrowScale(), this.getArrowScale());
                this.gp.lineTo(i + this.getArrowScale(), 0.0f);
                this.gp.lineTo(i, this.getArrowScale() / 2);
            }
        } else if (arrowType.equals((Object)ArrowType.LEFT)) {
            this.gp.moveTo(0.0f, this.getArrowScale() / 2);
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), 0.0f);
        } else if (arrowType.equals((Object)ArrowType.FIRST)) {
            float f = this.getArrowScale() / 4;
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(f, 0.0f);
            this.gp.lineTo(f, this.getArrowScale());
            this.gp.lineTo(0.0f, this.getArrowScale());
            this.gp.lineTo(0.0f, 0.0f);
            this.gp.moveTo(f, this.getArrowScale() / 2);
            this.gp.lineTo(f + (float)this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(f + (float)this.getArrowScale(), 0.0f);
        } else if (arrowType.equals((Object)ArrowType.RIGHT)) {
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(0.0f, this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale() / 2);
        } else if (arrowType.equals((Object)ArrowType.LAST)) {
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(0.0f, this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale() / 2);
            this.gp.lineTo(0.0f, 0.0f);
            this.gp.moveTo(this.getArrowScale(), 0.0f);
            this.gp.lineTo(this.getArrowScale() + this.getArrowScale() / 4, 0.0f);
            this.gp.lineTo(this.getArrowScale() + this.getArrowScale() / 4, this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), 0.0f);
        } else if (arrowType.equals((Object)ArrowType.DOUBLE_RIGHT)) {
            for (int i = 0; i < this.getArrowScale(); i += this.getShiftScale()) {
                this.gp.moveTo(i, 0.0f);
                this.gp.lineTo(i, this.getArrowScale());
                this.gp.lineTo(i + this.getArrowScale(), this.getArrowScale() / 2);
                this.gp.lineTo(i, 0.0f);
            }
        } else if (arrowType.equals((Object)ArrowType.UP)) {
            this.gp.moveTo(this.getArrowScale() / 2, 0.0f);
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(0.0f, this.getArrowScale());
        } else if (arrowType.equals((Object)ArrowType.DOUBLE_UP)) {
            for (int i = 0; i < this.getArrowScale(); i += this.getShiftScale()) {
                this.gp.moveTo(this.getArrowScale() / 2, i);
                this.gp.lineTo(this.getArrowScale(), i + this.getArrowScale());
                this.gp.lineTo(0.0f, i + this.getArrowScale());
            }
        } else if (arrowType.equals((Object)ArrowType.DOUBLE_DOWN)) {
            for (int i = 0; i < this.getArrowScale(); i += this.getShiftScale()) {
                this.gp.moveTo(0.0f, i);
                this.gp.lineTo(this.getArrowScale(), i);
                this.gp.lineTo(this.getArrowScale() / 2, i + this.getArrowScale());
            }
        } else if (arrowType.equals((Object)ArrowType.DOWN)) {
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(this.getArrowScale(), 0.0f);
            this.gp.lineTo(this.getArrowScale() / 2, this.getArrowScale());
        }
        this.gp.closePath();
        Rectangle rectangle = this.gp.getBounds();
        this.preferredSize = new Dimension(rectangle.width, rectangle.height);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.isEnabled()) {
            graphics2D.setColor(this.getDisabledForeground());
        } else if (this.mouseOver) {
            graphics2D.setColor(this.getMouseOverForeground());
        } else {
            graphics2D.setColor(this.getForeground());
        }
        graphics2D.fill(this.gp);
    }

    public void setDisabledForeground(Color color) {
        if (color != null) {
            this.disabledForeground = color;
        }
    }

    public Color getMouseOverForeground() {
        return this.mouseOverForeground;
    }

    public void setMouseOverForeground(Color color) {
        if (color != null) {
            this.mouseOverForeground = color;
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listenerList.add(ActionListener.class, actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listenerList.remove(ActionListener.class, actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        ActionListener[] actionListenerArray;
        ActionEvent actionEvent = new ActionEvent(this, 1001, "linkClicked", System.currentTimeMillis(), 0);
        for (ActionListener actionListener : actionListenerArray = (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public static enum ArrowType {
        DOUBLE_LEFT,
        LEFT,
        DOUBLE_RIGHT,
        RIGHT,
        UP,
        DOWN,
        DOUBLE_UP,
        DOUBLE_DOWN,
        FIRST,
        LAST;

    }
}

