/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import org.japura.gui.Anchor;
import org.japura.gui.CompoundComponent;
import org.japura.gui.EmbeddedComponent;

public abstract class AbstractComboBox
extends JComponent {
    private static final long serialVersionUID = 5685295148232238680L;
    private Popup popup;
    private EmbeddedComponent embeddedComponent;
    private long lastViewChanged;
    private CompoundComponent compoundComponent;
    private JComboBox comboBox;
    private String prototypeDisplayValue;

    public AbstractComboBox() {
        this.setFocusable(true);
        super.setLayout(new BorderLayout());
        this.add((Component)this.getCompoundComponent(), "Center");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AbstractComboBox.this.getComboBox().requestFocusInWindow();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                AbstractComboBox.this.setPopupVisible(false);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                AbstractComboBox.this.setPopupVisible(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (ancestorEvent.getSource() != AbstractComboBox.this) {
                    AbstractComboBox.this.setPopupVisible(false);
                }
            }
        });
    }

    protected abstract JComponent getPopupComponent();

    protected final JComboBox getComboBox() {
        if (this.comboBox == null) {
            this.comboBox = new ComboBox();
        }
        return this.comboBox;
    }

    @Override
    public void setBackground(Color color) {
        this.getComboBox().setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        this.getComboBox().setForeground(color);
    }

    @Override
    public Color getForeground() {
        return this.getComboBox().getForeground();
    }

    @Override
    public Color getBackground() {
        return this.getComboBox().getBackground();
    }

    private CompoundComponent getCompoundComponent() {
        if (this.compoundComponent == null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    long l = Math.abs(AbstractComboBox.this.lastViewChanged - mouseEvent.getWhen());
                    if (l > 20L) {
                        AbstractComboBox.this.changePopupVisible();
                    }
                }
            };
            this.compoundComponent = new CompoundComponent(this.getComboBox(), mouseAdapter);
        }
        return this.compoundComponent;
    }

    public EmbeddedComponent removeEmbeddedComponent() {
        EmbeddedComponent embeddedComponent = this.embeddedComponent;
        this.unregisterEmbeddedComponent(embeddedComponent.getComponent());
        this.embeddedComponent = null;
        return embeddedComponent;
    }

    protected abstract void unregisterEmbeddedComponent(JComponent var1);

    protected abstract void registerEmbeddedComponent(JComponent var1);

    public void setEmbeddedComponent(EmbeddedComponent embeddedComponent) {
        JComponent jComponent;
        if (this.embeddedComponent != null) {
            jComponent = embeddedComponent.getComponent();
            this.unregisterEmbeddedComponent(jComponent);
        }
        this.embeddedComponent = embeddedComponent;
        jComponent = embeddedComponent.getComponent();
        this.registerEmbeddedComponent(jComponent);
    }

    public EmbeddedComponent getEmbeddedComponent() {
        return this.embeddedComponent;
    }

    private void changePopupVisible() {
        this.setPopupVisible(!this.isPopupVisible());
    }

    public boolean isPopupVisible() {
        return this.getPopup().isVisible();
    }

    public abstract void setPopupVisible(boolean var1);

    public void setPrototypeDisplayValue(String string) {
        this.prototypeDisplayValue = string;
    }

    public String getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
    }

    protected abstract void updateComboBox();

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getCompoundComponent().setEnabled(bl);
    }

    protected final Popup getPopup() {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setLayout(new BorderLayout());
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            this.popup.add(this.getPopupComponent());
            if (this.getEmbeddedComponent() != null) {
                Anchor anchor = this.getEmbeddedComponent().getAnchor();
                if (anchor == null) {
                    throw new IllegalArgumentException("Null Anchor");
                }
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JComponent jComponent = this.getEmbeddedComponent().getComponent();
                jPanel.add(jComponent);
                if (anchor.equals((Object)Anchor.NORTH)) {
                    this.popup.add((Component)jPanel, "North");
                    jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.black));
                } else if (anchor.equals((Object)Anchor.SOUTH)) {
                    this.popup.add((Component)jPanel, "South");
                    jPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.black));
                } else {
                    throw new IllegalArgumentException("Illegal anchor. Must be NORTH or SOUTH");
                }
            }
            this.popup.addMenuKeyListener(new MenuKeyListener(){

                @Override
                public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
                }

                @Override
                public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
                }

                @Override
                public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
                    if (menuKeyEvent.getKeyCode() == 27) {
                        AbstractComboBox.this.setPopupVisible(false);
                    } else if (menuKeyEvent.getKeyCode() == 9) {
                        AbstractComboBox.this.setPopupVisible(false);
                        if (menuKeyEvent.getModifiersEx() == 64) {
                            AbstractComboBox.this.transferFocusBackward();
                        } else {
                            AbstractComboBox.this.transferFocus();
                        }
                    }
                }
            });
        }
        return this.popup;
    }

    protected class Popup
    extends JPopupMenu {
        private static final long serialVersionUID = -7940039384534412109L;

        public Popup() {
            for (MenuKeyListener menuKeyListener : this.getMenuKeyListeners()) {
                this.removeMenuKeyListener(menuKeyListener);
            }
        }

        @Override
        public void setVisible(boolean bl) {
            AbstractComboBox.this.lastViewChanged = System.currentTimeMillis();
            super.setVisible(bl);
            if (!bl) {
                AbstractComboBox.this.popup = null;
            }
        }
    }

    private class ComboBox
    extends JComboBox {
        private static final long serialVersionUID = 10000012219553L;

        private ComboBox() {
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 40) {
                AbstractComboBox.this.setPopupVisible(true);
            }
        }
    }
}

