/*
 * Decompiled with CFR 0.152.
 */
package org.japura.exception;

import java.util.HashMap;
import org.japura.exception.HandlerException;

public abstract class HandlerExceptionManager {
    private static HashMap<String, HandlerException> handlers = new HashMap();

    public static void register(Class<? extends Exception> clazz, HandlerException handlerException) {
        if (clazz != null && handlerException != null) {
            handlers.put(clazz.getName(), handlerException);
        }
    }

    public static void handle(Exception exception) {
        HandlerExceptionManager.handle(exception, null);
    }

    public static void handle(Exception exception, HashMap<String, Object> hashMap) {
        if (handlers.size() == 0) {
            HandlerExceptionManager.register(Exception.class, new HandlerException(){

                @Override
                public void handle(Exception exception, HashMap<String, Object> hashMap) {
                    exception.printStackTrace();
                }
            });
        }
        if (exception != null) {
            for (Class<?> clazz = exception.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (!handlers.containsKey(clazz.getName())) continue;
                HandlerException handlerException = handlers.get(clazz.getName());
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                handlerException.handle(exception, hashMap);
                return;
            }
        }
    }
}

