/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.japura.debug.DebugComponent;
import org.japura.util.WeakList;

public final class DebugWindow
extends JDialog {
    private static Map<Class<?>, Integer> tabsIndex = new HashMap();
    private static WeakList<DebugComponent> components = new WeakList();
    private static DebugWindow debugWindow;
    private static final long serialVersionUID = 1966734031063184108L;
    private JTabbedPane tabbedPane;

    static void updateTabTitles() {
        if (components.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (debugWindow != null) {
                    for (DebugComponent debugComponent : components) {
                        int n = (Integer)tabsIndex.get(debugComponent.getClass());
                        String string = debugComponent.getTitle();
                        debugWindow.getTabbedPane().setTitleAt(n, string);
                    }
                }
            }
        });
    }

    public static void showDebugWindow(final DebugComponent debugComponent) {
        try {
            if (tabsIndex.containsKey(debugComponent.getClass())) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugWindow.getDebugWindow().setLocation(20, 20);
                    DebugWindow.getDebugWindow().setVisible(true);
                    DebugWindow.getDebugWindow().addTab(debugComponent);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static DebugWindow getDebugWindow() {
        if (debugWindow == null) {
            debugWindow = new DebugWindow();
        }
        return debugWindow;
    }

    public static void closeDebugWindow() {
        try {
            if (debugWindow != null) {
                debugWindow.dispose();
                debugWindow = null;
                components.clear();
                tabsIndex.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private DebugWindow() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DebugWindow.closeDebugWindow();
            }
        });
        this.setModal(false);
        this.setSize(550, 400);
        this.setTitle("Japura - Debug");
        this.add(this.getTabbedPane());
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
        }
        return this.tabbedPane;
    }

    private void addTab(DebugComponent debugComponent) {
        if (!tabsIndex.containsKey(debugComponent.getClass())) {
            this.getTabbedPane().addTab("", debugComponent);
            components.add(debugComponent);
            int n = this.tabbedPane.getTabCount() - 1;
            tabsIndex.put(debugComponent.getClass(), n);
            this.getTabbedPane().setSelectedIndex(n);
        }
    }
}

