/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.japura.debug.DebugParameter;
import org.japura.debug.DebugResult;
import org.japura.debug.DebugWindow;
import org.japura.util.WeakList;

public abstract class DebugComponent
extends JPanel {
    private static WeakList<DebugComponent> components = new WeakList();

    public static synchronized boolean exists(Class<?> clazz) {
        for (DebugComponent debugComponent : components) {
            if (!debugComponent.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static synchronized List<DebugResult> publish(Class<?> clazz, DebugParameter debugParameter) {
        ArrayList<DebugResult> arrayList = new ArrayList<DebugResult>();
        for (DebugComponent debugComponent : components) {
            DebugResult debugResult;
            if (!debugComponent.getClass().equals(clazz) || (debugResult = debugComponent.update(debugParameter)) == null) continue;
            arrayList.add(debugResult);
        }
        DebugWindow.updateTabTitles();
        return arrayList;
    }

    public static synchronized void add(DebugComponent debugComponent) {
        components.add(debugComponent);
    }

    protected abstract DebugResult update(DebugParameter var1);

    protected abstract String getTitle();
}

