/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller.modals;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.japura.gui.WrapLabel;
import org.japura.modal.Modal;

public abstract class AbstractPanel
extends JPanel {
    private static final long serialVersionUID = 6038019098837978157L;
    private WrapLabel titleLabel;
    private WrapLabel label;
    private int width = 300;
    private String text;
    private String title;

    public AbstractPanel(String string, String string2) {
        this(string, string2, null);
    }

    public AbstractPanel(String string, String string2, Icon icon) {
        if (icon == null) {
            icon = this.getIcon();
        }
        this.title = string;
        this.text = string2 != null ? string2 : "";
        this.setName("modalPanel");
        Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
        Border border2 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout(0, 5));
        if (string != null && string.length() > 0) {
            this.add((Component)this.getTitleLabel(), "North");
        }
        this.add((Component)this.getButtonsPanel(), "South");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        if (icon != null) {
            jPanel.add((Component)new JLabel(icon), gridBagConstraints);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.getLabel(), gridBagConstraints);
        JComponent jComponent = this.getContent();
        if (jComponent != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            if (icon != null) {
                gridBagConstraints.gridwidth = 2;
            }
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        this.add((Component)jPanel, "Center");
    }

    protected abstract JPanel getButtonsPanel();

    @Deprecated
    protected Icon getIcon() {
        return null;
    }

    protected abstract JComponent getContent();

    private WrapLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new WrapLabel();
            this.titleLabel.setName("titleLabel");
            if (this.title != null) {
                this.titleLabel.setText(this.title);
            }
            this.titleLabel.setWrapWidth(this.width);
            this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        }
        return this.titleLabel;
    }

    private WrapLabel getLabel() {
        if (this.label == null) {
            this.label = new WrapLabel(this.text);
            this.label.setWrapWidth(this.width);
            this.label.setName("messageLabel");
        }
        return this.label;
    }

    protected final void setTextWrapWidth(int n) {
        this.width = n;
    }

    protected final int getTextWrapWidth() {
        return this.width;
    }

    public final void closeModal() {
        Modal.closeModal(this);
    }
}

