/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.japura.controller.Controller;
import org.japura.controller.Subscriber;
import org.japura.controller.SubscriberFilter;

public class Message {
    private List<SubscriberFilter> filters;
    private int type;
    private Controller<?> publisher;
    private boolean consumed;
    private boolean controllerConsumed;
    private boolean ignorePublisher;

    public Message() {
        this(-1);
    }

    public Message(int n) {
        this.type = n;
        this.filters = new ArrayList<SubscriberFilter>();
    }

    public List<SubscriberFilter> getSubscriberFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void removeSubscriberFilters() {
        this.filters.clear();
    }

    public void removeSubscriberFilter(SubscriberFilter subscriberFilter) {
        if (subscriberFilter != null) {
            this.filters.remove(subscriberFilter);
        }
    }

    public boolean containsSubscriberFilter(SubscriberFilter subscriberFilter) {
        if (subscriberFilter != null) {
            return this.filters.contains(subscriberFilter);
        }
        return false;
    }

    boolean acceptsController(Controller<?> controller) {
        for (SubscriberFilter subscriberFilter : this.filters) {
            if (subscriberFilter.accepts(controller)) continue;
            return false;
        }
        return true;
    }

    boolean acceptsSubscriber(Subscriber subscriber) {
        for (SubscriberFilter subscriberFilter : this.filters) {
            if (subscriberFilter.accepts(subscriber)) continue;
            return false;
        }
        return true;
    }

    public void addSubscriberFilter(SubscriberFilter subscriberFilter) {
        if (subscriberFilter != null && !this.filters.contains(subscriberFilter)) {
            this.filters.add(subscriberFilter);
        }
    }

    void setPublisher(Controller<?> controller) {
        this.publisher = controller;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Controller<?> getPublisher() {
        return this.publisher;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isControllerConsumed() {
        return this.controllerConsumed;
    }

    public void consumeController() {
        this.controllerConsumed = true;
    }

    public void setIgnorePublisher(boolean bl) {
        this.ignorePublisher = bl;
    }

    public boolean isIgnorePublisher() {
        return this.ignorePublisher;
    }

    public boolean isPublisherAssignableFrom(Class<?> clazz) {
        if (this.getPublisher() != null) {
            return clazz.isAssignableFrom(this.getPublisher().getClass());
        }
        return false;
    }
}

