/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.japura.controller.Controller;

class Link
implements Comparator<Controller<?>> {
    private List<Controller<?>> controllers = new ArrayList();

    public Link(Controller<?> ... controllerArray) {
        for (Controller<?> controller : controllerArray) {
            if (this.controllers.contains(controller)) continue;
            this.controllers.add(controller);
        }
        Collections.sort(this.controllers, this);
    }

    public <E> E get(Class<E> clazz) {
        for (Controller<?> controller : this.controllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            return clazz.cast(controller);
        }
        return null;
    }

    @Override
    public int compare(Controller<?> controller, Controller<?> controller2) {
        if (controller.getId() > controller2.getId()) {
            return 1;
        }
        if (controller.getId() < controller2.getId()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.controllers == null ? 0 : ((Object)this.controllers).hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Link link = (Link)object;
        return !(this.controllers == null ? link.controllers != null : !((Object)this.controllers).equals(link.controllers));
    }

    public boolean contains(Controller<?> controller) {
        return this.controllers.contains(controller);
    }

    public boolean contains(Class<?> clazz) {
        for (Controller<?> controller : this.controllers) {
            if (!controller.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

