/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.List;
import org.japura.controller.Controller;
import org.japura.controller.IdPool;
import org.japura.task.TaskManager;

public final class Group {
    static TaskManager.TokenKey taskManagerTokenKey;
    private final int id;

    Group() {
        if (taskManagerTokenKey == null) {
            TaskManager.callTokenKey();
        }
        this.id = IdPool.getNextId();
        TaskManager.register(this, taskManagerTokenKey);
    }

    void unregister() {
        TaskManager.unregister(this, taskManagerTokenKey);
    }

    public int getId() {
        return this.id;
    }

    public <E> List<E> getAll(Class<E> clazz) {
        return Controller.getAllFromGroup(this.getId(), clazz);
    }

    public List<Controller<?>> getAll() {
        return Controller.getAllFromGroup(this.getId());
    }

    public <E> E get(Class<E> clazz) {
        return Controller.getFromGroup(this.getId(), clazz);
    }

    public <E> E get(int n, Class<E> clazz) {
        return Controller.getFromGroup(this.getId(), n, clazz);
    }

    public Controller<?> get(int n) {
        return Controller.getFromGroup(this.getId(), n);
    }

    public void freeAll(Class<?> clazz) {
        Controller.freeAllFromGroup(this.getId(), clazz);
    }

    public void free() {
        Controller.freeGroup(this.getId());
    }

    public boolean isInstancied(Class<?> clazz) {
        return Controller.isInstanciedInGroup(this.getId(), clazz);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.id;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Group group = (Group)object;
        return this.id == group.id;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }
}

