/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.japura.controller.Controller;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugParameter;
import org.japura.debug.DebugResult;

class DebugControllers
extends DebugComponent {
    private static final long serialVersionUID = 1966734031063184008L;
    private JList list;
    private JTree tree;
    private JScrollPane sp;
    private JRadioButton treeButton;
    private JRadioButton listButton;
    private JCheckBox fullNameButton;
    private List<TreePath> pathsToExpand = new ArrayList<TreePath>();
    private List<Integer> expandedNodes = new ArrayList<Integer>();

    public DebugControllers() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.getListButton());
        buttonGroup.add(this.getTreeButton());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.getTreeButton(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.getListButton(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.getFullNameButton(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.sp = new JScrollPane(this.getTree());
        this.add((Component)this.sp, "Center");
    }

    private void controllerRemoved(Controller<?> controller) {
        Integer n = controller.getId();
        this.expandedNodes.remove(n);
    }

    public JCheckBox getFullNameButton() {
        if (this.fullNameButton == null) {
            this.fullNameButton = new JCheckBox("Full name");
            this.fullNameButton.setSelected(true);
            this.fullNameButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DebugControllers.this.tree.updateUI();
                }
            });
        }
        return this.fullNameButton;
    }

    public JRadioButton getListButton() {
        if (this.listButton == null) {
            this.listButton = new JRadioButton("List");
            this.listButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DebugControllers.this.sp.setViewportView(DebugControllers.this.getList());
                }
            });
        }
        return this.listButton;
    }

    public JRadioButton getTreeButton() {
        if (this.treeButton == null) {
            this.treeButton = new JRadioButton("Tree");
            this.treeButton.setSelected(true);
            this.treeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DebugControllers.this.sp.setViewportView(DebugControllers.this.getTree());
                }
            });
        }
        return this.treeButton;
    }

    public JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tree.setCellRenderer(new TRenderer());
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                    Controller controller = (Controller)defaultMutableTreeNode.getUserObject();
                    Integer n = controller.getId();
                    DebugControllers.this.expandedNodes.add(n);
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                    Controller controller = (Controller)defaultMutableTreeNode.getUserObject();
                    Integer n = controller.getId();
                    DebugControllers.this.expandedNodes.remove(n);
                }
            });
        }
        return this.tree;
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.list.setCellRenderer(new LRenderer());
        }
        return this.list;
    }

    private void addToPathList(DefaultMutableTreeNode defaultMutableTreeNode) {
        Controller controller = (Controller)defaultMutableTreeNode.getUserObject();
        Integer n = controller.getId();
        if (this.expandedNodes.contains(n)) {
            this.pathsToExpand.add(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private void addChild(Controller<?> controller, DefaultMutableTreeNode defaultMutableTreeNode) {
        List<Controller<?>> list = controller.getChildren();
        if (list.size() > 0) {
            for (Controller<?> controller2 : list) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(controller2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.addToPathList(defaultMutableTreeNode2);
                this.addChild(controller2, defaultMutableTreeNode2);
            }
        }
    }

    private void addChild(Controller<?> controller, DefaultListModel defaultListModel) {
        List<Controller<?>> list = controller.getChildren();
        if (list.size() > 0) {
            for (Controller<?> controller2 : list) {
                defaultListModel.addElement(controller2);
                this.addChild(controller2, defaultListModel);
            }
        }
    }

    @Override
    protected String getTitle() {
        List<Controller<?>> list = Controller.getControllers();
        return "Controllers - Pool (" + list.size() + ")";
    }

    @Override
    protected DebugResult update(DebugParameter debugParameter) {
        if (debugParameter instanceof Parameter) {
            Parameter parameter = (Parameter)debugParameter;
            if (parameter.getControllerToRemove() != null) {
                this.controllerRemoved(parameter.getControllerToRemove());
                return null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugControllers.this.pathsToExpand.clear();
                    List<Controller<?>> list = Controller.getControllers();
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
                    DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
                    DefaultListModel defaultListModel = new DefaultListModel();
                    for (Controller<?> controller : list) {
                        if (controller.getParentId() != null) continue;
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(controller);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        DebugControllers.this.addToPathList(defaultMutableTreeNode2);
                        defaultListModel.addElement(controller);
                        DebugControllers.this.addChild(controller, defaultListModel);
                        DebugControllers.this.addChild(controller, defaultMutableTreeNode2);
                    }
                    DebugControllers.this.getTree().setModel(defaultTreeModel);
                    DebugControllers.this.getList().setModel(defaultListModel);
                    for (Controller<?> controller : DebugControllers.this.pathsToExpand) {
                        DebugControllers.this.tree.expandPath((TreePath)((Object)controller));
                    }
                    DebugControllers.this.pathsToExpand.clear();
                }
            });
        }
        return null;
    }

    private static String controllerToString(Controller<?> controller, boolean bl) {
        String string = null;
        string = bl ? controller.getClass().getName() : controller.getClass().getSimpleName();
        return string + " [ " + controller.stringToDebugComponent() + " ]";
    }

    public static class Parameter
    extends DebugParameter {
        private Controller<?> controllerToRemove;

        public Parameter(Controller<?> controller) {
            this.controllerToRemove = controller;
        }

        public Parameter() {
        }

        public Controller<?> getControllerToRemove() {
            return this.controllerToRemove;
        }
    }

    private class TRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 8655744295863210194L;

        private TRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Controller controller = (Controller)defaultMutableTreeNode.getUserObject();
            if (controller != null) {
                boolean bl5 = DebugControllers.this.getFullNameButton().isSelected();
                jLabel.setText(DebugControllers.controllerToString(controller, bl5));
            }
            return jLabel;
        }

        @Override
        public void setIcon(Icon icon) {
        }
    }

    private class LRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 197732829250426432L;

        private LRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Controller controller = (Controller)object;
            boolean bl3 = DebugControllers.this.getFullNameButton().isSelected();
            jLabel.setText(DebugControllers.controllerToString(controller, bl3));
            return jLabel;
        }
    }
}

