/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.japura.controller.Controller;
import org.japura.controller.ControllerWrapper;
import org.japura.controller.Group;
import org.japura.task.AbstractTask;
import org.japura.task.TaskManager;
import org.japura.task.TaskManagerListener;

class ControllerTaskListener
implements TaskManagerListener {
    private static ControllerTaskListener instance;
    private HashMap<String, Integer> freeAfterExecution = new HashMap();
    private List<Integer> freeAfterAllExecutions = new ArrayList<Integer>();

    public static ControllerTaskListener getInstance() {
        if (instance == null) {
            instance = new ControllerTaskListener();
        }
        return instance;
    }

    private ControllerTaskListener() {
    }

    public synchronized void freeAfterExecution(Controller<?> controller, AbstractTask<?> abstractTask) {
        Integer n = controller.getId();
        String string = abstractTask.getId();
        this.freeAfterExecution.put(string, n);
    }

    public synchronized void freeAfterAllExecutions(Controller<?> controller) {
        Integer n = controller.getId();
        this.freeAfterAllExecutions.add(n);
    }

    @Override
    public void submitted(AbstractTask<?> abstractTask) {
    }

    @Override
    public void beforeExecute(AbstractTask<?> abstractTask) {
    }

    @Override
    public synchronized void afterExecute(AbstractTask<?> abstractTask) {
        Integer n;
        Object object;
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper == null) {
            return;
        }
        Group group = controllerWrapper.getController().getGroup();
        if (!TaskManager.hasTask(group) && this.freeAfterAllExecutions.size() > 0) {
            object = this.freeAfterAllExecutions.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                Controller.free(n);
            }
            this.freeAfterAllExecutions.clear();
        }
        if (!this.freeAfterExecution.isEmpty() && (n = this.freeAfterExecution.remove(object = abstractTask.getId())) != null) {
            Controller.free(n);
        }
    }

    @Override
    public void removed(AbstractTask<?> abstractTask) {
    }
}

