/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.japura.controller.ChildController;
import org.japura.controller.ControllerException;
import org.japura.controller.ControllerTaskListener;
import org.japura.controller.ControllerWrapper;
import org.japura.controller.DebugControllers;
import org.japura.controller.DefaultModalPanelFactory;
import org.japura.controller.Group;
import org.japura.controller.IdPool;
import org.japura.controller.InvalidControllerClassException;
import org.japura.controller.Link;
import org.japura.controller.Message;
import org.japura.controller.MessageFilter;
import org.japura.controller.ModalAction;
import org.japura.controller.ModalPanelFactory;
import org.japura.controller.Singleton;
import org.japura.controller.Subscriber;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugWindow;
import org.japura.modal.Modal;
import org.japura.modal.ModalEvent;
import org.japura.modal.ModalListener;
import org.japura.task.AbstractTask;
import org.japura.task.TaskManager;

public abstract class Controller<V extends Component> {
    private static ModalPanelFactory modalPanelFactory;
    private static ArrayList<Controller<?>> controllers;
    private static List<Link> links;
    private static Object parentControllerLock;
    private static Integer newParentControllerId;
    private String controllerName;
    private Controller<?> parentController;
    private List<Controller<?>> childrenControllers;
    private List<MessageFilter> filters;
    private LinkedHashMap<Class<? extends Message>, List<Subscriber>> subscribers;
    private int id;
    private Group group;
    private boolean permanent;
    private boolean removed;
    private String modalGroupName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Controller() {
        Object object = parentControllerLock;
        synchronized (object) {
            if (this.getClass().isAnnotationPresent(ChildController.class) && newParentControllerId == null) {
                throw new ControllerException("[" + this.getClass().getName() + "] Child controller must be instantiated through method createChild");
            }
            if (newParentControllerId != null) {
                this.parentController = this.localGet(newParentControllerId);
            }
            newParentControllerId = null;
            this.childrenControllers = new ArrayList();
            this.filters = new ArrayList<MessageFilter>();
            this.subscribers = new LinkedHashMap();
            Controller.join(this);
        }
    }

    public String stringToDebugComponent() {
        if (this.getControllerName() != null) {
            return "Id:" + this.getId() + " - Name: " + this.getControllerName();
        }
        return "Id:" + this.getId();
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String string) {
        this.controllerName = string;
    }

    private static void removeFromDebugComponents(Controller<?> controller) {
        if (DebugComponent.exists(DebugControllers.class)) {
            DebugControllers.Parameter parameter = new DebugControllers.Parameter(controller);
            DebugComponent.publish(DebugControllers.class, parameter);
        }
    }

    private static void updateDebugComponents() {
        if (DebugComponent.exists(DebugControllers.class)) {
            DebugControllers.Parameter parameter = new DebugControllers.Parameter();
            DebugComponent.publish(DebugControllers.class, parameter);
        }
    }

    public static synchronized boolean existsLink(Controller<?> controller, Controller<?> controller2) {
        if (controller == null || controller2 == null) {
            return false;
        }
        for (Link link : links) {
            if (!link.contains(controller) || !link.contains(controller2)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean existsLink(Controller<?> controller, Class<?> clazz) {
        if (controller == null || clazz == null || !Controller.class.isAssignableFrom(clazz) || controller.getClass().equals(clazz)) {
            return false;
        }
        for (Link link : links) {
            if (!link.contains(controller) || !link.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void link(Controller<?> controller, Controller<?> controller2) {
        if (controller == null || controller2 == null) {
            throw new ControllerException("Null controller");
        }
        if (controller.getClass().equals(controller2.getClass())) {
            throw new ControllerException("Can not link two controllers from the same class");
        }
        if (controller.equals(controller2)) {
            throw new ControllerException("Can not link the same controller");
        }
        for (Link link : links) {
            if (link.contains(controller)) {
                throw new ControllerException("Already exists a link for " + controller.getClass().getName() + " [" + controller.getId() + "]");
            }
            if (!link.contains(controller2)) continue;
            throw new ControllerException("Already exists a link for " + controller2.getClass().getName() + " [" + controller2.getId() + "]");
        }
        links.add(new Link(controller, controller2));
    }

    public static synchronized void unlink(Controller<?> controller, Controller<?> controller2) {
        if (controller == null || controller2 == null) {
            return;
        }
        if (controller.getClass().equals(controller2.getClass())) {
            return;
        }
        if (controller.equals(controller2)) {
            return;
        }
        Link link = null;
        for (Link link2 : links) {
            if (!link2.contains(controller) || !link2.contains(controller2)) continue;
            link = link2;
            break;
        }
        if (link != null) {
            links.remove(link);
        }
    }

    private static synchronized <E> E getFromLink(Controller<?> controller, Class<E> clazz) {
        if (!Controller.class.isAssignableFrom(clazz)) {
            throw new InvalidControllerClassException(clazz);
        }
        if (controller == null || clazz == null) {
            return null;
        }
        if (controller.getClass().equals(clazz)) {
            return null;
        }
        for (Link link : links) {
            if (!link.contains(controller)) continue;
            return link.get(clazz);
        }
        return null;
    }

    public static void setTaskManagerTokenKey(TaskManager.TokenKey tokenKey) {
        if (tokenKey != null) {
            Group.taskManagerTokenKey = tokenKey;
        }
    }

    public static DebugComponent createDebugPanel() {
        DebugControllers debugControllers = new DebugControllers();
        DebugComponent.add(debugControllers);
        Controller.updateDebugComponents();
        return debugControllers;
    }

    public static void showDebugWindow() {
        DebugWindow.showDebugWindow(Controller.createDebugPanel());
        Controller.updateDebugComponents();
    }

    private static synchronized void join(Controller<?> controller) {
        if (controller != null) {
            Class<?> clazz = controller.getClass();
            if (clazz.isAnnotationPresent(Singleton.class) && Controller.count(clazz) > 0) {
                throw new ControllerException("[" + clazz.getName() + "] Singleton Controller");
            }
            super.setId(IdPool.getNextId());
            Integer n = controller.getParentId();
            if (n != null) {
                Controller<?> controller2 = Controller.get(n);
                Group group = controller2.getGroup();
                super.setGroup(group);
                super.addChild(controller);
            } else {
                Group group = new Group();
                super.setGroup(group);
            }
            controllers.add(controller);
            Controller.updateDebugComponents();
        }
    }

    static synchronized List<Controller<?>> getControllers() {
        return Collections.unmodifiableList(controllers);
    }

    public static synchronized void free(int n) {
        Controller.free(n, true);
    }

    public static synchronized void free(int n, boolean bl) {
        for (Controller<?> controller : controllers) {
            if (controller.getId() != n) continue;
            Controller.free(controller, bl);
            break;
        }
    }

    public static synchronized void freeGroup(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n) continue;
            arrayList.add(controller.getId());
        }
        Iterator<Controller<Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)((Object)iterator.next());
            Controller.free(n2);
        }
    }

    public static synchronized void freeAll(Class<?> clazz) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Controller<?> controller : controllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            arrayList.add(controller.getId());
        }
        Iterator<Controller<Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            Controller.free(n);
        }
    }

    public static synchronized void freeAllFromGroup(int n, Class<?> clazz) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n || !clazz.isAssignableFrom(controller.getClass())) continue;
            arrayList.add(controller.getId());
        }
        Iterator<Controller<Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)((Object)iterator.next());
            Controller.free(n2);
        }
    }

    public static synchronized boolean isInstancied(Class<?> clazz) {
        for (Controller<?> controller : controllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean isInstanciedInGroup(int n, Class<?> clazz) {
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n || !clazz.isAssignableFrom(controller.getClass())) continue;
            return true;
        }
        return false;
    }

    public static synchronized void freeAll() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Controller<?> controller : controllers) {
            arrayList.add(controller.getId());
        }
        Iterator<Controller<Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            Controller.free(n);
        }
    }

    private static synchronized void free(Controller<?> controller, boolean bl) {
        if (controller != null && !controller.isPermanent()) {
            Controller<?> controller222;
            boolean bl2 = controller.isRoot();
            ArrayList arrayList = new ArrayList();
            Controller.fetchHierarchy(controller, arrayList);
            controller.beforeFreeController();
            for (Controller<?> controller222 : arrayList) {
                controller222.beforeFreeController();
            }
            Integer n = controller.getGroupId();
            if (bl) {
                TaskManager.cancel(n);
            }
            Controller.closeModal(controller);
            for (Controller iterator : arrayList) {
                Controller.closeModal(iterator);
            }
            controller222 = controller.getParent();
            if (controller222 != null) {
                super.removeChild(controller);
            }
            controller.parentController = null;
            controller.childrenControllers.clear();
            for (Controller controller2 : arrayList) {
                controller2.parentController = null;
                controller2.childrenControllers.clear();
            }
            controllers.remove(controller);
            controller.removed = true;
            Controller.unlink(controller);
            IdPool.removeId(controller.getId());
            if (bl2) {
                Group group = controller.getGroup();
                group.unregister();
                IdPool.removeId(group.getId());
            }
            Controller.removeFromDebugComponents(controller);
            for (Controller controller3 : arrayList) {
                controllers.remove(controller3);
                controller3.removed = true;
                Controller.unlink(controller3);
                IdPool.removeId(controller3.getId());
                Controller.removeFromDebugComponents(controller3);
            }
            controller.afterFreeController();
            for (Controller controller4 : arrayList) {
                controller4.afterFreeController();
            }
            Controller.updateDebugComponents();
        }
    }

    private static synchronized void unlink(Controller<?> controller) {
        Link link = null;
        for (Link link2 : links) {
            if (!link2.contains(controller)) continue;
            link = link2;
            break;
        }
        if (link != null) {
            links.remove(link);
        }
    }

    private static void closeModal(Controller<?> controller) {
        Object obj;
        if (controller.isComponentInstancied() && (obj = controller.getComponent()) != null) {
            if (obj instanceof JFrame) {
                JFrame jFrame = (JFrame)obj;
                Modal.closeAllModals(jFrame);
            } else if (obj instanceof JDialog) {
                JDialog jDialog = (JDialog)obj;
                Modal.closeAllModals(jDialog);
            } else if (obj instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)obj;
                Modal.closeAllModals(jInternalFrame);
            }
        }
    }

    protected void beforeFreeController() {
    }

    protected void afterFreeController() {
        if (this.isComponentInstancied() && this.getComponent() instanceof Window) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Window window = (Window)Controller.this.getComponent();
                    window.dispose();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private static synchronized void fetchHierarchy(Controller<?> controller, List<Controller<?>> list) {
        List<Controller<?>> list2 = controller.getChildren();
        for (Controller<?> controller2 : list2) {
            list.add(controller2);
            Controller.fetchHierarchy(controller2, list);
        }
    }

    public static synchronized int count(Class<?> clazz) {
        int n = 0;
        for (Controller<?> controller : controllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            ++n;
        }
        return n;
    }

    public static synchronized <E> E get(Class<E> clazz) {
        if (!Controller.class.isAssignableFrom(clazz)) {
            throw new InvalidControllerClassException(clazz);
        }
        ChildController childController = clazz.getAnnotation(ChildController.class);
        if (childController != null && childController.getOnlyFromGroup()) {
            throw new ControllerException("You need get the child controller " + clazz.getName() + " through the group. Use getGroup().get() or Controller.getFromGroup() method.");
        }
        for (Controller<?> controller : controllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            return clazz.cast(controller);
        }
        return Controller.newInstance(clazz);
    }

    public static synchronized <E> E get(int n, Class<E> clazz) {
        for (Controller<?> controller : controllers) {
            if (controller.getId() != n || !clazz.isAssignableFrom(controller.getClass())) continue;
            return clazz.cast(controller);
        }
        return null;
    }

    public static synchronized <E> E getFromGroup(int n, Class<E> clazz) {
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n || !clazz.isAssignableFrom(controller.getClass())) continue;
            return clazz.cast(controller);
        }
        return null;
    }

    public static synchronized <E> E getFromGroup(int n, int n2, Class<E> clazz) {
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n || controller.getId() != n2 || !clazz.isAssignableFrom(controller.getClass())) continue;
            return clazz.cast(controller);
        }
        return null;
    }

    public static synchronized Controller<?> getFromGroup(int n, int n2) {
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n || controller.getId() != n2) continue;
            return controller;
        }
        return null;
    }

    public static synchronized <E> List<E> getAllFromGroup(int n, Class<E> clazz) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n || !clazz.isAssignableFrom(controller.getClass())) continue;
            arrayList.add(clazz.cast(controller));
        }
        return arrayList;
    }

    public static synchronized List<Controller<?>> getAllFromGroup(int n) {
        ArrayList arrayList = new ArrayList();
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n) continue;
            arrayList.add(controller);
        }
        return arrayList;
    }

    public static synchronized Controller<?> get(int n) {
        for (Controller<?> controller : controllers) {
            if (controller.getId() != n) continue;
            return controller;
        }
        return null;
    }

    private Controller<?> localGet(int n) {
        for (Controller<?> controller : controllers) {
            if (controller.getId() != n) continue;
            return controller;
        }
        return null;
    }

    private static <E> E newInstance(Class<E> clazz) {
        E e = null;
        if (Controller.class.isAssignableFrom(clazz)) {
            try {
                e = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        return e;
    }

    private static void setNewUpControllerId(int n) {
        newParentControllerId = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> E createChild(Class<E> clazz) {
        Object object = parentControllerLock;
        synchronized (object) {
            if (!Controller.class.isAssignableFrom(clazz)) {
                throw new InvalidControllerClassException(clazz);
            }
            if (!controllers.contains(this)) {
                throw new ControllerException("The controller " + this.getClass() + " id (" + this.getId() + ") already had been removed from the pool. ");
            }
            Controller.setNewUpControllerId(this.getId());
            return Controller.newInstance(clazz);
        }
    }

    public static synchronized <E> List<E> getAll(Class<E> clazz) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Controller<?> controller : controllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            arrayList.add(clazz.cast(controller));
        }
        return arrayList;
    }

    public static synchronized List<Controller<?>> getAll() {
        return new ArrayList(controllers);
    }

    public static synchronized <E> E get(Class<E> clazz, Component component) {
        if (!Controller.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Controller<?> controller : controllers) {
            if (!clazz.isAssignableFrom(controller.getClass()) || !controller.isComponentInstancied() || !controller.getComponent().equals(component)) continue;
            return clazz.cast(controller);
        }
        return null;
    }

    public static synchronized Controller<?> get(Component component) {
        for (Controller<?> controller : controllers) {
            if (!controller.isComponentInstancied() || !controller.getComponent().equals(component)) continue;
            return controller;
        }
        return null;
    }

    public static void setModalPanelFactory(ModalPanelFactory modalPanelFactory) {
        if (modalPanelFactory != null) {
            Controller.modalPanelFactory = modalPanelFactory;
        }
    }

    public static ModalPanelFactory getModalPanelFactory() {
        return modalPanelFactory;
    }

    public static synchronized boolean contains(Controller<?> controller) {
        if (controller.isRemoved()) {
            return false;
        }
        return controllers.contains(controller);
    }

    public synchronized boolean isChildInstancied(Class<?> clazz) {
        for (Controller<?> controller : this.childrenControllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            return true;
        }
        return false;
    }

    public synchronized List<Controller<?>> getChildren() {
        return Collections.unmodifiableList(this.childrenControllers);
    }

    public synchronized <E> E getChild(Class<E> clazz) {
        for (Controller<?> controller : this.childrenControllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            return clazz.cast(controller);
        }
        return null;
    }

    public synchronized Controller<?> getChild(int n) {
        for (Controller<?> controller : this.childrenControllers) {
            if (controller.getId() != n) continue;
            return controller;
        }
        return null;
    }

    public synchronized <E> List<E> getChildren(Class<E> clazz) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Controller<?> controller : this.childrenControllers) {
            if (!clazz.isAssignableFrom(controller.getClass())) continue;
            arrayList.add(clazz.cast(controller));
        }
        return arrayList;
    }

    private void addChild(Controller<?> controller) {
        this.childrenControllers.add(controller);
    }

    private void removeChild(Controller<?> controller) {
        this.childrenControllers.remove(controller);
    }

    public Window getWindowAncestor() {
        if (this.isComponentInstancied()) {
            if (this.getComponent() instanceof Window) {
                return (Window)this.getComponent();
            }
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (window != null) {
                return window;
            }
        }
        return null;
    }

    public void requestWindowFocus() {
        Window window = this.getWindowAncestor();
        if (window != null) {
            window.requestFocus();
        }
    }

    public boolean isWindowFocused() {
        Window window = this.getWindowAncestor();
        if (window != null) {
            return window.isFocused();
        }
        return false;
    }

    public void requestFocus() {
        if (this.isComponentInstancied()) {
            ((Component)this.getComponent()).requestFocus();
        }
    }

    public boolean isFocused() {
        if (this.isComponentInstancied()) {
            return ((Component)this.getComponent()).isFocusOwner();
        }
        return false;
    }

    private void setId(int n) {
        this.id = n;
    }

    public final int getId() {
        return this.id;
    }

    private void setGroup(Group group) {
        this.group = group;
    }

    public final Group getGroup() {
        return this.group;
    }

    public final int getGroupId() {
        return this.getGroup().getId();
    }

    public final boolean isPermanent() {
        return this.permanent;
    }

    protected final void setPermanent(boolean bl) {
        this.permanent = bl;
    }

    protected abstract V getComponent();

    public abstract boolean isComponentInstancied();

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.id;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Controller controller = (Controller)object;
        return this.id == controller.id;
    }

    protected <E> E getFromLink(Class<E> clazz) {
        return Controller.getFromLink(this, clazz);
    }

    protected void linkTo(Controller<?> controller) {
        Controller.link(this, controller);
    }

    protected boolean hasLinkTo(Class<?> clazz) {
        return Controller.existsLink(this, clazz);
    }

    protected boolean hasLinkTo(Controller<?> controller) {
        return Controller.existsLink(this, controller);
    }

    protected void unlink() {
        Controller.unlink(this);
    }

    public void free() {
        Controller.free(this.getId(), true);
    }

    public void free(boolean bl) {
        Controller.free(this.getId(), bl);
    }

    public void freeGroup() {
        Controller.freeGroup(this.getGroupId());
    }

    public final void freeAfterExecutions() {
        if (Controller.contains(this)) {
            ControllerTaskListener.getInstance().freeAfterAllExecutions(this);
        }
    }

    public void showQuestionModal(String string, String string2, ModalAction modalAction, ModalAction modalAction2) {
        this.addModal(modalPanelFactory.buildQuestionPanel(this, string, string2, modalAction, modalAction2));
    }

    public void showQuestionModal(String string, String string2, ModalAction modalAction) {
        this.addModal(modalPanelFactory.buildQuestionPanel(this, string, string2, modalAction, null));
    }

    public void showConfirmationModal(String string, String string2, ModalAction modalAction, ModalAction modalAction2) {
        this.addModal(modalPanelFactory.buildConfirmationPanel(this, string, string2, modalAction, modalAction2));
    }

    public void showConfirmationModal(String string, String string2, ModalAction modalAction) {
        this.addModal(modalPanelFactory.buildConfirmationPanel(this, string, string2, modalAction, null));
    }

    public void showInformationModal(String string, String string2) {
        this.addModal(modalPanelFactory.buildInformationPanel(this, string, string2));
    }

    public void showWarningModal(String string, String string2) {
        this.addModal(modalPanelFactory.buildWarningPanel(this, string, string2));
    }

    public void showErrorModal(String string, String string2) {
        this.addModal(modalPanelFactory.buildErrorPanel(this, string, string2));
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public void addModal(Component component) {
        this.addModal(component, null);
    }

    public void addModal(Component component, ModalListener modalListener) {
        this.addModal(component, modalListener, null);
    }

    public void addModal(Component component, ModalListener modalListener, Integer n) {
        Object object;
        Object object2;
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        if (rootPaneContainer == null) {
            return;
        }
        if (rootPaneContainer instanceof JFrame) {
            Modal.addModal((JFrame)rootPaneContainer, component, modalListener, n);
        } else if (rootPaneContainer instanceof JDialog) {
            Modal.addModal((JDialog)rootPaneContainer, component, modalListener, n);
        } else if (rootPaneContainer instanceof JInternalFrame) {
            Modal.addModal((JInternalFrame)rootPaneContainer, component, modalListener, n);
        } else {
            return;
        }
        List<RootPaneContainer> list = Controller.getRootPaneContainers(this.getGroupId());
        if (this.getModalGroupName() != null) {
            object2 = this.getModalGroupName().toLowerCase();
            for (Controller<?> controller : controllers) {
                RootPaneContainer rootPaneContainer2;
                if (controller.getModalGroupName() == null || !((String)object2).equals(object = controller.getModalGroupName().toLowerCase()) || (rootPaneContainer2 = super.getRootPaneContainer()) == null || list.contains(rootPaneContainer2)) continue;
                list.add(rootPaneContainer2);
            }
        }
        list.remove(rootPaneContainer);
        object2 = new ArrayList();
        for (RootPaneContainer rootPaneContainer3 : list) {
            object = new JPanel();
            ((JComponent)object).setOpaque(false);
            object2.add(object);
            if (rootPaneContainer3 instanceof JFrame) {
                Modal.addModal((JFrame)rootPaneContainer3, (Component)object, null, n);
                continue;
            }
            if (!(rootPaneContainer3 instanceof JDialog)) continue;
            Modal.addModal((JDialog)rootPaneContainer3, (Component)object, null, n);
        }
        if (rootPaneContainer instanceof JFrame) {
            Modal.addListener((JFrame)rootPaneContainer, component, (ModalListener)new ModalAllFramesListener((List<Component>)object2));
        } else if (rootPaneContainer instanceof JDialog) {
            Modal.addListener((JDialog)rootPaneContainer, component, (ModalListener)new ModalAllFramesListener((List<Component>)object2));
        }
    }

    public Component getCurrentModal() {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        if (rootPaneContainer != null) {
            if (rootPaneContainer instanceof JFrame) {
                return Modal.getCurrentModal((JFrame)rootPaneContainer);
            }
            if (rootPaneContainer instanceof JDialog) {
                return Modal.getCurrentModal((JDialog)rootPaneContainer);
            }
        }
        return null;
    }

    public void closeCurrentModal() {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        if (rootPaneContainer != null) {
            if (rootPaneContainer instanceof JFrame) {
                Modal.closeCurrentModal((JFrame)rootPaneContainer);
            } else if (rootPaneContainer instanceof JDialog) {
                Modal.closeCurrentModal((JDialog)rootPaneContainer);
            }
        }
    }

    public void closeModal(Component component) {
        Modal.closeModal(component);
    }

    public void closeAllModals() {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        if (rootPaneContainer != null) {
            if (rootPaneContainer instanceof JFrame) {
                Modal.closeAllModals((JFrame)rootPaneContainer);
            } else if (rootPaneContainer instanceof JDialog) {
                Modal.closeAllModals((JDialog)rootPaneContainer);
            }
        }
    }

    protected boolean hasModal() {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        if (rootPaneContainer == null) {
            return false;
        }
        if (rootPaneContainer instanceof JFrame) {
            return Modal.hasModal((JFrame)rootPaneContainer);
        }
        if (rootPaneContainer instanceof JDialog) {
            return Modal.hasModal((JDialog)rootPaneContainer);
        }
        return false;
    }

    private RootPaneContainer getRootPaneContainer() {
        return Controller.getRootPaneContainer(this);
    }

    private static RootPaneContainer getRootPaneContainer(Controller<?> controller) {
        Object obj = controller.getComponent();
        if (obj != null) {
            if (obj instanceof RootPaneContainer) {
                return (RootPaneContainer)obj;
            }
            for (Container container = ((Component)obj).getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof RootPaneContainer)) continue;
                return (RootPaneContainer)((Object)container);
            }
        }
        return null;
    }

    private static List<RootPaneContainer> getRootPaneContainers(int n) {
        ArrayList<RootPaneContainer> arrayList = new ArrayList<RootPaneContainer>();
        for (Controller<?> controller : controllers) {
            RootPaneContainer rootPaneContainer;
            if (controller.getGroupId() != n || (rootPaneContainer = super.getRootPaneContainer()) == null || arrayList.contains(rootPaneContainer)) continue;
            arrayList.add(rootPaneContainer);
        }
        return arrayList;
    }

    public String getModalGroupName() {
        return this.modalGroupName;
    }

    public void setModalGroupName(String string) {
        this.modalGroupName = string;
    }

    public static void printAllControllers() {
        for (Controller<?> controller : controllers) {
            System.out.println("Id: " + controller.getId() + " GroupId: " + controller.getGroupId() + " Class: " + controller.getClass().getName());
        }
    }

    public final Integer getParentId() {
        if (this.getParent() != null) {
            return this.getParent().getId();
        }
        return null;
    }

    public final Controller<?> getParent() {
        return this.parentController;
    }

    public final boolean isRoot() {
        return this.getParent() == null;
    }

    public final Controller<?> getRoot() {
        Controller<?> controller = this;
        while (controller.getParentId() != null) {
            Controller<?> controller2 = this.localGet(controller.getParentId());
            if (controller2 == null) {
                throw new ControllerException("Controller is not in the pool");
            }
            controller = controller2;
        }
        return controller;
    }

    public static synchronized Controller<?> getRoot(int n) {
        for (Controller<?> controller : controllers) {
            if (controller.getGroupId() != n) continue;
            return controller.getRoot();
        }
        return null;
    }

    protected boolean canExecute(AbstractTask<?> abstractTask) {
        return true;
    }

    protected void execute(AbstractTask<?> abstractTask, String string) {
        this.submitTask(abstractTask, string, false);
    }

    protected void execute(AbstractTask<?> abstractTask) {
        this.submitTask(abstractTask, null, false);
    }

    protected void executeAndFree(AbstractTask<?> abstractTask, String string) {
        this.submitTask(abstractTask, string, true);
    }

    protected void executeAndFree(AbstractTask<?> abstractTask) {
        this.submitTask(abstractTask, null, true);
    }

    protected void cancelExecutions() {
        TaskManager.cancel(this.getGroupId());
    }

    protected void taskExecutionError(AbstractTask<?> abstractTask) {
    }

    private void submitTask(AbstractTask<?> abstractTask, String string, boolean bl) {
        if (!Controller.contains(this)) {
            throw new ControllerException("Controller is not in the pool");
        }
        if (!this.canExecute(abstractTask)) {
            return;
        }
        abstractTask.setControllerWrapper(new ControllerWrapper(this));
        if (string != null) {
            abstractTask.setMessage(string);
        }
        if (bl) {
            ControllerTaskListener.getInstance().freeAfterExecution(this, abstractTask);
        }
        TaskManager.submit(abstractTask);
    }

    protected List<MessageFilter> getMessageFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected void removeMessageFilters() {
        this.filters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSubscriber(Class<? extends Message> clazz, Subscriber subscriber) {
        if (clazz != null && subscriber != null) {
            LinkedHashMap<Class<? extends Message>, List<Subscriber>> linkedHashMap = this.subscribers;
            synchronized (linkedHashMap) {
                List<Subscriber> list = this.subscribers.get(clazz);
                if (list == null) {
                    list = new ArrayList<Subscriber>();
                    this.subscribers.put(clazz, list);
                }
                if (!list.contains(subscriber)) {
                    list.add(subscriber);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscriber(Class<? extends Message> clazz, Subscriber subscriber) {
        if (clazz != null && subscriber != null) {
            LinkedHashMap<Class<? extends Message>, List<Subscriber>> linkedHashMap = this.subscribers;
            synchronized (linkedHashMap) {
                List<Subscriber> list = this.subscribers.get(clazz);
                if (list != null) {
                    list.remove(subscriber);
                    if (list.size() == 0) {
                        this.subscribers.remove(clazz);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscriber(Subscriber subscriber) {
        if (subscriber != null && this.subscribers.size() > 0) {
            LinkedHashMap<Class<? extends Message>, List<Subscriber>> linkedHashMap = this.subscribers;
            synchronized (linkedHashMap) {
                ArrayList<Class<? extends Message>> arrayList = new ArrayList<Class<? extends Message>>();
                for (Class<? extends Message> clazz : this.subscribers.keySet()) {
                    arrayList.add(clazz);
                }
                for (Class<? extends Message> clazz : arrayList) {
                    List<Subscriber> list = this.subscribers.get(clazz);
                    if (list == null) continue;
                    list.remove(subscriber);
                    if (list.size() != 0) continue;
                    this.subscribers.remove(clazz);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscribers(Class<? extends Message> clazz) {
        if (clazz != null) {
            LinkedHashMap<Class<? extends Message>, List<Subscriber>> linkedHashMap = this.subscribers;
            synchronized (linkedHashMap) {
                this.subscribers.remove(clazz);
            }
        }
    }

    protected List<Subscriber> getSubscribers(Class<? extends Message> clazz) {
        List<Subscriber> list = null;
        if (clazz != null) {
            list = this.subscribers.get(clazz);
        }
        if (list == null) {
            return new ArrayList<Subscriber>();
        }
        return Collections.unmodifiableList(list);
    }

    protected int getSubscribersCount(Class<? extends Message> clazz) {
        List<Subscriber> list = null;
        if (clazz != null) {
            list = this.subscribers.get(clazz);
        }
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    protected void removeMessageFilter(MessageFilter messageFilter) {
        if (messageFilter != null) {
            this.filters.remove(messageFilter);
        }
    }

    protected boolean containsMessageFilter(MessageFilter messageFilter) {
        if (messageFilter != null) {
            return this.filters.contains(messageFilter);
        }
        return false;
    }

    protected void addMessageFilter(MessageFilter messageFilter) {
        if (messageFilter != null && !this.filters.contains(messageFilter)) {
            this.filters.add(messageFilter);
        }
    }

    private boolean accepts(Message message) {
        for (MessageFilter messageFilter : this.filters) {
            if (messageFilter.accepts(message)) continue;
            return false;
        }
        return true;
    }

    private static void publishToAll(Message message) {
        for (Controller<?> controller : Controller.getAll()) {
            if (message.isConsumed()) break;
            if (message.getPublisher() != null && message.isIgnorePublisher() && message.getPublisher().getId() == controller.getId() || !super.accepts(message) || !message.acceptsController(controller)) continue;
            controller.subscribe(message);
        }
    }

    protected final void publish(Message message) {
        message.setPublisher(this);
        Controller.publishToAll(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribe(Message message) {
        if (message == null) {
            return;
        }
        LinkedHashMap<Class<? extends Message>, List<Subscriber>> linkedHashMap = this.subscribers;
        synchronized (linkedHashMap) {
            for (Map.Entry<Class<? extends Message>, List<Subscriber>> entry : this.subscribers.entrySet()) {
                List<Subscriber> list;
                if (message.isConsumed() || message.isControllerConsumed()) break;
                Class<? extends Message> clazz = entry.getKey();
                if (!clazz.isAssignableFrom(message.getClass()) || (list = entry.getValue()) == null) continue;
                for (Subscriber subscriber : list) {
                    if (!message.acceptsSubscriber(subscriber)) continue;
                    subscriber.performMessage(message);
                }
            }
        }
    }

    static {
        TaskManager.addListener(ControllerTaskListener.getInstance());
        modalPanelFactory = new DefaultModalPanelFactory();
        controllers = new ArrayList();
        links = new ArrayList<Link>();
        parentControllerLock = new Object();
    }

    private static class ModalAllFramesListener
    implements ModalListener {
        private List<Component> components;

        public ModalAllFramesListener(List<Component> list) {
            this.components = list;
        }

        @Override
        public void modalClosed(ModalEvent modalEvent) {
            for (Component component : this.components) {
                Modal.closeModal(component);
            }
        }
    }
}

