/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.ResultSet;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.types.Type;

public class RowType
extends Type {
    final Type[] dataTypes;

    public RowType(Type[] dataTypes) {
        super(19, 19, 0L, 0);
        this.dataTypes = dataTypes;
    }

    public int displaySize() {
        return 0;
    }

    public int getJDBCTypeCode() {
        return 0;
    }

    public Class getJDBCClass() {
        return ResultSet.class;
    }

    public String getJDBCClassName() {
        return "java.sql.ResultSet";
    }

    public int getJDBCScale() {
        return 0;
    }

    public int getJDBCPrecision() {
        return 0;
    }

    public int getSQLGenericTypeCode() {
        return 19;
    }

    public boolean isRowType() {
        return true;
    }

    public String getNameString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ROW");
        sb.append('(');
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.dataTypes[i].getDefinition());
        }
        sb.append(')');
        return sb.toString();
    }

    public String getDefinition() {
        return this.getNameString();
    }

    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arrb = (Object[])b;
        Object[] arra = (Object[])a;
        int length = arra.length;
        if (arrb.length < length) {
            length = arrb.length;
        }
        for (int i = 0; i < length; ++i) {
            int result = this.dataTypes[i].compare(session, arra[i], arrb[i]);
            if (result == 0) continue;
            return result;
        }
        if (arra.length > arrb.length) {
            return 1;
        }
        if (arra.length < arrb.length) {
            return -1;
        }
        return 0;
    }

    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataTypes[i].convertToTypeLimits(session, arra[i]);
        }
        return arrb;
    }

    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType == null) {
            return a;
        }
        if (!otherType.isRowType()) {
            throw Error.error(5562);
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataTypes[i].convertToType(session, arra[i], otherTypes[i]);
        }
        return arrb;
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return o;
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return this.convertToSQLString(a);
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        Object[] arra = (Object[])a;
        StringBuffer sb = new StringBuffer();
        sb.append("ROW");
        sb.append('(');
        for (int i = 0; i < arra.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.dataTypes[i].convertToSQLString(arra[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean canConvertFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.dataTypes[i].canConvertFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.dataTypes[i].canBeAssignedFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    public Type getAggregateType(Type otherType) {
        if (otherType == null) {
            return this;
        }
        if (otherType == this) {
            return this;
        }
        if (!otherType.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.dataTypes.length];
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            newTypes[i] = this.dataTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    public Type getCombinedType(Type otherType, int operation) {
        if (operation != 36) {
            return this.getAggregateType(otherType);
        }
        if (otherType == null) {
            return this;
        }
        if (!otherType.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.dataTypes.length];
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            newTypes[i] = this.dataTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    public Type[] getTypesArray() {
        return this.dataTypes;
    }

    public int compare(Session session, Object a, Object b, SortAndSlice sort) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = (Object[])b;
        int length = sort.sortOrder.length;
        for (int i = 0; i < length; ++i) {
            int result;
            a = arra[sort.sortOrder[i]];
            b = arrb[sort.sortOrder[i]];
            if (a == b) continue;
            if (sort.sortNullsLast[i]) {
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
            }
            if ((result = this.dataTypes[i].compare(session, a, b)) == 0) continue;
            if (sort.sortDescending[i]) {
                return -result;
            }
            return result;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Type) {
            if (((Type)other).typeCode != 19) {
                return false;
            }
            Type[] otherTypes = ((RowType)other).dataTypes;
            if (otherTypes.length != this.dataTypes.length) {
                return false;
            }
            int i = 0;
            if (i < this.dataTypes.length) {
                return this.dataTypes[i].equals(otherTypes[i]);
            }
        }
        return false;
    }

    public static String convertToSQLString(Object[] array, Type[] types, int maxUnitLength) {
        if (array == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String value = types[i].convertToSQLString(array[i]);
            if (maxUnitLength > 7 && value.length() > maxUnitLength) {
                sb.append(value.substring(0, maxUnitLength - 4));
                sb.append(" ...");
                continue;
            }
            sb.append(value);
        }
        sb.append(')');
        return sb.toString();
    }
}

