/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Clob;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Type;

public final class ClobType
extends CharacterType {
    public static final long maxClobPrecision = 0x10000000000L;
    public static final int defaultClobSize = 0x1000000;

    public ClobType(long precision) {
        super(40, precision);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return 2005;
    }

    public Class getJDBCClass() {
        return Clob.class;
    }

    public String getJDBCClassName() {
        return "java.sql.Clob";
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 1024L == 0L) {
            if (this.precision % 0x40000000L == 0L) {
                factor = this.precision / 0x40000000L;
                multiplier = "G";
            } else if (this.precision % 0x100000L == 0L) {
                factor = this.precision / 0x100000L;
                multiplier = "M";
            } else {
                factor = this.precision / 1024L;
                multiplier = "K";
            }
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    public boolean isLobType() {
        return true;
    }

    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (b instanceof String) {
            return session.database.lobManager.compare((ClobData)a, (String)b);
        }
        return session.database.lobManager.compare((ClobData)a, (ClobData)b);
    }

    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ClobData) {
            return a;
        }
        if (a instanceof String) {
            ClobDataID clob = session.createClob(((String)a).length());
            clob.setString(session, 0L, (String)a);
            return clob;
        }
        throw Error.error(5561);
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return ((ClobData)a).toString();
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        String s = this.convertToString(a);
        return StringConverter.toQuotedString(s, '\'', true);
    }

    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCClobClient) {
            return ((JDBCClobClient)a).getClob();
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ClobDataID) {
            ClobDataID clob = (ClobDataID)a;
            return new JDBCClobClient(session, clob);
        }
        throw Error.error(5561);
    }

    public long position(SessionInterface session, Object data, Object otherData, Type otherType, long start) {
        if (otherType.typeCode == 40) {
            return ((ClobData)data).position(session, (ClobData)otherData, start);
        }
        if (otherType.isCharacterType()) {
            return ((ClobData)data).position(session, (String)otherData, start);
        }
        throw Error.runtimeError(201, "ClobType");
    }
}

