/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.store.BitMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public final class BitType
extends BinaryType {
    static final long maxBitPrecision = 1024L;

    public BitType(int type, long precision) {
        super(type, precision);
    }

    public int displaySize() {
        return (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return -7;
    }

    public Class getJDBCClass() {
        return byte[].class;
    }

    public String getJDBCClassName() {
        return "[B";
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public String getNameString() {
        return this.typeCode == 14 ? "BIT" : "BIT VARYING";
    }

    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(this.precision);
        sb.append(')');
        return sb.toString();
    }

    public boolean isBitType() {
        return true;
    }

    public long getMaxPrecision() {
        return 1024L;
    }

    public boolean requiresPrecision() {
        return this.typeCode == 15;
    }

    public Type getAggregateType(Type other) {
        if (this.typeCode == other.typeCode) {
            return this.precision >= other.precision ? this : other;
        }
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 14: {
                return this.precision >= other.precision ? this : BitType.getBitType(this.typeCode, other.precision);
            }
            case 15: {
                return other.precision >= this.precision ? other : BitType.getBitType(other.typeCode, this.precision);
            }
            case 30: 
            case 60: 
            case 61: {
                return other;
            }
        }
        throw Error.error(5562);
    }

    public Type getCombinedType(Type other, int operation) {
        Type newType;
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        long newPrecision = this.precision + other.precision;
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 14: {
                newType = this;
                break;
            }
            case 15: {
                newType = other;
                break;
            }
            case 30: 
            case 60: 
            case 61: {
                return other.getCombinedType(this, operation);
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (newPrecision > 1024L) {
            if (this.typeCode == 14) {
                throw Error.error(5570);
            }
            newPrecision = 1024L;
        }
        return BitType.getBitType(newType.typeCode, newPrecision);
    }

    public int compare(Session session, Object a, Object b) {
        int i = super.compare(session, a, b);
        if (i == 0 && a != null) {
            if (((BinaryData)a).bitLength(null) == ((BinaryData)b).bitLength(null)) {
                return 0;
            }
            return ((BinaryData)a).bitLength(null) > ((BinaryData)b).bitLength(null) ? 1 : -1;
        }
        return i;
    }

    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return this.castOrConvertToType(null, a, this, false);
    }

    public Object castToType(SessionInterface session, Object a, Type otherType) {
        return this.castOrConvertToType(session, a, otherType, true);
    }

    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        return this.castOrConvertToType(session, a, otherType, false);
    }

    Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        byte[] data;
        BlobData b;
        if (a == null) {
            return null;
        }
        switch (otherType.typeCode) {
            case 1: 
            case 12: {
                b = session.getScanner().convertToBit((String)a);
                otherType = BitType.getBitType(15, b.length(session));
                break;
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: {
                b = (BlobData)a;
                break;
            }
            case 16: {
                if (this.precision != 1L) {
                    throw Error.error(3471);
                }
                if (((Boolean)a).booleanValue()) {
                    return BinaryData.singleBitOne;
                }
                return BinaryData.singleBitZero;
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                if (this.precision != 1L) {
                    throw Error.error(3471);
                }
                if (((NumberType)otherType).compareToZero(a) == 0) {
                    return BinaryData.singleBitZero;
                }
                return BinaryData.singleBitOne;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (b.bitLength(session) > this.precision) {
            if (!cast) {
                throw Error.error(3401);
            }
            session.addWarning(Error.error(1004));
        }
        int bytePrecision = (int)((this.precision + 7L) / 8L);
        if (otherType.typeCode == 30) {
            byte[] bytes = b.getBytes(session, 0L, bytePrecision);
            b = new BinaryData(bytes, this.precision);
        }
        switch (this.typeCode) {
            case 14: {
                if (b.bitLength(session) == this.precision) {
                    return b;
                }
                if (b.length(session) > (long)bytePrecision) {
                    data = b.getBytes(session, 0L, bytePrecision);
                    b = new BinaryData(data, this.precision);
                    break;
                }
                if (b.length(session) > (long)bytePrecision) break;
                data = (byte[])ArrayUtil.resizeArray(b.getBytes(), bytePrecision);
                b = new BinaryData(data, this.precision);
                break;
            }
            case 15: {
                if (b.bitLength(session) <= this.precision) {
                    return b;
                }
                if (b.length(session) <= (long)bytePrecision) break;
                data = b.getBytes(session, 0L, bytePrecision);
                b = new BinaryData(data, this.precision);
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        data = b.getBytes();
        int i = (int)this.precision;
        while ((long)i < b.length(session) * 8L) {
            BitMap.unset(data, i);
            ++i;
        }
        return b;
    }

    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof byte[]) {
            BinaryData data = new BinaryData((byte[])a, ((byte[])a).length);
            return this.convertToTypeLimits(session, data);
        }
        if (a instanceof BinaryData) {
            return this.convertToTypeLimits(session, a);
        }
        if (a instanceof String) {
            return this.convertToType(session, a, Type.SQL_VARCHAR);
        }
        if (a instanceof Boolean) {
            return this.convertToType(session, a, Type.SQL_BOOLEAN);
        }
        if (a instanceof Integer) {
            return this.convertToType(session, a, Type.SQL_INTEGER);
        }
        if (a instanceof Long) {
            return this.convertToType(session, a, Type.SQL_BIGINT);
        }
        throw Error.error(3471);
    }

    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return this.convertToDefaultType(session, a);
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return StringConverter.byteArrayToBitString(((BinaryData)a).getBytes(), (int)((BinaryData)a).bitLength(null));
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLBitString(((BinaryData)a).getBytes(), (int)((BinaryData)a).bitLength(null));
    }

    public boolean canConvertFrom(Type otherType) {
        return otherType.typeCode == 0 || otherType.isBinaryType() || this.precision == 1L && (otherType.isIntegralType() || otherType.isBooleanType()) || otherType.isCharacterType();
    }

    public long position(SessionInterface session, BlobData data, BlobData otherData, Type otherType, long offset) {
        if (data == null || otherData == null) {
            return -1L;
        }
        long otherLength = data.bitLength(session);
        if (offset + otherLength > data.bitLength(session)) {
            return -1L;
        }
        throw Error.runtimeError(201, "BitType");
    }

    public BlobData substring(SessionInterface session, BlobData data, long offset, long length, boolean hasLength) {
        long end;
        long dataLength = data.bitLength(session);
        if (hasLength) {
            end = offset + length;
        } else {
            long l = end = dataLength > offset ? dataLength : offset;
        }
        if (end < offset) {
            throw Error.error(3431);
        }
        if (offset > end || end < 0L) {
            offset = 0L;
            end = 0L;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (end > dataLength) {
            end = dataLength;
        }
        length = end - offset;
        byte[] dataBytes = data.getBytes();
        byte[] bytes = new byte[(int)(length + 7L) / 8];
        int i = (int)offset;
        while ((long)i < end) {
            if (BitMap.isSet(dataBytes, i)) {
                BitMap.set(bytes, i - (int)offset);
            }
            ++i;
        }
        return new BinaryData(bytes, length);
    }

    int getRightTrimSize(BinaryData data) {
        int i;
        byte[] bytes = data.getBytes();
        for (i = (int)data.bitLength(null) - 1; i >= 0 && !BitMap.isSet(bytes, i); --i) {
        }
        return i + 1;
    }

    public BlobData overlay(Session session, BlobData value, BlobData overlay, long offset, long length, boolean hasLength) {
        if (value == null || overlay == null) {
            return null;
        }
        if (!hasLength) {
            length = overlay.bitLength(session);
        }
        switch (this.typeCode) {
            case 14: 
            case 15: {
                byte[] data = (byte[])ArrayUtil.duplicateArray(value.getBytes());
                byte[] overlaydata = overlay.getBytes();
                int i = 0;
                int pos = (int)offset;
                while ((long)i < length) {
                    int count = 8;
                    if (length - (long)pos < 8L) {
                        count = (int)length - pos;
                    }
                    BitMap.overlay(data, pos, overlaydata[i], count);
                    pos += 8;
                    ++i;
                }
                BinaryData binary = new BinaryData(data, value.bitLength(session));
                return binary;
            }
        }
        throw Error.runtimeError(201, "BitType");
    }

    public Object concat(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        long length = ((BlobData)a).bitLength(session) + ((BlobData)b).bitLength(session);
        if (length > Integer.MAX_VALUE) {
            throw Error.error(1000);
        }
        byte[] aData = ((BlobData)a).getBytes();
        byte[] bData = ((BlobData)b).getBytes();
        int aLength = (int)((BlobData)a).bitLength(session);
        int bLength = (int)((BlobData)b).bitLength(session);
        byte[] bytes = new byte[(int)(length + 7L) / 8];
        System.arraycopy(aData, 0, bytes, 0, aData.length);
        for (int i = 0; i < bLength; ++i) {
            if (!BitMap.isSet(bData, i)) continue;
            BitMap.set(bytes, aLength + i);
        }
        return new BinaryData(bytes, length);
    }

    public static BinaryType getBitType(int type, long precision) {
        switch (type) {
            case 14: 
            case 15: {
                return new BitType(type, precision);
            }
        }
        throw Error.runtimeError(201, "BitType");
    }
}

