/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlProperties;

public class ServerProperties
extends HsqlProperties {
    static final int SERVER_PROPERTY = 0;
    static final int SERVER_MULTI_PROPERTY = 1;
    static final int SYSTEM_PROPERTY = 2;
    static final String sc_key_prefix = "server";
    static final String sc_key_address = "server.address";
    static final String sc_key_autorestart_server = "server.restart_on_shutdown";
    static final String sc_key_database = "server.database";
    static final String sc_key_dbname = "server.dbname";
    static final String sc_key_no_system_exit = "server.no_system_exit";
    static final String sc_key_port = "server.port";
    static final String sc_key_http_port = "server.port";
    static final String sc_key_silent = "server.silent";
    static final String sc_key_tls = "server.tls";
    static final String sc_key_trace = "server.trace";
    static final String sc_key_web_default_page = "server.default_page";
    static final String sc_key_web_root = "server.root";
    static final String sc_key_max_connections = "server.maxconnections";
    static final String sc_key_remote_open_db = "server.remote_open";
    static final String sc_key_max_databases = "server.maxdatabases";
    static final String sc_key_acl = "server.acl";
    static final String sc_key_daemon = "server.daemon";
    static final String sc_key_props = "server.props";
    static final String sc_key_system = "system";
    static final String sc_default_web_mime = "text/html";
    static final String sc_default_web_page = "index.html";
    static final String sc_default_web_root = ".";
    static final HashMap meta = new HashMap();
    static final OrderedHashSet prefixes = new OrderedHashSet();
    final int protocol;
    protected boolean initialised;
    IntKeyHashMap idToAliasMap;
    IntKeyHashMap idToPathMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerProperties(int protocol, File file) throws IOException {
        block3: {
            this.initialised = false;
            this.idToAliasMap = new IntKeyHashMap();
            this.idToPathMap = new IntKeyHashMap();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.stringProps.load(fis);
                Object var5_4 = null;
                if (fis == null) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        this.protocol = protocol;
    }

    ServerProperties(int protocol) {
        this.initialised = false;
        this.idToAliasMap = new IntKeyHashMap();
        this.idToPathMap = new IntKeyHashMap();
        this.protocol = protocol;
    }

    ServerProperties(int protocol, String path, String extension) {
        super(path, extension);
        this.initialised = false;
        this.idToAliasMap = new IntKeyHashMap();
        this.idToPathMap = new IntKeyHashMap();
        this.protocol = protocol;
    }

    public void validate() {
        Enumeration<?> en = this.stringProps.propertyNames();
        while (en.hasMoreElements()) {
            String error;
            String key = (String)en.nextElement();
            Object[] metadata = (Object[])meta.get(key);
            if (metadata == null) {
                metadata = this.getPrefixedMetadata(key);
            }
            if (metadata == null) {
                error = "unsupported property: " + key;
                super.addError(0, error);
                continue;
            }
            error = null;
            if ((Integer)metadata[1] == 2) {
                error = this.validateSystemProperty(key, metadata);
            } else if ((Integer)metadata[1] == 1) {
                error = this.validateMultiProperty(key, metadata);
            } else {
                String value = this.getProperty(key);
                if (value == null) {
                    if (metadata[4] == null) {
                        error = "missing value for property: " + key;
                    } else {
                        this.setProperty(key, metadata[4].toString());
                    }
                } else {
                    error = HsqlProperties.validateProperty(key, value, metadata);
                }
            }
            if (error == null) continue;
            super.addError(0, error);
        }
        Iterator it = this.idToAliasMap.keySet().iterator();
        while (it.hasNext()) {
            int number = it.nextInt();
            if (this.idToPathMap.containsKey(number)) continue;
            this.addError(0, "no path for database id: " + number);
        }
        it = this.idToPathMap.keySet().iterator();
        while (it.hasNext()) {
            int number = it.nextInt();
            if (this.idToAliasMap.containsKey(number)) continue;
            this.addError(0, "no alias for database id: " + number);
        }
        this.initialised = true;
    }

    Object[] getPrefixedMetadata(String key) {
        for (int i = 0; i < prefixes.size(); ++i) {
            String prefix = (String)prefixes.get(i);
            if (!key.startsWith(prefix)) continue;
            return (Object[])meta.get(prefix);
        }
        return null;
    }

    String validateMultiProperty(String key, Object[] meta) {
        String path;
        String alias;
        Object existing;
        int dbNumber;
        String prefix = (String)meta[0];
        try {
            dbNumber = Integer.parseInt(key.substring(prefix.length() + 1));
        }
        catch (NumberFormatException e1) {
            return "maformed database enumerator: " + key;
        }
        if (meta[0].equals(sc_key_dbname) ? (existing = this.idToAliasMap.put(dbNumber, alias = this.stringProps.getProperty(key).toLowerCase())) != null : meta[0].equals(sc_key_database) && (existing = this.idToPathMap.put(dbNumber, path = this.stringProps.getProperty(key))) != null) {
            return "duplicate database enumerator: " + key;
        }
        return null;
    }

    String validateSystemProperty(String key, Object[] meta) {
        String prefix = (String)meta[0];
        String specificKey = key.substring(prefix.length() + 1);
        String value = this.stringProps.getProperty(key);
        if (value == null) {
            return "value required for property: " + key;
        }
        System.setProperty(specificKey, value);
        return null;
    }

    static {
        meta.put(sc_key_database, ServerProperties.getMeta(sc_key_database, 1, null));
        meta.put(sc_key_dbname, ServerProperties.getMeta(sc_key_dbname, 1, null));
        meta.put(sc_key_system, ServerProperties.getMeta(sc_key_system, 2, null));
        meta.put(sc_key_silent, ServerProperties.getMeta(sc_key_silent, 0, false));
        meta.put(sc_key_trace, ServerProperties.getMeta(sc_key_trace, 0, false));
        meta.put(sc_key_tls, ServerProperties.getMeta(sc_key_tls, 0, false));
        meta.put(sc_key_acl, ServerProperties.getMeta(sc_key_acl, 0, null));
        meta.put(sc_key_autorestart_server, ServerProperties.getMeta(sc_key_autorestart_server, 0, false));
        meta.put(sc_key_remote_open_db, ServerProperties.getMeta(sc_key_remote_open_db, 0, false));
        meta.put(sc_key_no_system_exit, ServerProperties.getMeta(sc_key_no_system_exit, 0, false));
        meta.put(sc_key_daemon, ServerProperties.getMeta(sc_key_daemon, 0, false));
        meta.put(sc_key_address, ServerProperties.getMeta(sc_key_address, 0, null));
        meta.put("server.port", ServerProperties.getMeta("server.port", 0, 9001, 0, 65535));
        meta.put("server.port", ServerProperties.getMeta("server.port", 0, 80, 0, 65535));
        meta.put(sc_key_max_connections, ServerProperties.getMeta(sc_key_max_connections, 0, 100, 1, 10000));
        meta.put(sc_key_max_databases, ServerProperties.getMeta(sc_key_max_databases, 0, 10, 1, 1000));
        prefixes.add(sc_key_database);
        prefixes.add(sc_key_dbname);
        prefixes.add(sc_key_system);
    }
}

