/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.result.Result;
import org.hsqldb.server.HsqlSocketFactory;
import org.hsqldb.server.HsqlSocketRequestHandler;
import org.hsqldb.server.ServerAcl;
import org.hsqldb.server.ServerConfiguration;
import org.hsqldb.server.ServerConnection;
import org.hsqldb.server.ServerProperties;
import org.hsqldb.server.WebServer;
import org.hsqldb.server.WebServerConnection;

public class Server
implements HsqlSocketRequestHandler {
    protected static final int serverBundleHandle = BundleHandler.getBundleHandle("org_hsqldb_Server_messages", null);
    ServerProperties serverProperties;
    HashSet serverConnSet;
    protected String[] dbAlias;
    protected String[] dbType;
    protected String[] dbPath;
    protected HsqlProperties[] dbProps;
    protected int[] dbID;
    protected long[] dbActionSequence;
    HashSet aliasSet = new HashSet();
    protected int maxConnections;
    volatile long actionSequence;
    protected String serverId;
    protected int serverProtocol;
    protected ThreadGroup serverConnectionThreadGroup;
    protected HsqlSocketFactory socketFactory;
    protected ServerSocket socket;
    private Thread serverThread;
    private Throwable serverError;
    private volatile int serverState;
    private volatile boolean isSilent;
    protected volatile boolean isRemoteOpen;
    protected boolean isDaemon;
    private PrintWriter logWriter;
    private PrintWriter errWriter;
    private ServerAcl acl = null;
    private volatile boolean isShuttingDown;

    public Thread getServerThread() {
        return this.serverThread;
    }

    public Server() {
        this(1);
    }

    protected Server(int protocol) {
        this.init(protocol);
    }

    public void checkRunning(boolean running) {
        boolean error;
        this.printWithThread("checkRunning(" + running + ") entered");
        int state = this.getState();
        boolean bl = error = running && state != 1 || !running && state != 16;
        if (error) {
            String msg = "server is " + (running ? "not " : "") + "running";
            throw Error.error(458, msg);
        }
        this.printWithThread("checkRunning(" + running + ") exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalCloseAllServerConnections() {
        WrapperIterator it;
        this.printWithThread("signalCloseAllServerConnections() entered");
        HashSet hashSet = this.serverConnSet;
        synchronized (hashSet) {
            it = new WrapperIterator(this.serverConnSet.toArray(null));
        }
        while (it.hasNext()) {
            ServerConnection sc = (ServerConnection)it.next();
            this.printWithThread("Closing " + sc);
            sc.signalClose();
        }
        this.printWithThread("signalCloseAllServerConnections() exited");
    }

    protected void finalize() throws Throwable {
        if (this.serverThread != null) {
            this.releaseServerSocket();
        }
    }

    public String getAddress() {
        return this.socket == null ? this.serverProperties.getProperty("server.address") : this.socket.getInetAddress().getHostAddress();
    }

    public String getDatabaseName(int index, boolean asconfigured) {
        if (asconfigured) {
            return this.serverProperties.getProperty("server.dbname." + index);
        }
        if (this.getState() == 1) {
            return this.dbAlias == null || index < 0 || index >= this.dbAlias.length ? null : this.dbAlias[index];
        }
        return null;
    }

    public String getDatabasePath(int index, boolean asconfigured) {
        if (asconfigured) {
            return this.serverProperties.getProperty("server.database." + index);
        }
        if (this.getState() == 1) {
            return this.dbPath == null || index < 0 || index >= this.dbPath.length ? null : this.dbPath[index];
        }
        return null;
    }

    public String getDatabaseType(int index) {
        return this.dbType == null || index < 0 || index >= this.dbType.length ? null : this.dbType[index];
    }

    public String getDefaultWebPage() {
        return "[IGNORED]";
    }

    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "server.help");
    }

    public PrintWriter getErrWriter() {
        return this.errWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getPort() {
        return this.serverProperties.getIntegerProperty("server.port", ServerConfiguration.getDefaultPort(this.serverProtocol, this.isTls()));
    }

    public String getProductName() {
        return "HSQLDB server";
    }

    public String getProductVersion() {
        return "2.2.5";
    }

    public String getProtocol() {
        return this.isTls() ? "HSQLS" : "HSQL";
    }

    public Throwable getServerError() {
        return this.serverError;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getState() {
        return this.serverState;
    }

    public String getStateDescriptor() {
        String state;
        Throwable t = this.getServerError();
        switch (this.serverState) {
            case 16: {
                state = "SHUTDOWN";
                break;
            }
            case 4: {
                state = "OPENING";
                break;
            }
            case 8: {
                state = "CLOSING";
                break;
            }
            case 1: {
                state = "ONLINE";
                break;
            }
            default: {
                state = "UNKNOWN";
            }
        }
        return state;
    }

    public String getWebRoot() {
        return "[IGNORED]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket s) {
        String ctn;
        Runnable r;
        this.printWithThread("handleConnection(" + s + ") entered");
        if (!this.allowConnection(s)) {
            try {
                s.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.printWithThread("allowConnection(): connection refused");
            this.printWithThread("handleConnection() exited");
            return;
        }
        if (this.socketFactory != null) {
            this.socketFactory.configureSocket(s);
        }
        if (this.serverProtocol == 1) {
            r = new ServerConnection(s, this);
            ctn = r.getConnectionThreadName();
            HashSet hashSet = this.serverConnSet;
            synchronized (hashSet) {
                this.serverConnSet.add(r);
            }
        } else {
            r = new WebServerConnection(s, (WebServer)this);
            ctn = ((WebServerConnection)r).getConnectionThreadName();
        }
        Thread t = new Thread(this.serverConnectionThreadGroup, r, ctn);
        t.start();
        this.printWithThread("handleConnection() exited");
    }

    public boolean isNoSystemExit() {
        return this.serverProperties.isPropertyTrue("server.no_system_exit");
    }

    public boolean isRestartOnShutdown() {
        return this.serverProperties.isPropertyTrue("server.restart_on_shutdown");
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public boolean isTls() {
        return this.serverProperties.isPropertyTrue("server.tls");
    }

    public boolean isTrace() {
        return this.serverProperties.isPropertyTrue("server.trace");
    }

    public boolean putPropertiesFromFile(String path) {
        return this.putPropertiesFromFile(path, ".properties");
    }

    public boolean putPropertiesFromFile(String path, String extension) {
        if (this.getState() != 16) {
            throw Error.error(458, "server properties");
        }
        path = FileUtil.getFileUtil().canonicalOrAbsolutePath(path);
        ServerProperties p = ServerConfiguration.getPropertiesFromFile(1, path, extension);
        if (p == null || p.isEmpty()) {
            return false;
        }
        this.printWithThread("putPropertiesFromFile(): [" + path + ".properties]");
        try {
            this.setProperties(p);
        }
        catch (Exception e) {
            throw Error.error(e, 458, 26, new String[]{"Failed to set properties"});
        }
        return true;
    }

    public void putPropertiesFromString(String s) {
        if (this.getState() != 16) {
            throw Error.error(458);
        }
        if (StringUtil.isEmpty(s)) {
            return;
        }
        this.printWithThread("putPropertiesFromString(): [" + s + "]");
        HsqlProperties p = HsqlProperties.delimitedArgPairsToProps(s, "=", ";", "server");
        try {
            this.setProperties(p);
        }
        catch (Exception e) {
            throw Error.error(e, 458, 26, new String[]{"Failed to set properties"});
        }
    }

    public void setAddress(String address) {
        this.checkRunning(false);
        if (StringUtil.isEmpty(address)) {
            address = "0.0.0.0";
        }
        this.printWithThread("setAddress(" + address + ")");
        this.serverProperties.setProperty("server.address", address);
    }

    public void setDatabaseName(int index, String name) {
        this.checkRunning(false);
        this.printWithThread("setDatabaseName(" + index + "," + name + ")");
        this.serverProperties.setProperty("server.dbname." + index, name);
    }

    public void setDatabasePath(int index, String path) {
        this.checkRunning(false);
        this.printWithThread("setDatabasePath(" + index + "," + path + ")");
        this.serverProperties.setProperty("server.database." + index, path);
    }

    public void setDefaultWebPage(String file) {
        this.checkRunning(false);
        this.printWithThread("setDefaultWebPage(" + file + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.default_page", file);
    }

    public void setPort(int port) {
        this.checkRunning(false);
        this.printWithThread("setPort(" + port + ")");
        this.serverProperties.setProperty("server.port", port);
    }

    public void setErrWriter(PrintWriter pw) {
        this.errWriter = pw;
    }

    public void setLogWriter(PrintWriter pw) {
        this.logWriter = pw;
    }

    public void setNoSystemExit(boolean noExit) {
        this.printWithThread("setNoSystemExit(" + noExit + ")");
        this.serverProperties.setProperty("server.no_system_exit", noExit);
    }

    public void setRestartOnShutdown(boolean restart) {
        this.printWithThread("setRestartOnShutdown(" + restart + ")");
        this.serverProperties.setProperty("server.restart_on_shutdown", restart);
    }

    public void setSilent(boolean silent) {
        this.printWithThread("setSilent(" + silent + ")");
        this.serverProperties.setProperty("server.silent", silent);
        this.isSilent = silent;
    }

    public void setTls(boolean tls) {
        this.checkRunning(false);
        this.printWithThread("setTls(" + tls + ")");
        this.serverProperties.setProperty("server.tls", tls);
    }

    public void setTrace(boolean trace) {
        this.printWithThread("setTrace(" + trace + ")");
        this.serverProperties.setProperty("server.trace", trace);
        JavaSystem.setLogToSystem(trace);
    }

    public void setDaemon(boolean daemon) {
        this.checkRunning(false);
        this.printWithThread("setDaemon(" + daemon + ")");
        this.serverProperties.setProperty("server.daemon", daemon);
    }

    public void setWebRoot(String root) {
        this.checkRunning(false);
        root = new File(root).getAbsolutePath();
        this.printWithThread("setWebRoot(" + root + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.root", root);
    }

    public void setProperties(HsqlProperties props) throws IOException, ServerAcl.AclFormatException {
        this.checkRunning(false);
        if (props != null) {
            props.validate();
            String[] errors = props.getErrorKeys();
            if (errors.length > 0) {
                throw Error.error(407, errors[0]);
            }
            this.serverProperties.addProperties(props);
        }
        this.maxConnections = this.serverProperties.getIntegerProperty("server.maxconnections", 16);
        JavaSystem.setLogToSystem(this.isTrace());
        this.isSilent = this.serverProperties.isPropertyTrue("server.silent");
        this.isRemoteOpen = this.serverProperties.isPropertyTrue("server.remote_open");
        this.isDaemon = this.serverProperties.isPropertyTrue("server.daemon");
        String aclFilepath = this.serverProperties.getProperty("server.acl");
        if (aclFilepath != null) {
            this.acl = new ServerAcl(new File(aclFilepath));
            if (this.logWriter != null && !this.isSilent) {
                this.acl.setPrintWriter(this.logWriter);
            }
        }
    }

    public int start() {
        this.printWithThread("start() entered");
        int previousState = this.getState();
        if (this.serverThread != null) {
            this.printWithThread("start(): serverThread != null; no action taken");
            return previousState;
        }
        this.setState(4);
        this.serverThread = new ServerThread("HSQLDB Server ");
        if (this.isDaemon) {
            this.serverThread.setDaemon(true);
        }
        this.serverThread.start();
        while (this.getState() == 4) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.printWithThread("start() exiting");
        return previousState;
    }

    public int stop() {
        this.printWithThread("stop() entered");
        int previousState = this.getState();
        if (this.serverThread == null) {
            this.printWithThread("stop() serverThread is null; no action taken");
            return previousState;
        }
        this.releaseServerSocket();
        this.printWithThread("stop() exiting");
        return previousState;
    }

    protected boolean allowConnection(Socket socket) {
        if (this.isShuttingDown) {
            return false;
        }
        return this.acl == null ? true : this.acl.permitAccess(socket.getInetAddress().getAddress());
    }

    protected void init(int protocol) {
        this.serverState = 16;
        this.serverConnSet = new HashSet();
        this.serverId = this.toString();
        this.serverId = this.serverId.substring(this.serverId.lastIndexOf(46) + 1);
        this.serverProtocol = protocol;
        this.serverProperties = ServerConfiguration.newDefaultProperties(protocol);
        this.logWriter = new PrintWriter(System.out);
        this.errWriter = new PrintWriter(System.err);
        JavaSystem.setLogToSystem(this.isTrace());
    }

    protected synchronized void setState(int state) {
        this.serverState = state;
    }

    public final void notify(int action, int id) {
        this.printWithThread("notifiy(" + action + "," + id + ") entered");
        if (action != 0) {
            return;
        }
        this.releaseDatabase(id);
        boolean shutdown = true;
        for (int i = 0; i < this.dbID.length; ++i) {
            if (this.dbAlias[i] == null) continue;
            shutdown = false;
        }
        if (!this.isRemoteOpen && shutdown) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void releaseDatabase(int id) {
        WrapperIterator it;
        boolean found = false;
        this.printWithThread("releaseDatabase(" + id + ") entered");
        for (int i = 0; i < this.dbID.length; ++i) {
            if (this.dbID[i] != id || this.dbAlias[i] == null) continue;
            this.dbID[i] = 0;
            this.dbActionSequence[i] = 0L;
            this.dbAlias[i] = null;
            this.dbPath[i] = null;
            this.dbType[i] = null;
            this.dbProps[i] = null;
        }
        HashSet i = this.serverConnSet;
        synchronized (i) {
            it = new WrapperIterator(this.serverConnSet.toArray(null));
        }
        while (it.hasNext()) {
            ServerConnection sc = (ServerConnection)it.next();
            if (sc.dbID != id) continue;
            sc.signalClose();
            this.serverConnSet.remove(sc);
        }
        this.printWithThread("releaseDatabase(" + id + ") exiting");
    }

    protected void print(String msg) {
        PrintWriter writer = this.logWriter;
        if (writer != null) {
            writer.println("[" + this.serverId + "]: " + msg);
            writer.flush();
        }
    }

    final void printResource(String key) {
        if (serverBundleHandle < 0) {
            return;
        }
        String resource = BundleHandler.getString(serverBundleHandle, key);
        if (resource == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(resource, "\n\r");
        while (st.hasMoreTokens()) {
            this.print(st.nextToken());
        }
    }

    protected void printStackTrace(Throwable t) {
        if (this.errWriter != null) {
            t.printStackTrace(this.errWriter);
            this.errWriter.flush();
        }
    }

    final void printWithTimestamp(String msg) {
        this.print(HsqlDateTime.getSytemTimeString() + " " + msg);
    }

    protected void printWithThread(String msg) {
        if (!this.isSilent()) {
            this.print("[" + Thread.currentThread() + "]: " + msg);
        }
    }

    protected void printError(String msg) {
        PrintWriter writer = this.errWriter;
        if (writer != null) {
            writer.print("[" + this.serverId + "]: ");
            writer.print("[" + Thread.currentThread() + "]: ");
            writer.println(msg);
            writer.flush();
        }
    }

    final void printRequest(int cid, Result r) {
        if (this.isSilent()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cid);
        sb.append(':');
        block0 : switch (r.getType()) {
            case 37: {
                sb.append("SQLCLI:SQLPREPARE ");
                sb.append(r.getMainString());
                break;
            }
            case 34: {
                sb.append(r.getMainString());
                break;
            }
            case 21: 
            case 35: {
                sb.append("SQLCLI:SQLEXECUTE:");
                sb.append(r.getStatementID());
                break;
            }
            case 9: {
                sb.append("SQLCLI:SQLEXECUTE:");
                sb.append("BATCHMODE:");
                sb.append(r.getStatementID());
                break;
            }
            case 41: {
                sb.append("SQLCLI:RESULTUPDATE:");
                sb.append(r.getStatementID());
                break;
            }
            case 36: {
                sb.append("SQLCLI:SQLFREESTMT:");
                sb.append(r.getStatementID());
                break;
            }
            case 7: {
                sb.append("HSQLCLI:GETSESSIONATTR");
                break;
            }
            case 6: {
                sb.append("HSQLCLI:SETSESSIONATTR:");
                break;
            }
            case 33: {
                sb.append("SQLCLI:SQLENDTRAN:");
                switch (r.getActionType()) {
                    case 0: {
                        sb.append("COMMIT");
                        break block0;
                    }
                    case 1: {
                        sb.append("ROLLBACK");
                        break block0;
                    }
                    case 4: {
                        sb.append("SAVEPOINT_NAME_RELEASE ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                    case 2: {
                        sb.append("SAVEPOINT_NAME_ROLLBACK ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                }
                sb.append(r.getActionType());
                break;
            }
            case 39: {
                sb.append("SQLCLI:SQLSTARTTRAN");
                break;
            }
            case 32: {
                sb.append("SQLCLI:SQLDISCONNECT");
                break;
            }
            case 38: {
                sb.append("SQLCLI:SQLSETCONNECTATTR:");
                switch (r.getConnectionAttrType()) {
                    case 10027: {
                        sb.append("SQL_ATTR_SAVEPOINT_NAME ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                }
                sb.append(r.getConnectionAttrType());
                break;
            }
            case 40: {
                sb.append("HQLCLI:CLOSE_RESULT:RESULT_ID ");
                sb.append(r.getResultId());
                break;
            }
            case 13: {
                sb.append("HQLCLI:REQUESTDATA:RESULT_ID ");
                sb.append(r.getResultId());
                sb.append(" ROWOFFSET ");
                sb.append(r.getUpdateCount());
                sb.append(" ROWCOUNT ");
                sb.append(r.getFetchSize());
                break;
            }
            default: {
                sb.append("SQLCLI:MODE:");
                sb.append(r.getType());
            }
        }
        this.print(sb.toString());
    }

    final synchronized int getDBIndex(String aliasPath) {
        int dbIndex;
        int semipos = aliasPath.indexOf(59);
        String alias = aliasPath;
        String filepath = null;
        if (semipos != -1) {
            alias = aliasPath.substring(0, semipos);
            filepath = aliasPath.substring(semipos + 1);
        }
        if ((dbIndex = ArrayUtil.find(this.dbAlias, alias)) == -1) {
            if (filepath == null) {
                HsqlException e = Error.error(458, "database alias does not exist");
                this.printError("database alias=" + alias + " does not exist");
                this.setServerError(e);
                throw e;
            }
            return this.openDatabase(alias, filepath);
        }
        return dbIndex;
    }

    final int openDatabase(String alias, String datapath) {
        if (!this.isRemoteOpen) {
            HsqlException e = Error.error(458, "remote open not allowed");
            this.printError("Remote database open not allowed");
            this.setServerError(e);
            throw e;
        }
        int i = this.getFirstEmptyDatabaseIndex();
        if (i < -1 && (i = this.closeOldestDatabase()) < -1) {
            HsqlException e = Error.error(458, "limit of open databases reached");
            this.printError("limit of open databases reached");
            this.setServerError(e);
            throw e;
        }
        HsqlProperties newprops = DatabaseURL.parseURL(datapath, false, false);
        if (newprops == null) {
            HsqlException e = Error.error(458, "invalid database path");
            this.printError("invalid database path");
            this.setServerError(e);
            throw e;
        }
        String path = newprops.getProperty("database");
        String type = newprops.getProperty("connection_type");
        try {
            int dbid;
            this.dbID[i] = dbid = DatabaseManager.getDatabase(type, path, this, newprops);
            this.dbActionSequence[i] = this.actionSequence;
            this.dbAlias[i] = alias;
            this.dbPath[i] = path;
            this.dbType[i] = type;
            this.dbProps[i] = newprops;
            return i;
        }
        catch (HsqlException e) {
            this.printError("Database [index=" + i + ", db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] did not open: " + e.toString());
            this.setServerError(e);
            throw e;
        }
    }

    final int getFirstEmptyDatabaseIndex() {
        for (int i = 0; i < this.dbAlias.length; ++i) {
            if (this.dbAlias[i] != null) continue;
            return i;
        }
        return -1;
    }

    final boolean openDatabases() {
        this.printWithThread("openDatabases() entered");
        boolean success = false;
        this.setDBInfoArrays();
        for (int i = 0; i < this.dbAlias.length; ++i) {
            int id;
            if (this.dbAlias[i] == null) continue;
            this.printWithThread("Opening database: [" + this.dbType[i] + this.dbPath[i] + "]");
            StopWatch sw = new StopWatch();
            try {
                this.dbID[i] = id = DatabaseManager.getDatabase(this.dbType[i], this.dbPath[i], this, this.dbProps[i]);
                success = true;
            }
            catch (HsqlException e) {
                this.printError("Database [index=" + i + ", db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] did not open: " + e.toString());
                this.setServerError(e);
                this.dbAlias[i] = null;
                this.dbPath[i] = null;
                this.dbType[i] = null;
                this.dbProps[i] = null;
                continue;
            }
            sw.stop();
            String msg = "Database [index=" + i + ", id=" + id + ", db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] opened sucessfully";
            this.print(sw.elapsedTimeToMessage(msg));
        }
        this.printWithThread("openDatabases() exiting");
        if (this.isRemoteOpen) {
            success = true;
        }
        if (!success && this.getServerError() == null) {
            this.setServerError(Error.error(407));
        }
        return success;
    }

    private void setDBInfoArrays() {
        int max;
        IntKeyHashMap dbNumberMap = this.getDBNameArray();
        int maxDatabases = dbNumberMap.size();
        if (this.serverProperties.isPropertyTrue("server.remote_open") && maxDatabases < (max = this.serverProperties.getIntegerProperty("server.maxdatabases", 10))) {
            maxDatabases = max;
        }
        this.dbAlias = new String[maxDatabases];
        this.dbPath = new String[this.dbAlias.length];
        this.dbType = new String[this.dbAlias.length];
        this.dbID = new int[this.dbAlias.length];
        this.dbActionSequence = new long[this.dbAlias.length];
        this.dbProps = new HsqlProperties[this.dbAlias.length];
        Iterator it = dbNumberMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            int dbNumber = it.nextInt();
            String path = this.getDatabasePath(dbNumber, true);
            if (path == null) {
                this.printWithThread("missing database path: " + dbNumberMap.get(dbNumber));
                continue;
            }
            HsqlProperties dbURL = DatabaseURL.parseURL(path, false, false);
            if (dbURL == null) {
                this.printWithThread("malformed database path: " + path);
                continue;
            }
            this.dbAlias[i] = (String)dbNumberMap.get(dbNumber);
            this.dbPath[i] = dbURL.getProperty("database");
            this.dbType[i] = dbURL.getProperty("connection_type");
            this.dbProps[i] = dbURL;
            ++i;
        }
    }

    private IntKeyHashMap getDBNameArray() {
        String prefix = "server.dbname.";
        int prefixLen = "server.dbname.".length();
        IntKeyHashMap idToAliasMap = new IntKeyHashMap();
        Enumeration en = this.serverProperties.propertyNames();
        while (en.hasMoreElements()) {
            Object existing;
            int dbNumber;
            String key = (String)en.nextElement();
            if (!key.startsWith("server.dbname.")) continue;
            try {
                dbNumber = Integer.parseInt(key.substring(prefixLen));
            }
            catch (NumberFormatException e1) {
                this.printWithThread("maformed database enumerator: " + key);
                continue;
            }
            String alias = this.serverProperties.getProperty(key).toLowerCase();
            if (!this.aliasSet.add(alias)) {
                this.printWithThread("duplicate alias: " + alias);
            }
            if ((existing = idToAliasMap.put(dbNumber, alias)) == null) continue;
            this.printWithThread("duplicate database enumerator: " + key);
        }
        return idToAliasMap;
    }

    private void openServerSocket() throws Exception {
        this.printWithThread("openServerSocket() entered");
        if (this.isTls()) {
            this.printWithThread("Requesting TLS/SSL-encrypted JDBC");
        }
        StopWatch sw = new StopWatch();
        this.socketFactory = HsqlSocketFactory.getInstance(this.isTls());
        String address = this.getAddress();
        int port = this.getPort();
        if (StringUtil.isEmpty(address) || "0.0.0.0".equalsIgnoreCase(address.trim())) {
            this.socket = this.socketFactory.createServerSocket(port);
        } else {
            try {
                this.socket = this.socketFactory.createServerSocket(port, address);
            }
            catch (UnknownHostException e) {
                Object[] messageParameters;
                int messageID;
                String[] candidateAddrs = ServerConfiguration.listLocalInetAddressNames();
                if (candidateAddrs.length > 0) {
                    messageID = 61;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < candidateAddrs.length; ++i) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(candidateAddrs[i]);
                    }
                    messageParameters = new Object[]{address, sb.toString()};
                } else {
                    messageID = 62;
                    messageParameters = new Object[]{address};
                }
                throw new UnknownHostException(Error.getMessage(messageID, 0, messageParameters));
            }
        }
        this.socket.setSoTimeout(1000);
        this.printWithThread("Got server socket: " + this.socket);
        this.print(sw.elapsedTimeToMessage("Server socket opened successfully"));
        if (this.socketFactory.isSecure()) {
            this.print("Using TLS/SSL-encrypted JDBC");
        }
        this.printWithThread("openServerSocket() exiting");
    }

    private void printServerOnlineMessage() {
        String s = this.getProductName() + " " + this.getProductVersion() + " is online on port " + this.getPort();
        this.printWithTimestamp(s);
        this.printResource("online.help");
    }

    protected void printProperties() {
        if (this.isSilent()) {
            return;
        }
        Enumeration e = this.serverProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.serverProperties.getProperty(key);
            this.printWithThread(key + "=" + value);
        }
    }

    private void releaseServerSocket() {
        this.printWithThread("releaseServerSocket() entered");
        if (this.socket != null) {
            this.printWithThread("Releasing server socket: [" + this.socket + "]");
            this.setState(8);
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.printError("Exception closing server socket");
                this.printError("releaseServerSocket(): " + e);
            }
            this.socket = null;
        }
        this.printWithThread("releaseServerSocket() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.printWithThread("run() entered");
        this.print("Initiating startup sequence...");
        this.printProperties();
        StopWatch sw = new StopWatch();
        this.setServerError(null);
        try {
            this.openServerSocket();
        }
        catch (Exception e) {
            this.setServerError(e);
            this.printError("run()/openServerSocket(): ");
            this.printStackTrace(e);
            this.shutdown(true);
            return;
        }
        String tgName = "HSQLDB Connections @" + Integer.toString(this.hashCode(), 16);
        ThreadGroup tg = new ThreadGroup(tgName);
        tg.setDaemon(false);
        this.serverConnectionThreadGroup = tg;
        if (!this.openDatabases()) {
            this.setServerError(null);
            this.printError("Shutting down because there are no open databases");
            this.shutdown(true);
            return;
        }
        this.setState(1);
        this.print(sw.elapsedTimeToMessage("Startup sequence completed"));
        this.printServerOnlineMessage();
        this.isShuttingDown = false;
        try {
            try {
                while (this.socket != null) {
                    try {
                        this.handleConnection(this.socket.accept());
                    }
                    catch (InterruptedIOException iioe) {}
                }
                Object var6_8 = null;
                this.shutdown(false);
            }
            catch (IOException ioe) {
                if (this.getState() == 1) {
                    this.setServerError(ioe);
                    this.printError(this + ".run()/handleConnection(): ");
                    this.printStackTrace(ioe);
                }
                Object var6_9 = null;
                this.shutdown(false);
            }
            catch (Throwable t) {
                this.printWithThread(t.toString());
                Object var6_10 = null;
                this.shutdown(false);
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.shutdown(false);
            throw throwable;
        }
    }

    protected void setServerError(Throwable t) {
        this.serverError = t;
    }

    public void shutdownCatalogs(int shutdownMode) {
        DatabaseManager.shutdownDatabases(this, shutdownMode);
    }

    public void shutdownWithCatalogs(int shutdownMode) {
        this.isShuttingDown = true;
        DatabaseManager.shutdownDatabases(this, shutdownMode);
        this.shutdown(false);
        this.isShuttingDown = false;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    protected synchronized void shutdown(boolean error) {
        int i;
        if (this.serverState == 16) {
            return;
        }
        this.printWithThread("shutdown() entered");
        StopWatch sw = new StopWatch();
        this.print("Initiating shutdown sequence...");
        this.releaseServerSocket();
        DatabaseManager.deRegisterServer(this);
        if (this.dbPath != null) {
            for (i = 0; i < this.dbPath.length; ++i) {
                this.releaseDatabase(this.dbID[i]);
            }
        }
        if (this.serverConnectionThreadGroup != null) {
            if (!this.serverConnectionThreadGroup.isDestroyed()) {
                i = 0;
                while (this.serverConnectionThreadGroup.activeCount() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
                try {
                    this.serverConnectionThreadGroup.destroy();
                    this.printWithThread(this.serverConnectionThreadGroup.getName() + " destroyed");
                }
                catch (Throwable t) {
                    this.printWithThread(this.serverConnectionThreadGroup.getName() + " not destroyed");
                    this.printWithThread(t.toString());
                }
            }
            this.serverConnectionThreadGroup = null;
        }
        this.serverThread = null;
        this.setState(16);
        this.print(sw.elapsedTimeToMessage("Shutdown sequence completed"));
        if (this.isNoSystemExit()) {
            this.printWithTimestamp("SHUTDOWN : System.exit() was not called");
            this.printWithThread("shutdown() exited");
        } else {
            this.printWithTimestamp("SHUTDOWN : System.exit() is called next");
            this.printWithThread("shutdown() exiting...");
            try {
                System.exit(0);
            }
            catch (Throwable t) {
                this.printWithThread(t.toString());
            }
        }
    }

    synchronized void setActionSequence(int dbIndex) {
        ++this.actionSequence;
    }

    protected int closeOldestDatabase() {
        return -1;
    }

    protected static void printHelp(String key) {
        System.out.println(BundleHandler.getString(serverBundleHandle, key));
    }

    public static void main(String[] args) {
        ServerProperties fileProps;
        HsqlProperties argProps = null;
        argProps = HsqlProperties.argArrayToProps(args, "server");
        String[] errors = argProps.getErrorKeys();
        if (errors.length != 0) {
            System.out.println("no value for argument:" + errors[0]);
            Server.printHelp("server.help");
            return;
        }
        String propsPath = argProps.getProperty("server.props");
        String propsExtension = "";
        if (propsPath == null) {
            propsPath = "server";
            propsExtension = ".properties";
        }
        ServerProperties props = (fileProps = ServerConfiguration.getPropertiesFromFile(1, propsPath = FileUtil.getFileUtil().canonicalOrAbsolutePath(propsPath), propsExtension)) == null ? new ServerProperties(1) : fileProps;
        props.addProperties(argProps);
        ServerConfiguration.translateDefaultDatabaseProperty(props);
        ServerConfiguration.translateDefaultNoSystemExitProperty(props);
        ServerConfiguration.translateAddressProperty(props);
        Server server = new Server();
        try {
            server.setProperties(props);
        }
        catch (Exception e) {
            server.printError("Failed to set properties");
            server.printStackTrace(e);
            return;
        }
        server.print("Startup sequence initiated from main() method");
        if (fileProps != null) {
            server.print("Loaded properties from [" + propsPath + ".properties]");
        } else {
            server.print("Could not load properties from file");
            server.print("Using cli/default properties only");
        }
        server.start();
    }

    private class ServerThread
    extends Thread {
        ServerThread(String name) {
            super(name);
            this.setName(name + '@' + Integer.toString(Server.this.hashCode(), 16));
        }

        public void run() {
            Server.this.run();
            Server.this.printWithThread("ServerThread.run() exited");
        }
    }
}

