/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptReaderDecode
extends ScriptReaderText {
    DataInputStream dataInput;
    Crypto crypto;
    byte[] buffer = new byte[256];

    public ScriptReaderDecode(Database db, String fileName, Crypto crypto, boolean forLog) throws IOException {
        this(db, db.logger.getFileAccess().openInputStreamElement(fileName), crypto, forLog);
    }

    public ScriptReaderDecode(Database db, InputStream inputStream, Crypto crypto, boolean forLog) throws IOException {
        super(db);
        this.crypto = crypto;
        this.rowIn = new RowInputTextLog();
        if (forLog) {
            this.dataInput = new DataInputStream(new BufferedInputStream(inputStream));
        } else {
            InputStream stream = crypto.getInputStream(new BufferedInputStream(inputStream));
            stream = new GZIPInputStream(stream);
            this.dataStreamIn = new LineReader(stream, "ISO-8859-1");
        }
    }

    public boolean readLoggedStatement(Session session) {
        String s;
        int count;
        if (this.dataInput == null) {
            return super.readLoggedStatement(session);
        }
        try {
            count = this.dataInput.readInt();
            if (count * 2 > this.buffer.length) {
                this.buffer = new byte[count * 2];
            }
            this.dataInput.readFully(this.buffer, 0, count);
        }
        catch (Throwable t) {
            return false;
        }
        count = this.crypto.decode(this.buffer, 0, count, this.buffer, 0);
        try {
            s = new String(this.buffer, 0, count, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw Error.error(e, 452, null);
        }
        ++this.lineCount;
        this.statement = StringConverter.unicodeStringToString(s);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

