/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputTextLog
extends RowOutputBase {
    static byte[] BYTES_NULL;
    static byte[] BYTES_TRUE;
    static byte[] BYTES_FALSE;
    static byte[] BYTES_AND;
    static byte[] BYTES_IS;
    static byte[] BYTES_ARRAY;
    public static final int MODE_DELETE = 1;
    public static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;
    private boolean noSeparators;

    public void setMode(int mode) {
        this.logMode = mode;
    }

    protected void writeFieldPrefix() {
        if (!this.noSeparators && this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    protected void writeChar(String s, Type t) {
        this.write(39);
        StringConverter.stringToUnicodeBytes(this, s, true);
        this.write(39);
    }

    protected void writeReal(Double o) {
        this.writeBytes(Type.SQL_DOUBLE.convertToSQLString(o));
    }

    protected void writeSmallint(Number o) {
        this.writeBytes(o.toString());
    }

    public void writeEnd() {
    }

    protected void writeBit(BinaryData o) {
        this.ensureRoom((int)(o.length(null) * 8L + 2L));
        this.write(39);
        String s = StringConverter.byteArrayToBitString(o.getBytes(), (int)o.bitLength(null));
        this.writeBytes(s);
        this.write(39);
    }

    protected void writeBinary(BinaryData o) {
        this.ensureRoom((int)(o.length(null) * 2L + 2L));
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, o.getBytes());
        this.count = (int)((long)this.count + o.length(null) * 2L);
        this.write(39);
    }

    protected void writeClob(ClobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    protected void writeBlob(BlobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    protected void writeArray(Object[] o, Type type) {
        type = type.collectionBaseType();
        this.noSeparators = true;
        this.write(BYTES_ARRAY);
        for (int i = 0; i < o.length; ++i) {
            if (i > 0) {
                this.write(44);
            }
            this.writeData(type, o[i]);
        }
        this.write(93);
        this.noSeparators = false;
    }

    public void writeType(int type) {
    }

    public void writeSize(int size) {
    }

    public int getSize(Row row) {
        return 0;
    }

    public int getStorageSize(int size) {
        return size;
    }

    protected void writeInteger(Number o) {
        this.writeBytes(o.toString());
    }

    protected void writeBigint(Number o) {
        this.writeBytes(o.toString());
    }

    protected void writeNull(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(BYTES_IS);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
        this.write(BYTES_NULL);
    }

    protected void writeOther(JavaObjectData o) {
        this.ensureRoom(o.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, o.getBytes());
        this.count += o.getBytesLength() * 2;
        this.write(39);
    }

    public void writeString(String value) {
        StringConverter.stringToUnicodeBytes(this, value, false);
    }

    protected void writeBoolean(Boolean o) {
        this.write(o != false ? BYTES_TRUE : BYTES_FALSE);
    }

    protected void writeDecimal(BigDecimal o, Type type) {
        this.writeBytes(type.convertToSQLString(o));
    }

    protected void writeFieldType(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(61);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
    }

    public void writeLong(long value) {
        this.writeBytes(Long.toString(value));
    }

    public void writeIntData(int i, int position) {
    }

    protected void writeTime(TimeData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    protected void writeDate(TimestampData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    protected void writeTimestamp(TimestampData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    public void writeShort(int i) {
        this.writeBytes(Integer.toString(i));
    }

    public void writeInt(int i) {
        this.writeBytes(Integer.toString(i));
    }

    public void reset() {
        super.reset();
        this.isWritten = false;
    }

    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }

    static {
        try {
            BYTES_NULL = "NULL".getBytes("ISO-8859-1");
            BYTES_TRUE = "TRUE".getBytes("ISO-8859-1");
            BYTES_FALSE = "FALSE".getBytes("ISO-8859-1");
            BYTES_AND = " AND ".getBytes("ISO-8859-1");
            BYTES_IS = " IS ".getBytes("ISO-8859-1");
            BYTES_ARRAY = " ARRAY[".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Error.runtimeError(201, "RowOutputTextLog");
        }
    }
}

