/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowOutputInterface;

public final class ResultLob
extends Result {
    long lobID;
    int subType;
    long blockOffset;
    long blockLength;
    byte[] byteBlock;
    char[] charBlock;
    Reader reader;
    InputStream stream;

    private ResultLob() {
        super(18);
    }

    public static ResultLob newLobGetLengthRequest(long id) {
        ResultLob result = new ResultLob();
        result.subType = 10;
        result.lobID = id;
        return result;
    }

    public static ResultLob newLobGetBytesRequest(long id, long offset, int length) {
        ResultLob result = new ResultLob();
        result.subType = 1;
        result.lobID = id;
        result.blockOffset = offset;
        result.blockLength = length;
        return result;
    }

    public static ResultLob newLobGetCharsRequest(long id, long offset, int length) {
        ResultLob result = new ResultLob();
        result.subType = 3;
        result.lobID = id;
        result.blockOffset = offset;
        result.blockLength = length;
        return result;
    }

    public static ResultLob newLobSetBytesRequest(long id, long offset, byte[] block) {
        ResultLob result = new ResultLob();
        result.subType = 2;
        result.lobID = id;
        result.blockOffset = offset;
        result.byteBlock = block;
        result.blockLength = block.length;
        return result;
    }

    public static ResultLob newLobSetCharsRequest(long id, long offset, char[] chars) {
        ResultLob result = new ResultLob();
        result.subType = 4;
        result.lobID = id;
        result.blockOffset = offset;
        result.charBlock = chars;
        result.blockLength = chars.length;
        return result;
    }

    public static ResultLob newLobTruncateRequest(long id, long offset) {
        ResultLob result = new ResultLob();
        result.subType = 9;
        result.lobID = id;
        result.blockOffset = offset;
        return result;
    }

    public static ResultLob newLobGetBytesResponse(long id, long offset, byte[] block) {
        ResultLob result = new ResultLob();
        result.subType = 21;
        result.lobID = id;
        result.blockOffset = offset;
        result.byteBlock = block;
        result.blockLength = block.length;
        return result;
    }

    public static ResultLob newLobGetCharsResponse(long id, long offset, char[] chars) {
        ResultLob result = new ResultLob();
        result.subType = 23;
        result.lobID = id;
        result.blockOffset = offset;
        result.charBlock = chars;
        result.blockLength = chars.length;
        return result;
    }

    public static ResultLob newLobSetResponse(long id, long length) {
        ResultLob result = new ResultLob();
        result.subType = 22;
        result.lobID = id;
        result.blockLength = length;
        return result;
    }

    public static ResultLob newLobGetBytePatternPositionRequest(long id, byte[] pattern, long offset) {
        ResultLob result = new ResultLob();
        result.subType = 5;
        result.lobID = id;
        result.blockOffset = offset;
        result.byteBlock = pattern;
        result.blockLength = pattern.length;
        return result;
    }

    public static ResultLob newLobGetBytePatternPositionRequest(long id, long otherId, long offset) {
        ResultLob result = new ResultLob();
        result.subType = 5;
        result.lobID = id;
        result.blockOffset = offset;
        return result;
    }

    public static ResultLob newLobGetCharPatternPositionRequest(long id, char[] pattern, long offset) {
        ResultLob result = new ResultLob();
        result.subType = 6;
        result.lobID = id;
        result.blockOffset = offset;
        result.charBlock = pattern;
        result.blockLength = pattern.length;
        return result;
    }

    public static ResultLob newLobGetCharPatternPositionRequest(long id, long otherId, long offset) {
        ResultLob result = new ResultLob();
        result.subType = 6;
        result.lobID = id;
        result.blockOffset = offset;
        result.blockLength = otherId;
        return result;
    }

    public static ResultLob newLobCreateBlobRequest(long sessionID, long lobID, InputStream stream, long length) {
        ResultLob result = new ResultLob();
        result.lobID = lobID;
        result.subType = 7;
        result.blockLength = length;
        result.stream = stream;
        return result;
    }

    public static ResultLob newLobCreateClobRequest(long sessionID, long lobID, Reader reader, long length) {
        ResultLob result = new ResultLob();
        result.lobID = lobID;
        result.subType = 8;
        result.blockLength = length;
        result.reader = reader;
        return result;
    }

    public static ResultLob newLobGetTruncateLength(long id) {
        ResultLob result = new ResultLob();
        result.subType = 12;
        result.lobID = id;
        return result;
    }

    public static ResultLob newLobCreateBlobResponse(long id) {
        ResultLob result = new ResultLob();
        result.subType = 27;
        result.lobID = id;
        return result;
    }

    public static ResultLob newLobCreateClobResponse(long id) {
        ResultLob result = new ResultLob();
        result.subType = 28;
        result.lobID = id;
        return result;
    }

    public static ResultLob newLobTruncateResponse(long id) {
        ResultLob result = new ResultLob();
        result.subType = 29;
        result.lobID = id;
        return result;
    }

    public static ResultLob newLobGetRequest(long id, long offset, long length) {
        ResultLob result = new ResultLob();
        result.subType = 11;
        result.lobID = id;
        result.blockOffset = offset;
        result.blockLength = length;
        return result;
    }

    public static ResultLob newLob(DataInput dataInput, boolean readTerminate) throws IOException {
        ResultLob result = new ResultLob();
        result.databaseID = dataInput.readInt();
        result.sessionID = dataInput.readLong();
        result.lobID = dataInput.readLong();
        result.subType = dataInput.readInt();
        switch (result.subType) {
            case 7: 
            case 8: {
                result.blockOffset = dataInput.readLong();
                result.blockLength = dataInput.readLong();
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                result.blockOffset = dataInput.readLong();
                result.blockLength = dataInput.readLong();
                break;
            }
            case 2: 
            case 5: {
                result.blockOffset = dataInput.readLong();
                result.blockLength = dataInput.readLong();
                result.byteBlock = new byte[(int)result.blockLength];
                dataInput.readFully(result.byteBlock);
                break;
            }
            case 4: 
            case 6: {
                result.blockOffset = dataInput.readLong();
                result.blockLength = dataInput.readLong();
                result.charBlock = new char[(int)result.blockLength];
                for (int i = 0; i < result.charBlock.length; ++i) {
                    result.charBlock[i] = dataInput.readChar();
                }
                break;
            }
            case 9: 
            case 10: {
                result.blockOffset = dataInput.readLong();
                break;
            }
            case 21: {
                result.blockOffset = dataInput.readLong();
                result.blockLength = dataInput.readLong();
                result.byteBlock = new byte[(int)result.blockLength];
                dataInput.readFully(result.byteBlock);
                break;
            }
            case 23: {
                result.blockOffset = dataInput.readLong();
                result.blockLength = dataInput.readLong();
                result.charBlock = new char[(int)result.blockLength];
                for (int i = 0; i < result.charBlock.length; ++i) {
                    result.charBlock[i] = dataInput.readChar();
                }
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                result.blockLength = dataInput.readLong();
                break;
            }
            case 25: 
            case 26: {
                result.blockOffset = dataInput.readLong();
                break;
            }
            default: {
                throw Error.runtimeError(201, "ResultLob");
            }
        }
        if (readTerminate) {
            dataInput.readByte();
        }
        return result;
    }

    public void write(SessionInterface session, DataOutputStream dataOut, RowOutputInterface rowOut) throws IOException {
        this.writeBody(session, dataOut);
        dataOut.writeByte(0);
        dataOut.flush();
    }

    public void writeBody(SessionInterface session, DataOutputStream dataOut) throws IOException {
        switch (this.subType) {
            case 7: {
                if (this.blockLength >= 0L) {
                    this.writeCreate(session, dataOut);
                    return;
                }
                this.writeCreateByteSegments(session, dataOut);
                return;
            }
            case 8: {
                if (this.blockLength >= 0L) {
                    this.writeCreate(session, dataOut);
                    return;
                }
                this.writeCreateCharSegments(session, dataOut);
                return;
            }
        }
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        switch (this.subType) {
            case 2: 
            case 5: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.write(this.byteBlock);
                break;
            }
            case 4: 
            case 6: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.writeChars(this.charBlock);
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                break;
            }
            case 9: 
            case 10: {
                dataOut.writeLong(this.blockOffset);
                break;
            }
            case 21: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.write(this.byteBlock);
                break;
            }
            case 23: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.writeChars(this.charBlock);
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                dataOut.writeLong(this.blockLength);
                break;
            }
            case 25: 
            case 26: {
                dataOut.writeLong(this.blockOffset);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ResultLob");
            }
        }
    }

    private void writeCreate(SessionInterface session, DataOutputStream dataOut) throws IOException {
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        dataOut.writeLong(this.blockOffset);
        dataOut.writeLong(this.blockLength);
        switch (this.subType) {
            case 7: {
                dataOut.write(this.stream, this.blockLength);
                break;
            }
            case 8: {
                dataOut.write(this.reader, this.blockLength);
            }
        }
    }

    private void writeCreateByteSegments(SessionInterface session, DataOutputStream dataOut) throws IOException {
        int bufferLength = session.getStreamBlockSize();
        long currentOffset = this.blockOffset;
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        byteArrayOS.reset();
        byteArrayOS.write(this.stream, bufferLength);
        dataOut.writeLong(currentOffset);
        dataOut.writeLong(byteArrayOS.size());
        dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
        currentOffset += (long)byteArrayOS.size();
        if (byteArrayOS.size() < bufferLength) {
            return;
        }
        do {
            byteArrayOS.reset();
            byteArrayOS.write(this.stream, bufferLength);
            if (byteArrayOS.size() == 0) break;
            dataOut.writeByte(this.mode);
            dataOut.writeInt(this.databaseID);
            dataOut.writeLong(this.sessionID);
            dataOut.writeLong(this.lobID);
            dataOut.writeInt(2);
            dataOut.writeLong(currentOffset);
            dataOut.writeLong(byteArrayOS.size());
            dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
            currentOffset += (long)byteArrayOS.size();
        } while (byteArrayOS.size() >= bufferLength);
    }

    private void writeCreateCharSegments(SessionInterface session, DataOutputStream dataOut) throws IOException {
        int bufferLength = session.getStreamBlockSize();
        long currentOffset = this.blockOffset;
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        byteArrayOS.reset();
        byteArrayOS.write(this.reader, bufferLength / 2);
        dataOut.writeLong(currentOffset);
        dataOut.writeLong(byteArrayOS.size() / 2);
        dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
        currentOffset += (long)(byteArrayOS.size() / 2);
        if (byteArrayOS.size() < bufferLength) {
            return;
        }
        do {
            byteArrayOS.reset();
            byteArrayOS.write(this.reader, bufferLength / 2);
            if (byteArrayOS.size() == 0) break;
            dataOut.writeByte(this.mode);
            dataOut.writeInt(this.databaseID);
            dataOut.writeLong(this.sessionID);
            dataOut.writeLong(this.lobID);
            dataOut.writeInt(4);
            dataOut.writeLong(currentOffset);
            dataOut.writeLong(byteArrayOS.size() / 2);
            dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
            currentOffset += (long)(byteArrayOS.size() / 2);
        } while (byteArrayOS.size() >= bufferLength);
    }

    public long getLobID() {
        return this.lobID;
    }

    public int getSubType() {
        return this.subType;
    }

    public long getOffset() {
        return this.blockOffset;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public byte[] getByteArray() {
        return this.byteBlock;
    }

    public char[] getCharArray() {
        return this.charBlock;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public static interface LobResultTypes {
        public static final int REQUEST_GET_BYTES = 1;
        public static final int REQUEST_SET_BYTES = 2;
        public static final int REQUEST_GET_CHARS = 3;
        public static final int REQUEST_SET_CHARS = 4;
        public static final int REQUEST_GET_BYTE_PATTERN_POSITION = 5;
        public static final int REQUEST_GET_CHAR_PATTERN_POSITION = 6;
        public static final int REQUEST_CREATE_BYTES = 7;
        public static final int REQUEST_CREATE_CHARS = 8;
        public static final int REQUEST_TRUNCATE = 9;
        public static final int REQUEST_GET_LENGTH = 10;
        public static final int REQUEST_GET_LOB = 11;
        public static final int REQUEST_GET_TRUNCATE_LENGTH = 12;
        public static final int RESPONSE_GET_BYTES = 21;
        public static final int RESPONSE_SET = 22;
        public static final int RESPONSE_GET_CHARS = 23;
        public static final int RESPONSE_GET_BYTE_PATTERN_POSITION = 25;
        public static final int RESPONSE_GET_CHAR_PATTERN_POSITION = 26;
        public static final int RESPONSE_CREATE_BYTES = 27;
        public static final int RESPONSE_CREATE_CHARS = 28;
        public static final int RESPONSE_TRUNCATE = 29;
    }
}

