/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.ObjectCacheHashMap;

public class TextCache
extends DataFileCache {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    protected String header;
    protected Table table;
    private ObjectCacheHashMap uncommittedCache;
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';

    TextCache(Table table, String name) {
        super(table.database, name);
        this.table = table;
        this.uncommittedCache = new ObjectCacheHashMap(5);
    }

    protected void initParams(Database database, String baseFileName) {
        this.dataFileName = this.dataFileName;
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        HsqlProperties tableprops = HsqlProperties.delimitedArgPairsToProps(baseFileName, "=", ";", "textdb");
        HsqlDatabaseProperties dbProps = database.getProperties();
        switch (tableprops.errorCodes.length) {
            case 0: {
                throw Error.error(301);
            }
            case 1: {
                this.dataFileName = tableprops.errorKeys[0].trim();
                break;
            }
            default: {
                throw Error.error(302);
            }
        }
        this.fs = dbProps.getStringProperty("textdb.fs");
        this.fs = tableprops.getProperty("textdb.fs", this.fs);
        this.vs = dbProps.getStringProperty("textdb.vs");
        this.vs = tableprops.getProperty("textdb.vs", this.vs);
        this.lvs = dbProps.getStringProperty("textdb.lvs");
        this.lvs = tableprops.getProperty("textdb.lvs", this.lvs);
        if (this.vs == null) {
            this.vs = this.fs;
        }
        if (this.lvs == null) {
            this.lvs = this.fs;
        }
        this.fs = TextCache.translateSep(this.fs);
        this.vs = TextCache.translateSep(this.vs);
        this.lvs = TextCache.translateSep(this.lvs);
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Error.error(303);
        }
        this.ignoreFirst = dbProps.isPropertyTrue("textdb.ignore_first");
        this.ignoreFirst = tableprops.isPropertyTrue("textdb.ignore_first", this.ignoreFirst);
        this.isQuoted = dbProps.isPropertyTrue("textdb.quoted");
        this.isQuoted = tableprops.isPropertyTrue("textdb.quoted", this.isQuoted);
        this.isAllQuoted = dbProps.isPropertyTrue("textdb.all_quoted");
        this.isAllQuoted = tableprops.isPropertyTrue("textdb.all_quoted", this.isAllQuoted);
        this.stringEncoding = dbProps.getStringProperty("textdb.encoding");
        this.stringEncoding = tableprops.getProperty("textdb.encoding", this.stringEncoding);
        int cacheScale = dbProps.getIntegerProperty("textdb.cache_scale");
        cacheScale = tableprops.getIntegerProperty("textdb.cache_scale", cacheScale);
        int cacheSizeScale = dbProps.getIntegerProperty("textdb.cache_size_scale");
        cacheSizeScale = tableprops.getIntegerProperty("textdb.cache_size_scale", cacheSizeScale);
        this.maxCacheRows = (1 << cacheScale) * 3;
        this.maxCacheRows = dbProps.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheRows = tableprops.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheBytes = (1 << cacheSizeScale) * this.maxCacheRows / 1024;
        if (this.maxCacheBytes < 4L) {
            this.maxCacheBytes = 4L;
        }
        this.maxCacheBytes = dbProps.getIntegerProperty("textdb.cache_size", (int)this.maxCacheBytes);
        this.maxCacheBytes = tableprops.getIntegerProperty("textdb.cache_size", (int)this.maxCacheBytes);
        this.maxCacheBytes *= 1024L;
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    protected void initBuffers() {
        if (this.isQuoted || this.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
            this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
        }
    }

    private static String translateSep(String sep) {
        return TextCache.translateSep(sep, false);
    }

    private static String translateSep(String sep, boolean isProperty) {
        if (sep == null) {
            return null;
        }
        int next = sep.indexOf(92);
        if (next != -1) {
            int start = 0;
            char[] sepArray = sep.toCharArray();
            int ch = 0;
            int len = sep.length();
            StringBuffer sb = new StringBuffer(len);
            do {
                sb.append(sepArray, start, next - start);
                start = ++next;
                if (next >= len) {
                    sb.append('\\');
                    break;
                }
                if (!isProperty) {
                    ch = sepArray[next];
                }
                if (ch == 110) {
                    sb.append('\n');
                    ++start;
                    continue;
                }
                if (ch == 114) {
                    sb.append('\r');
                    ++start;
                    continue;
                }
                if (ch == 116) {
                    sb.append('\t');
                    ++start;
                    continue;
                }
                if (ch == 92) {
                    sb.append('\\');
                    ++start;
                    continue;
                }
                if (ch == 117) {
                    sb.append((char)Integer.parseInt(sep.substring(++start, start + 4), 16));
                    start += 4;
                    continue;
                }
                if (sep.startsWith("semi", next)) {
                    sb.append(';');
                    start += 4;
                    continue;
                }
                if (sep.startsWith("space", next)) {
                    sb.append(' ');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("quote", next)) {
                    sb.append('\"');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("apos", next)) {
                    sb.append('\'');
                    start += 4;
                    continue;
                }
                sb.append('\\');
                sb.append(sepArray[next]);
                ++start;
            } while ((next = sep.indexOf(92, start)) != -1);
            sb.append(sepArray, start, len - start);
            sep = sb.toString();
        }
        return sep;
    }

    public void open(boolean readonly) {
        this.fileFreePosition = 0L;
        try {
            int type = this.database.getType() == "res:" ? 2 : 5;
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, type);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw Error.error(468);
            }
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 42, new Object[]{t.toString(), this.dataFileName});
        }
        this.cacheReadonly = readonly;
    }

    void reopen() {
        this.open(this.cacheReadonly);
    }

    public void close(boolean write) {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            try {
                this.cache.saveAll();
                boolean empty = this.dataFile.length() <= (long)NL.length();
                this.dataFile.synch();
                this.dataFile.close();
                this.dataFile = null;
                if (empty && !this.cacheReadonly) {
                    FileUtil.getFileUtil().delete(this.dataFileName);
                }
                this.uncommittedCache.clear();
            }
            catch (Throwable t) {
                throw Error.error(t, 452, 43, new Object[]{t.toString(), this.dataFileName});
            }
            Object var4_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            block6: {
                try {
                    this.uncommittedCache.clear();
                    if (this.cacheReadonly) {
                        this.close(false);
                        break block6;
                    }
                    if (this.dataFile != null) {
                        this.dataFile.close();
                        this.dataFile = null;
                    }
                    FileUtil.getFileUtil().delete(this.dataFileName);
                }
                catch (Throwable t) {
                    throw Error.error(t, 452, 44, new Object[]{t.toString(), this.dataFileName});
                }
            }
            Object var3_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    int setFilePos(CachedObject r) {
        int rowSize = r.getStorageSize();
        long newFreePosition = this.fileFreePosition + (long)rowSize;
        if (newFreePosition > this.maxDataFileSize) {
            this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
            throw Error.error(468);
        }
        int i = (int)this.fileFreePosition;
        r.setPos(i);
        this.clearRowImage(r);
        this.fileFreePosition = newFreePosition;
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int pos, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject row = (CachedObject)this.uncommittedCache.remove(pos);
            if (row != null) {
                Object var5_4 = null;
                this.writeLock.unlock();
                return;
            }
            CachedObject cachedObject = this.cache.release(pos);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var5_5 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistence(int pos, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject row = (CachedObject)this.uncommittedCache.remove(pos);
            if (row == null && (row = this.get(pos, store, false)) != null) {
                this.clearRowImage(row);
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    private void clearRowImage(CachedObject row) {
        try {
            int length = row.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream out = this.rowOut.getOutputStream();
            out.fill(32, length);
            out.write(ScriptWriterText.BYTES_LINE_SEP);
            this.dataFile.seek(row.getPos());
            this.dataFile.write(out.getBuffer(), 0, out.size());
        }
        catch (IOException e) {
            throw Error.runtimeError(201, e.getMessage());
        }
    }

    protected RowInputInterface readObject(int pos) {
        try {
            ByteArray buffer = new ByteArray(80);
            boolean complete = false;
            boolean wasCR = false;
            boolean hasQuote = false;
            boolean wasNormal = false;
            pos = this.findNextUsedLinePos(pos);
            if (pos == -1) {
                return null;
            }
            this.dataFile.seek(pos);
            while (!complete) {
                wasNormal = false;
                int c = this.dataFile.read();
                if (c == -1) {
                    if (buffer.length() == 0) {
                        return null;
                    }
                    complete = true;
                    if (wasCR || this.cacheReadonly) break;
                    this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                    break;
                }
                switch (c) {
                    case 34: {
                        wasNormal = true;
                        complete = wasCR;
                        wasCR = false;
                        if (!this.isQuoted) break;
                        hasQuote = !hasQuote;
                        break;
                    }
                    case 13: {
                        wasCR = !hasQuote;
                        break;
                    }
                    case 10: {
                        complete = !hasQuote;
                        break;
                    }
                    default: {
                        wasNormal = true;
                        complete = wasCR;
                        wasCR = false;
                    }
                }
                buffer.append(c);
            }
            if (complete) {
                int length = (int)this.dataFile.getFilePointer() - pos;
                if (wasNormal) {
                    --length;
                }
                ((RowInputText)this.rowIn).setSource(buffer.toString(), pos, length);
                return this.rowIn;
            }
            return null;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    public int readHeaderLine() {
        boolean complete = false;
        boolean wasCR = false;
        boolean wasNormal = false;
        ByteArray buffer = new ByteArray(80);
        while (!complete) {
            int c;
            wasNormal = false;
            try {
                c = this.dataFile.read();
                if (c == -1) {
                    if (buffer.length() == 0) {
                        return 0;
                    }
                    complete = true;
                    if (this.cacheReadonly) break;
                    this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                    break;
                }
            }
            catch (IOException e) {
                throw Error.error(483);
            }
            switch (c) {
                case 13: {
                    wasCR = true;
                    break;
                }
                case 10: {
                    complete = true;
                    break;
                }
                default: {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                }
            }
            if (wasCR || complete) continue;
            buffer.append(c);
        }
        this.header = buffer.toString();
        try {
            int length = (int)this.dataFile.getFilePointer();
            if (wasNormal) {
                --length;
            }
            return length;
        }
        catch (IOException e) {
            throw Error.error(483);
        }
    }

    int findNextUsedLinePos(int pos) {
        try {
            int firstPos = pos;
            int currentPos = pos;
            boolean wasCR = false;
            this.dataFile.seek(pos);
            block8: while (true) {
                int c = this.dataFile.read();
                ++currentPos;
                switch (c) {
                    case 13: {
                        wasCR = true;
                        continue block8;
                    }
                    case 10: {
                        wasCR = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        firstPos = currentPos;
                        continue block8;
                    }
                    case 32: {
                        if (!wasCR) continue block8;
                        wasCR = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1;
                    }
                }
                break;
            }
            if (wasCR) {
                wasCR = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return firstPos;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject object) {
        this.writeLock.lock();
        try {
            this.setFilePos(object);
            this.uncommittedCache.put(object.getPos(), object);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        if (object == null) {
            return null;
        }
        return this.get(object.getPos(), store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(int i, PersistentStore store, boolean keep) {
        CachedObject o;
        block4: {
            if (i < 0) {
                return null;
            }
            this.readLock.lock();
            try {
                o = (CachedObject)this.uncommittedCache.get(i);
                if (o == null) break block4;
                CachedObject cachedObject = o;
                Object var7_6 = null;
                this.readLock.unlock();
                return cachedObject;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Object var7_7 = null;
        this.readLock.unlock();
        o = super.get(i, store, keep);
        return o;
    }

    protected void saveRows(CachedObject[] rows, int offset, int count) {
        if (count == 0) {
            return;
        }
        for (int i = offset; i < offset + count; ++i) {
            CachedObject r = rows[i];
            this.uncommittedCache.put(r.getPos(), r);
            rows[i] = null;
        }
    }

    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            try {
                this.setFileModified();
                this.saveRowNoLock(row);
                this.uncommittedCache.remove(row.getPos());
                this.cache.put(row.getPos(), row);
            }
            catch (Throwable e) {
                this.database.logger.logSevereEvent("saveRow failed", e);
                throw Error.error(466, e);
            }
            Object var4_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        if (this.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(header);
                this.header = header;
            }
            catch (HsqlException e) {
                throw new HsqlException(e, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    private void writeHeader(String header) {
        try {
            byte[] buf = null;
            String firstLine = header + NL;
            try {
                buf = firstLine.getBytes(this.stringEncoding);
            }
            catch (UnsupportedEncodingException e) {
                buf = firstLine.getBytes();
            }
            this.dataFile.write(buf, 0, buf.length);
            this.fileFreePosition = buf.length;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    protected void setFileModified() {
        this.fileModified = true;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n) {
            this.buffer = new byte[n];
            this.buflen = 0;
        }

        public void append(int c) {
            if (this.buflen >= this.buffer.length) {
                byte[] newbuf = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, newbuf, 0, this.buflen);
                this.buffer = newbuf;
            }
            this.buffer[this.buflen] = (byte)c;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int l) {
            this.buflen = l;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

