/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.persist.RandomAccessInterface;

final class ScaledRAFileInJar
implements RandomAccessInterface {
    DataInputStream file;
    final String fileName;
    long fileLength;
    boolean bufferDirty = true;
    byte[] buffer = new byte[4096];
    HsqlByteArrayInputStream ba = new HsqlByteArrayInputStream(this.buffer);
    long bufferOffset;
    long seekPosition;
    long realPosition;

    ScaledRAFileInJar(String name) throws FileNotFoundException, IOException {
        this.fileName = name;
        this.fileLength = this.getLength();
        this.resetStream();
    }

    public long length() throws IOException {
        return this.fileLength;
    }

    public void seek(long position) throws IOException {
        this.seekPosition = position;
    }

    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long filePos = this.seekPosition;
        this.bufferDirty = false;
        long subOffset = filePos % (long)this.buffer.length;
        long readLength = this.fileLength - (filePos - subOffset);
        if (readLength <= 0L) {
            throw new IOException("read beyond end of file");
        }
        if (readLength > (long)this.buffer.length) {
            readLength = this.buffer.length;
        }
        this.fileSeek(filePos - subOffset);
        this.file.readFully(this.buffer, 0, (int)readLength);
        this.bufferOffset = filePos - subOffset;
        this.realPosition = this.bufferOffset + readLength;
    }

    public int read() throws IOException {
        if (this.seekPosition >= this.fileLength) {
            return -1;
        }
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int val = this.ba.read();
        ++this.seekPosition;
        return val;
    }

    public long readLong() throws IOException {
        long hi = this.readInt();
        long lo = this.readInt();
        return (hi << 32) + (lo & 0xFFFFFFFFL);
    }

    public int readInt() throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int val = this.ba.readInt();
        this.seekPosition += 4L;
        return val;
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int bytesRead = this.ba.read(b, offset, length);
        this.seekPosition += (long)bytesRead;
        if (bytesRead < length) {
            if (this.seekPosition != this.realPosition) {
                this.fileSeek(this.seekPosition);
            }
            this.file.readFully(b, offset + bytesRead, length - bytesRead);
            this.seekPosition += (long)(length - bytesRead);
            this.realPosition = this.seekPosition;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
    }

    public void writeInt(int i) throws IOException {
    }

    public void writeLong(long i) throws IOException {
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean wasNio() {
        return false;
    }

    private long getLength() throws IOException {
        int count = 0;
        this.resetStream();
        while (this.file.read() >= 1) {
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetStream() throws IOException {
        InputStream fis;
        block8: {
            if (this.file != null) {
                this.file.close();
            }
            fis = null;
            try {
                block7: {
                    try {
                        ClassLoader cl;
                        fis = this.getClass().getResourceAsStream(this.fileName);
                        if (fis != null || (cl = Thread.currentThread().getContextClassLoader()) == null) break block7;
                        fis = cl.getResourceAsStream(this.fileName);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (fis == null) {
                            throw new FileNotFoundException(this.fileName);
                        }
                        break block8;
                    }
                }
                Object var4_4 = null;
                if (fis != null) break block8;
                throw new FileNotFoundException(this.fileName);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (fis != null) throw throwable;
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.file = new DataInputStream(fis);
    }

    private void fileSeek(long position) throws IOException {
        long skipPosition = this.realPosition;
        if (position < skipPosition) {
            this.resetStream();
            skipPosition = 0L;
        }
        while (position > skipPosition) {
            skipPosition += this.file.skip(position - skipPosition);
        }
    }

    public boolean ensureLength(long newLong) {
        return true;
    }

    public boolean setLength(long newLength) {
        return false;
    }

    public Database getDatabase() {
        return null;
    }

    public void synch() {
    }
}

