/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFileHybrid;
import org.hsqldb.persist.ScaledRAFileInJar;

final class ScaledRAFile
implements RandomAccessInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final int DATA_FILE_STORED = 3;
    static final int DATA_FILE_SINGLE = 4;
    static final int DATA_FILE_TEXT = 5;
    static final int bufferScale = 12;
    static final int bufferSize = 4096;
    static final long bufferMask = -4096L;
    final Database database;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    final byte[] valueBuffer;
    final HsqlByteArrayOutputStream vbao;
    final HsqlByteArrayInputStream vbai;
    long bufferOffset;
    long fileLength;
    final boolean extendLength;
    long seekPosition;
    int cacheHit;

    static RandomAccessInterface newScaledRAFile(Database database, String name, boolean readonly, int type) throws FileNotFoundException, IOException {
        if (type == 3) {
            try {
                String cname = database.getURLProperties().getProperty("storage_class_name");
                String skey = database.getURLProperties().getProperty("storage_key");
                Class<?> zclass = Class.forName(cname);
                Constructor<?> constructor = zclass.getConstructor(String.class, Boolean.class, Object.class);
                return (RandomAccessInterface)constructor.newInstance(name, new Boolean(readonly), skey);
            }
            catch (ClassNotFoundException e) {
                throw new IOException();
            }
            catch (NoSuchMethodException e) {
                throw new IOException();
            }
            catch (InstantiationException e) {
                throw new IOException();
            }
            catch (IllegalAccessException e) {
                throw new IOException();
            }
            catch (InvocationTargetException e) {
                throw new IOException();
            }
        }
        if (type == 2) {
            return new ScaledRAFileInJar(name);
        }
        if (type == 5) {
            ScaledRAFile ra = new ScaledRAFile(database, name, readonly, false);
            return ra;
        }
        if (type == 0) {
            return new ScaledRAFile(database, name, readonly, true);
        }
        File fi = new File(name);
        long length = fi.length();
        if (length > database.logger.propNioMaxSize) {
            return new ScaledRAFile(database, name, readonly, true);
        }
        try {
            Class.forName("java.nio.MappedByteBuffer");
            return new ScaledRAFileHybrid(database, name, readonly);
        }
        catch (Exception e) {
            return new ScaledRAFile(database, name, readonly, true);
        }
    }

    ScaledRAFile(Database database, String name, boolean readonly, boolean extendLengthToBlock) throws FileNotFoundException, IOException {
        this.database = database;
        this.fileName = name;
        this.readOnly = readonly;
        this.extendLength = extendLengthToBlock;
        String accessMode = readonly ? "r" : (this.extendLength ? "rw" : "rws");
        this.file = new RandomAccessFile(name, accessMode);
        this.buffer = new byte[4096];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.valueBuffer = new byte[8];
        this.vbao = new HsqlByteArrayOutputStream(this.valueBuffer);
        this.vbai = new HsqlByteArrayInputStream(this.valueBuffer);
        this.fileDescriptor = this.file.getFD();
        this.fileLength = this.length();
        this.readIntoBuffer();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long position) throws IOException {
        if (this.readOnly && this.fileLength < position) {
            throw new IOException("read beyond end of file");
        }
        this.seekPosition = position;
    }

    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long filePos = this.seekPosition & 0xFFFFFFFFFFFFF000L;
        long readLength = this.fileLength - filePos;
        if (readLength > (long)this.buffer.length) {
            readLength = this.buffer.length;
        }
        if (readLength < 0L) {
            throw new IOException("read beyond end of file");
        }
        try {
            this.file.seek(filePos);
            this.file.readFully(this.buffer, 0, (int)readLength);
            this.bufferOffset = filePos;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent(" " + filePos + " " + readLength, e);
            throw e;
        }
    }

    public int read() throws IOException {
        try {
            if (this.seekPosition >= this.fileLength) {
                return -1;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            int val = this.buffer[(int)(this.seekPosition - this.bufferOffset)] & 0xFF;
            ++this.seekPosition;
            return val;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("read failed", e);
            throw e;
        }
    }

    public long readLong() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 8);
        return this.vbai.readLong();
    }

    public int readInt() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 4);
        return this.vbai.readInt();
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            if (this.seekPosition + (long)length > this.fileLength) {
                throw new EOFException();
            }
            if (length > this.buffer.length && (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length)) {
                this.file.seek(this.seekPosition);
                this.file.readFully(b, offset, length);
                this.seekPosition += (long)length;
                return;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int bytesRead = this.ba.read(b, offset, length);
            this.seekPosition += (long)bytesRead;
            if (bytesRead < length) {
                this.file.seek(this.seekPosition);
                this.file.readFully(b, offset + bytesRead, length - bytesRead);
                this.seekPosition += (long)(length - bytesRead);
            }
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("faeild to read a byte array", e);
            throw e;
        }
    }

    public void write(byte[] b, int off, int length) throws IOException {
        try {
            this.file.seek(this.seekPosition);
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)length > this.bufferOffset) {
                this.writeToBuffer(b, off, length);
            }
            this.file.write(b, off, length);
            this.seekPosition += (long)length;
            if (!this.extendLength && this.fileLength < this.seekPosition) {
                this.fileLength = this.seekPosition;
            }
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write a byte array", e);
            throw e;
        }
    }

    public void writeInt(int i) throws IOException {
        this.vbao.reset();
        this.vbao.writeInt(i);
        this.write(this.valueBuffer, 0, 4);
    }

    public void writeLong(long i) throws IOException {
        this.vbao.reset();
        this.vbao.writeLong(i);
        this.write(this.valueBuffer, 0, 8);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return false;
    }

    public boolean ensureLength(long newLength) {
        if (newLength <= this.fileLength) {
            return true;
        }
        try {
            this.extendLength(newLength);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean setLength(long newLength) {
        try {
            this.file.setLength(newLength);
            this.file.seek(0L);
            this.fileLength = this.file.length();
            this.seekPosition = 0L;
            this.readIntoBuffer();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeToBuffer(byte[] b, int off, int len) throws IOException {
        int maxLength;
        int copyLength = len;
        int copyOffset = off;
        int bufferPos = (int)(this.seekPosition - this.bufferOffset);
        if (bufferPos < 0) {
            copyOffset -= bufferPos;
            copyLength += bufferPos;
            bufferPos = 0;
        }
        if ((maxLength = (int)(this.bufferOffset + (long)this.buffer.length - this.seekPosition)) < copyLength) {
            copyLength = maxLength;
        }
        System.arraycopy(b, copyOffset, this.buffer, bufferPos, copyLength);
    }

    private long getExtendLength(long position) {
        if (!this.extendLength) {
            return position;
        }
        int scaleUp = position < 262144L ? 2 : (position < 0x100000L ? 6 : (position < 0x1000000L ? 8 : 10));
        position = ScaledRAFile.getBinaryNormalisedCeiling(position, 12 + scaleUp);
        return position;
    }

    private void extendLength(long position) throws IOException {
        long newSize = this.getExtendLength(position);
        if (newSize > this.fileLength) {
            try {
                this.file.seek(newSize - 1L);
                this.file.write(0);
                this.fileLength = newSize;
            }
            catch (IOException e) {
                this.database.logger.logWarningEvent("data file enlarge failed ", e);
                throw e;
            }
        }
    }

    private void resetPointer() {
        try {
            this.seekPosition = 0L;
            this.fileLength = this.length();
            this.readIntoBuffer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static long getBinaryNormalisedCeiling(long value, int scale) {
        long mask = -1L << scale;
        long newSize = value & mask;
        if (newSize != value) {
            newSize += (long)(1 << scale);
        }
        return newSize;
    }
}

