/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLHybrid
extends RowStoreAVL
implements PersistentStore {
    DataFileCacheSession cache;
    private int maxMemoryRowCount;
    private boolean useDisk;
    boolean isCached;
    int rowIdSequence = 0;

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection manager, TableBase table, boolean diskBased) {
        this.session = session;
        this.manager = manager;
        this.table = table;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.useDisk = diskBased;
        if (this.maxMemoryRowCount == 0) {
            this.useDisk = false;
        }
        if (table.getTableType() == 9) {
            this.setTimestamp(session.getActionTimestamp());
        }
        this.resetAccessorKeys(table.getIndexList());
        manager.setStore(table, this);
    }

    RowStoreAVLHybrid(Session session, TableBase table) {
        this.session = session;
        this.table = table;
        this.useDisk = true;
        this.isCached = true;
        this.resetAccessorKeys(table.getIndexList());
    }

    public boolean isMemory() {
        return !this.isCached;
    }

    public void setMemory(boolean mode) {
        this.useDisk = !mode;
    }

    public synchronized int getAccessCount() {
        return this.isCached ? this.cache.getAccessCount() : 0;
    }

    public void set(CachedObject object) {
    }

    public CachedObject get(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException e) {
            return null;
        }
    }

    public CachedObject get(int i, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, keep);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException e) {
            return null;
        }
    }

    public CachedObject get(CachedObject object, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(object, (PersistentStore)this, keep);
            }
            return object;
        }
        catch (HsqlException e) {
            return null;
        }
    }

    public int getStorageSize(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false).getStorageSize();
            }
            return 0;
        }
        catch (HsqlException e) {
            return 0;
        }
    }

    public void add(CachedObject object) {
        if (this.isCached) {
            int size = object.getRealSize(this.cache.rowOut);
            size += this.indexList.length * 16;
            size = this.cache.rowOut.getStorageSize(size);
            object.setStorageSize(size);
            this.cache.add(object);
        }
    }

    public CachedObject get(RowInputInterface in) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this.table, in);
            }
        }
        catch (HsqlException e) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return null;
    }

    public CachedObject getNewInstance(int size) {
        return null;
    }

    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        if (!this.isCached && this.useDisk && this.elementCount >= this.maxMemoryRowCount) {
            this.changeToDiskTable(session);
        }
        if (this.isCached) {
            RowAVLDisk row = new RowAVLDisk(this.table, (Object[])object, this);
            this.add(row);
            if (tx) {
                RowAction.addInsertAction(session, (Table)this.table, row);
            }
            return row;
        }
        int id = this.rowIdSequence++;
        RowAVL row = new RowAVL(this.table, (Object[])object, id, this);
        if (tx) {
            RowAction action;
            row.rowAction = action = new RowAction(session, this.table, 1, row, null);
        }
        return row;
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int i) {
        if (this.isCached) {
            this.cache.remove(i, this);
        }
    }

    public void removePersistence(int i) {
    }

    public void release(int i) {
        if (this.isCached) {
            this.cache.release(i);
        }
    }

    public void commitPersistence(CachedObject row) {
    }

    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.remove(row.getPos());
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                this.remove(row.getPos());
            }
        }
    }

    public DataFileCache getCache() {
        return this.cache;
    }

    public void setCache(DataFileCache cache) {
        throw Error.runtimeError(201, "RowStoreAVLHybrid");
    }

    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        if (this.isCached) {
            this.cache.adjustStoreCount(-1);
            this.cache = null;
            this.isCached = false;
        }
        this.manager.setStore(this.table, null);
    }

    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    public void setAccessor(Index key, int accessor) {
    }

    public synchronized void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        super.resetAccessorKeys(keys);
    }

    public final void changeToDiskTable(Session session) {
        this.cache = ((PersistentStoreCollectionSession)this.manager).getResultCache();
        if (this.cache != null) {
            RowIterator iterator = this.table.rowIterator(this);
            ArrayUtil.fillArray(this.accessorList, null);
            this.elementCount = 0;
            this.isCached = true;
            this.cache.adjustStoreCount(1);
            while (iterator.hasNext()) {
                Row row = iterator.getNextRow();
                Row newRow = (Row)this.getNewCachedObject(session, row.getData(), false);
                this.indexRow(session, newRow);
                row.destroy();
            }
        }
        this.maxMemoryRowCount = Integer.MAX_VALUE;
    }
}

