/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLMemory;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.persist.RowStoreAVLHybrid;
import org.hsqldb.persist.RowStoreAVLHybridExtended;
import org.hsqldb.persist.RowStoreAVLMemory;
import org.hsqldb.persist.TextCache;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Logger {
    public SimpleLog appLog;
    public SimpleLog sqlLog;
    FrameworkLogger fwLogger;
    FrameworkLogger sqlLogger;
    private Database database;
    public boolean checkpointRequired;
    public boolean checkpointDue;
    public boolean checkpointDisabled;
    private boolean logsStatements;
    private boolean loggingEnabled;
    private boolean syncFile = false;
    boolean propIsFileDatabase;
    boolean propFilesReadOnly;
    boolean propDatabaseReadOnly;
    boolean propIncrementBackup;
    boolean propNioDataFile;
    long propNioMaxSize = 0x10000000L;
    int propMaxFreeBlocks = 512;
    int propCacheMaxRows;
    int propCacheMaxSize;
    int propCacheFileScale;
    int propCacheDefragLimit;
    String propTextSourceDefault = "";
    boolean propTextAllowFullPath;
    int propWriteDelay;
    int propLogSize;
    boolean propLogData = true;
    int propEventLogLevel;
    int propSqlLogLevel;
    int propGC;
    int propTxMode = 0;
    boolean propRefIntegrity = true;
    int propLobBlockSize = 32768;
    int propScriptFormat = 0;
    Log log;
    private LockFile lockFile;
    private Crypto crypto;
    public FileAccess fileAccess;
    public boolean isStoredFileAccess;
    String tempDirectoryPath;
    private HashMap textCacheList = new HashMap();
    public boolean isNewDatabase;
    public boolean isSingleFile;
    public static final String oldFileExtension = ".old";
    public static final String newFileExtension = ".new";
    public static final String appLogFileExtension = ".app.log";
    public static final String sqlLogFileExtension = ".sql.log";
    public static final String logFileExtension = ".log";
    public static final String scriptFileExtension = ".script";
    public static final String propertiesFileExtension = ".properties";
    public static final String dataFileExtension = ".data";
    public static final String backupFileExtension = ".backup";
    public static final String lobsFileExtension = ".lobs";
    public static final String lockFileExtension = ".lck";
    private static SimpleDateFormat backupFileFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static Character runtimeFileDelim = null;

    public Logger(Database database) {
        this.database = database;
    }

    public void openPersistence() {
        boolean version18;
        String fileaccess_class_name = this.database.getURLProperties().getProperty("fileaccess_class_name");
        boolean hasFileProps = false;
        boolean hasScript = false;
        if (fileaccess_class_name != null) {
            String storagekey = this.database.getURLProperties().getProperty("storage_key");
            try {
                Class<?> zclass = Class.forName(fileaccess_class_name);
                Constructor<?> constructor = zclass.getConstructor(Object.class);
                this.fileAccess = (FileAccess)constructor.newInstance(storagekey);
                this.isStoredFileAccess = true;
            }
            catch (ClassNotFoundException e) {
                System.out.println("ClassNotFoundException");
            }
            catch (InstantiationException e) {
                System.out.println("InstantiationException");
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException");
            }
            catch (Exception e) {
                System.out.println("Exception");
            }
        } else {
            this.fileAccess = FileUtil.getFileAccess(this.database.isFilesInJar());
        }
        this.propIsFileDatabase = DatabaseURL.isFileBasedDatabaseType(this.database.getType());
        this.database.databaseProperties = new HsqlDatabaseProperties(this.database);
        this.propTextAllowFullPath = this.database.databaseProperties.isPropertyTrue("textdb.allow_full_path");
        if (this.propIsFileDatabase) {
            boolean exists;
            hasFileProps = this.database.databaseProperties.load();
            hasScript = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension);
            if (this.database.databaseProperties.isVersion18()) {
                exists = hasFileProps;
            } else {
                exists = hasScript;
                if (!exists && (exists = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension + newFileExtension))) {
                    this.database.databaseProperties.setDBModified(2);
                }
            }
            this.isNewDatabase = !exists;
        } else {
            this.isNewDatabase = true;
        }
        if (this.isNewDatabase) {
            String name = this.newUniqueName();
            this.database.setUniqueName(name);
            boolean checkExists = this.database.isFilesInJar();
            if (checkExists |= this.database.urlProperties.isPropertyTrue("ifexists") || !this.database.urlProperties.isPropertyTrue("create", true)) {
                throw Error.error(465, this.database.getPath());
            }
            this.database.databaseProperties.setURLProperties(this.database.urlProperties);
        } else {
            int value;
            if (!hasFileProps) {
                this.database.databaseProperties.setDBModified(1);
            }
            if (this.database.urlProperties.isPropertyTrue("files_readonly")) {
                this.database.databaseProperties.setProperty("files_readonly", true);
            }
            if (this.database.urlProperties.isPropertyTrue("readonly")) {
                this.database.databaseProperties.setProperty("readonly", true);
            }
            if (!this.database.urlProperties.isPropertyTrue("hsqldb.lock_file", true)) {
                this.database.databaseProperties.setProperty("hsqldb.lock_file", false);
            }
            if ((value = this.database.urlProperties.getIntegerProperty("hsqldb.applog", -1)) >= 0) {
                this.database.databaseProperties.setProperty("hsqldb.applog", value);
            }
            if ((value = this.database.urlProperties.getIntegerProperty("hsqldb.sqllog", -1)) >= 0) {
                this.database.databaseProperties.setProperty("hsqldb.sqllog", value);
            }
            if ((value = this.database.urlProperties.getIntegerProperty("hsqldb.cache_free_count", -1)) >= 0) {
                this.database.databaseProperties.setProperty("hsqldb.cache_free_count", ArrayUtil.getTwoPowerFloor(value));
            }
        }
        this.setVariables();
        String appLogPath = null;
        String sqlLogPath = null;
        if (this.propIsFileDatabase && !this.database.isFilesReadOnly()) {
            appLogPath = this.database.getPath() + appLogFileExtension;
            sqlLogPath = this.database.getPath() + sqlLogFileExtension;
        }
        this.appLog = new SimpleLog(appLogPath, this.propEventLogLevel);
        this.sqlLog = new SimpleLog(sqlLogPath, this.propSqlLogLevel);
        this.database.setReferentialIntegrity(this.propRefIntegrity);
        if (!this.isFileDatabase()) {
            return;
        }
        this.checkpointRequired = false;
        this.logsStatements = false;
        boolean useLock = this.database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (useLock && !this.database.isFilesReadOnly()) {
            this.acquireLock(this.database.getPath());
        }
        if (version18 = this.database.databaseProperties.isVersion18()) {
            this.database.setUniqueName(this.newUniqueName());
            if (!hasScript) {
                this.database.schemaManager.createPublicSchema();
            }
        }
        this.log = new Log(this.database);
        this.log.open();
        this.logsStatements = true;
        boolean bl = this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        if (version18) {
            HsqlNameManager.HsqlName name = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
            if (name != null) {
                this.database.schemaManager.setDefaultSchemaHsqlName(name);
            }
            this.checkpoint(false);
        }
        if (this.database.getUniqueName() == null) {
            this.database.setUniqueName(this.newUniqueName());
        }
    }

    private void setVariables() {
        String txMode;
        String tableType;
        String cryptKey = this.database.urlProperties.getProperty("crypt_key");
        if (cryptKey != null) {
            String cryptType = this.database.urlProperties.getProperty("crypt_type");
            String cryptProvider = this.database.urlProperties.getProperty("crypt_provider");
            this.crypto = new Crypto(cryptKey, cryptType, cryptProvider);
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (!this.database.isFilesReadOnly()) {
            this.tempDirectoryPath = this.database.getType() == "mem:" || this.isStoredFileAccess ? this.database.getProperties().getStringProperty("hsqldb.temp_directory") : this.database.getPath() + ".tmp";
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        this.propScriptFormat = this.database.databaseProperties.getIntegerProperty("hsqldb.script_format");
        boolean version18 = this.database.databaseProperties.isVersion18();
        this.propMaxFreeBlocks = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_free_count");
        this.propMaxFreeBlocks = ArrayUtil.getTwoPowerFloor(this.propMaxFreeBlocks);
        if (!this.isNewDatabase && !version18) {
            return;
        }
        if (this.tempDirectoryPath != null) {
            int rows = this.database.databaseProperties.getIntegerProperty("hsqldb.result_max_memory_rows");
            this.database.setResultMaxMemoryRows(rows);
        }
        if ("CACHED".equalsIgnoreCase(tableType = this.database.databaseProperties.getStringProperty("hsqldb.default_table_type"))) {
            this.database.schemaManager.setDefaultTableType(5);
        }
        if ("MVCC".equalsIgnoreCase(txMode = this.database.databaseProperties.getStringProperty("hsqldb.tx"))) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                break;
            }
            case 1: {
                this.database.txManager = new TransactionManagerMV2PL(this.database);
                break;
            }
            case 2: {
                this.database.txManager = new TransactionManagerMVCC(this.database);
            }
        }
        String txLevel = this.database.databaseProperties.getStringProperty("hsqldb.tx_level");
        this.database.defaultIsolationLevel = "SERIALIZABLE".equalsIgnoreCase(txLevel) ? 8 : 2;
        this.database.defaultDeadlockRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_deadlock_rollback");
        this.database.sqlEnforceNames = this.database.databaseProperties.isPropertyTrue("sql.enforce_names");
        this.database.sqlEnforceRefs = this.database.databaseProperties.isPropertyTrue("sql.enforce_refs");
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceTypes = this.database.databaseProperties.isPropertyTrue("sql.enforce_types");
        this.database.sqlEnforceTDCD = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_delete");
        this.database.sqlEnforceTDCU = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_update");
        this.database.sqlTranslateTTI = this.database.databaseProperties.isPropertyTrue("jdbc.translate_tti_types");
        this.database.sqlConcatNulls = this.database.databaseProperties.isPropertyTrue("sql.concat_nulls");
        this.database.sqlUniqueNulls = this.database.databaseProperties.isPropertyTrue("sql.unique_nulls");
        this.database.sqlConvertTruncate = this.database.databaseProperties.isPropertyTrue("sql.convert_trunc");
        this.database.sqlDoubleNaN = this.database.databaseProperties.isPropertyTrue("sql.double_nan");
        this.database.sqlLongvarIsLob = this.database.databaseProperties.isPropertyTrue("sql.longvar_is_lob");
        this.database.sqlSyntaxMss = this.database.databaseProperties.isPropertyTrue("sql.syntax_mss");
        this.database.sqlSyntaxMys = this.database.databaseProperties.isPropertyTrue("sql.syntax_mys");
        this.database.sqlSyntaxOra = this.database.databaseProperties.isPropertyTrue("sql.syntax_ora");
        this.database.sqlSyntaxPgs = this.database.databaseProperties.isPropertyTrue("sql.syntax_pgs");
        if (this.database.databaseProperties.isPropertyTrue("sql.compare_in_locale")) {
            this.database.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.applog");
        this.propSqlLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.sqllog");
        this.propFilesReadOnly = this.database.databaseProperties.isPropertyTrue("files_readonly");
        this.propDatabaseReadOnly = this.database.databaseProperties.isPropertyTrue("readonly");
        this.propIncrementBackup = this.database.databaseProperties.isPropertyTrue("hsqldb.inc_backup");
        this.propNioDataFile = this.database.databaseProperties.isPropertyTrue("hsqldb.nio_data_file");
        this.propNioMaxSize = (long)(this.database.databaseProperties.getIntegerProperty("hsqldb.nio_max_size") * 1024) * 1024L;
        this.propCacheMaxRows = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_rows");
        this.propCacheMaxSize = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_size") * 1024;
        this.setLobFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.lob_file_scale"));
        this.setCacheFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.cache_file_scale"));
        this.propCacheDefragLimit = this.database.databaseProperties.getIntegerProperty("hsqldb.defrag_limit");
        this.propWriteDelay = this.database.databaseProperties.getIntegerProperty("hsqldb.write_delay_millis");
        if (!this.database.databaseProperties.isPropertyTrue("hsqldb.write_delay")) {
            this.propWriteDelay = 0;
        }
        this.propLogSize = this.database.databaseProperties.getIntegerProperty("hsqldb.log_size");
        this.propLogData = this.database.databaseProperties.isPropertyTrue("hsqldb.log_data");
        this.propGC = this.database.databaseProperties.getIntegerProperty("runtime.gc_interval");
        this.propRefIntegrity = this.database.databaseProperties.isPropertyTrue("sql.ref_integrity");
    }

    public boolean closePersistence(int closemode) {
        if (this.log == null) {
            this.closeAllTextCaches(false);
            return true;
        }
        this.database.lobManager.deleteUnusedLobs();
        try {
            switch (closemode) {
                case 1: {
                    this.log.shutdown();
                    break;
                }
                case 2: {
                    this.log.close(false);
                    break;
                }
                case 3: 
                case 4: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("error closing log", e);
            this.log = null;
            return false;
        }
        this.database.logger.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        this.logsStatements = false;
        this.loggingEnabled = false;
        return true;
    }

    String newUniqueName() {
        String name = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        name = "HSQLDB" + name.substring(6).toUpperCase(Locale.ENGLISH);
        return name;
    }

    public boolean isLogged() {
        return this.propIsFileDatabase && !this.database.isFilesReadOnly();
    }

    public boolean isAllowedFullPath() {
        return this.propTextAllowFullPath;
    }

    private void getEventLogger() {
        if (this.fwLogger != null) {
            return;
        }
        String name = this.database.getUniqueName();
        if (name == null) {
            return;
        }
        this.fwLogger = FrameworkLogger.getLog("ENGINE", "hsqldb.db." + this.database.getUniqueName());
    }

    public void setEventLogLevel(int level, boolean sqlLog) {
        if (level < 0 || level > 3) {
            throw Error.error(5556);
        }
        if (sqlLog) {
            this.propSqlLogLevel = level;
            this.sqlLog.setLevel(level);
        } else {
            this.propEventLogLevel = level;
            this.appLog.setLevel(level);
        }
    }

    public void logSevereEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.severe(message, t);
        }
        if (this.appLog != null) {
            if (t == null) {
                this.appLog.logContext(1, message);
            } else {
                this.appLog.logContext(t, message, 1);
            }
        }
    }

    public void logWarningEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.warning(message, t);
        }
        this.appLog.logContext(t, message, 1);
    }

    public void logInfoEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.info(message);
        }
        this.appLog.logContext(2, message);
    }

    public void logDetailEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.finest(message);
        }
        if (this.appLog != null) {
            this.appLog.logContext(3, message);
        }
    }

    public void logStatementEvent(Session session, Statement statement, Object[] paramValues, int level) {
        this.getEventLogger();
        if (this.sqlLogger != null) {
            this.sqlLogger.finest(statement.getSQL());
        }
        if (this.sqlLog != null && level <= this.propSqlLogLevel) {
            String sessionId = Long.toString(session.getId());
            String sql = statement.getSQL();
            String values = "";
            if (sql.length() > 100) {
                sql.substring(0, 100);
            }
            if (level == 3 && paramValues != null && paramValues.length > 0) {
                values = RowType.convertToSQLString(paramValues, statement.getParametersMetaData().getParameterTypes(), 32);
            }
            this.sqlLog.logContext(3, sessionId, sql, values);
        }
    }

    public int getSqlEventLogLevel() {
        return this.propSqlLogLevel;
    }

    private DataFileCache getCache() {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    private boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void writeStartSession(Session session) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, session.getUser().getConnectUserSQL());
        }
    }

    public synchronized void writeOtherStatement(Session session, String statement) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, statement);
        }
    }

    public synchronized void writeInsertStatement(Session session, Row row, Table table) {
        if (this.loggingEnabled) {
            this.log.writeInsertStatement(session, row, table);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table t, Object[] row) {
        if (this.loggingEnabled) {
            this.log.writeDeleteStatement(session, t, row);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence s) {
        if (this.loggingEnabled) {
            this.log.writeSequenceStatement(session, s);
        }
    }

    public synchronized void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeCommitStatement(session);
        }
    }

    public synchronized void writeRollbackStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, "ROLLBACK");
        }
    }

    public synchronized void checkpoint(boolean mode) {
        if (this.logsStatements) {
            this.database.logger.logInfoEvent("Checkpoint start");
            this.database.lobManager.synch();
            this.log.checkpoint(mode);
            this.database.sessionManager.resetLoggedSchemas();
            this.database.logger.logInfoEvent("Checkpoint end");
        } else if (!this.isFileDatabase()) {
            this.database.lobManager.deleteUnusedLobs();
        }
        this.checkpointRequired = false;
        this.checkpointDue = false;
    }

    public synchronized void setLogSize(int megas) {
        this.propLogSize = megas;
        if (this.log != null) {
            this.log.setLogSize(this.propLogSize);
        }
    }

    public synchronized void setLogData(boolean mode) {
        this.propLogData = mode;
        this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        this.loggingEnabled &= this.logsStatements;
    }

    public synchronized void setScriptType(int format) {
        if (format == this.propScriptFormat) {
            return;
        }
        this.propScriptFormat = format;
        this.checkpointRequired = true;
    }

    public synchronized void setWriteDelay(int delay) {
        this.propWriteDelay = delay;
        if (this.log != null) {
            this.syncFile = delay == 0;
            this.log.setWriteDelay(delay);
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLogSize() {
        return this.propLogSize;
    }

    public int getLobBlockSize() {
        return this.propLobBlockSize;
    }

    public synchronized void setIncrementBackup(boolean val) {
        if (val == this.propIncrementBackup) {
            return;
        }
        if (this.log != null) {
            this.log.setIncrementBackup(val);
            if (this.log.hasCache()) {
                this.checkpointRequired = true;
            }
        }
        this.propIncrementBackup = val;
    }

    public void setCacheMaxRows(int value) {
        this.propCacheMaxRows = value;
    }

    public int getCacheRowsDefault() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int value) {
        this.propCacheMaxSize = value * 1024;
    }

    public int getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setCacheFileScale(int value) {
        if (this.propCacheFileScale == value) {
            return;
        }
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        if (this.hasCache()) {
            throw Error.error(469);
        }
        this.propCacheFileScale = value;
    }

    public void setCacheFileScaleNoCheck(int value) {
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        this.propCacheFileScale = value;
    }

    public int getCacheFileScale() {
        return this.propCacheFileScale;
    }

    public void setLobFileScale(int value) {
        if (this.propLobBlockSize == value * 1024) {
            return;
        }
        Logger.checkPower(value, 5);
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propLobBlockSize = value * 1024;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileScaleNoCheck(int value) {
        Logger.checkPower(value, 5);
        this.propLobBlockSize = value * 1024;
    }

    public int getLobFileScale() {
        return this.propLobBlockSize / 1024;
    }

    public void setDefagLimit(int value) {
        this.propCacheDefragLimit = value;
    }

    public int getDefragLimit() {
        return this.propCacheDefragLimit;
    }

    public void setDefaultTextTableProperties(String source, HsqlProperties props) {
        props.setProperty("check_props", true);
        this.database.getProperties().setURLProperties(props);
        this.propTextSourceDefault = source;
    }

    public void setNioDataFile(boolean value) {
        this.propNioDataFile = value;
    }

    public void setNioMaxSize(int value) {
        Logger.checkPower(value, 11);
        if (value < 8) {
            throw Error.error(5556);
        }
        this.propNioMaxSize = (long)value * 1024L * 1024L;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    public boolean isFileDatabase() {
        return this.propIsFileDatabase;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    static void checkPower(int n, int max) {
        if (!ArrayUtil.isTwoPower(n, max)) {
            throw Error.error(5556);
        }
    }

    public synchronized void setCheckpointRequired() {
        this.checkpointRequired = true;
    }

    public synchronized boolean needsCheckpointReset() {
        if (this.checkpointRequired && !this.checkpointDue && !this.checkpointDisabled) {
            this.checkpointDue = true;
            this.checkpointRequired = false;
            return true;
        }
        return false;
    }

    public boolean hasLockFile() {
        return this.lockFile != null;
    }

    public void acquireLock(String path) {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(path);
    }

    public void releaseLock() {
        try {
            if (this.lockFile != null) {
                this.lockFile.tryRelease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockFile = null;
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection collection, TableBase table) {
        switch (table.getTableType()) {
            case 5: {
                DataFileCache cache = this.getCache();
                if (cache == null) break;
                return new RowStoreAVLDisk(collection, cache, (Table)table);
            }
            case 4: 
            case 11: 
            case 12: {
                return new RowStoreAVLMemory(collection, (Table)table);
            }
            case 7: {
                return new RowStoreAVLDiskData(collection, (Table)table);
            }
            case 1: {
                return new RowStoreAVLHybridExtended(session, collection, table, false);
            }
            case 3: {
                return new RowStoreAVLHybridExtended(session, collection, table, true);
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                if (session == null) {
                    return null;
                }
                return new RowStoreAVLHybrid(session, collection, table, true);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        switch (table.getTableType()) {
            case 1: 
            case 4: 
            case 12: {
                return new IndexAVLMemory(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new IndexAVL(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(Table table, Index index, int[] columns) {
        boolean[] modeFlags = new boolean[columns.length];
        Object[] colTypes = new Type[columns.length];
        ArrayUtil.projectRow(table.getColumnTypes(), columns, colTypes);
        switch (table.getTableType()) {
            case 4: {
                return new IndexAVLMemory(index.getName(), index.getPersistenceId(), table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, false, false);
            }
            case 5: 
            case 7: {
                return new IndexAVL(index.getName(), index.getPersistenceId(), table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, false, false);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public String getValueStringForProperty(String name) {
        String value = "";
        if ("hsqldb.tx".equals(name)) {
            switch (this.database.txManager.getTransactionControl()) {
                case 2: {
                    value = "MVCC".toLowerCase();
                    break;
                }
                case 1: {
                    value = "MVLOCKS".toLowerCase();
                    break;
                }
                case 0: {
                    value = "LOCKS".toLowerCase();
                }
            }
            return value;
        }
        if ("hsqldb.tx_level".equals(name)) {
            switch (this.database.defaultIsolationLevel) {
                case 2: {
                    value = new StringBuffer("READ").append(' ').append("COMMITTED").toString().toLowerCase();
                    break;
                }
                case 8: {
                    value = "SERIALIZABLE".toLowerCase();
                }
            }
            return value;
        }
        if ("hsqldb.applog".equals(name)) {
            return String.valueOf(this.appLog.getLevel());
        }
        if ("hsqldb.lob_file_scale".equals(name)) {
            return String.valueOf(this.propLobBlockSize);
        }
        if ("hsqldb.cache_file_scale".equals(name)) {
            return String.valueOf(this.propCacheFileScale);
        }
        if ("hsqldb.cache_free_count".equals(name)) {
            return String.valueOf(this.propMaxFreeBlocks);
        }
        if ("hsqldb.cache_rows".equals(name)) {
            return String.valueOf(this.propCacheMaxRows);
        }
        if ("hsqldb.cache_size".equals(name)) {
            String.valueOf(this.propCacheMaxSize);
        }
        if ("hsqldb.default_table_type".equals(name)) {
            return this.database.schemaManager.getDefaultTableType() == 5 ? "cached" : "memory";
        }
        if ("hsqldb.defrag_limit".equals(name)) {
            return String.valueOf(this.propCacheDefragLimit);
        }
        if ("files_readonly".equals(name)) {
            return this.database.databaseProperties.getPropertyString("files_readonly");
        }
        if ("hsqldb.lock_file".equals(name)) {
            return this.database.databaseProperties.getPropertyString("hsqldb.lock_file");
        }
        if ("hsqldb.log_data".equals(name)) {
            return String.valueOf(this.propLogData);
        }
        if ("hsqldb.log_size".equals(name)) {
            return String.valueOf(this.propLogSize);
        }
        if ("hsqldb.nio_data_file".equals(name)) {
            return String.valueOf(this.propNioDataFile);
        }
        if ("hsqldb.nio_max_size".equals(name)) {
            return String.valueOf(this.propNioMaxSize);
        }
        if ("hsqldb.script_format".equals(name)) {
            return ScriptWriterBase.LIST_SCRIPT_FORMATS[0].toLowerCase();
        }
        if ("hsqldb.temp_directory".equals(name)) {
            return null;
        }
        if ("hsqldb.result_max_memory_rows".equals(name)) {
            return String.valueOf(this.database.getResultMaxMemoryRows());
        }
        if ("hsqldb.write_delay".equals(name)) {
            return String.valueOf(this.propWriteDelay != 0);
        }
        if ("hsqldb.write_delay_millis".equals(name)) {
            return String.valueOf(this.propWriteDelay);
        }
        if ("sql.ref_integrity".equals(name)) {
            return this.database.isReferentialIntegrity() ? "true" : "false";
        }
        if ("sql.compare_in_locale".equals(name)) {
            return null;
        }
        if ("sql.enforce_size".equals(name)) {
            return String.valueOf(this.database.sqlEnforceSize);
        }
        if ("sql.enforce_refs".equals(name)) {
            return String.valueOf(this.database.sqlEnforceRefs);
        }
        if ("sql.enforce_names".equals(name)) {
            return String.valueOf(this.database.sqlEnforceNames);
        }
        if ("sql.enforce_types".equals(name)) {
            return String.valueOf(this.database.sqlEnforceTypes);
        }
        if ("jdbc.translate_tti_types".equals(name)) {
            return String.valueOf(this.database.sqlTranslateTTI);
        }
        if ("sql.longvar_is_lob".equals(name)) {
            return String.valueOf(this.database.sqlLongvarIsLob);
        }
        return null;
    }

    public String[] getPropertiesSQL() {
        int delay;
        boolean millis;
        HsqlArrayList list = new HsqlArrayList();
        StringBuffer sb = new StringBuffer();
        sb.append("SET DATABASE ").append("UNIQUE").append(' ');
        sb.append("NAME").append(' ').append(this.database.getUniqueName());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("GC").append(' ');
        sb.append(this.propGC);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("RESULT").append(' ').append("MEMORY");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.database.getResultMaxMemoryRows());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("EVENT").append(' ');
        sb.append("LOG").append(' ').append("LEVEL");
        sb.append(' ').append(this.propEventLogLevel);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("NAMES").append(' ');
        sb.append(this.database.sqlEnforceNames ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("REFERENCES").append(' ');
        sb.append(this.database.sqlEnforceRefs ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("SIZE").append(' ');
        sb.append(this.database.sqlEnforceSize ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TYPES").append(' ');
        sb.append(this.database.sqlEnforceTypes ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TDC").append(' ');
        sb.append("DELETE").append(' ');
        sb.append(this.database.sqlEnforceTDCD ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TDC").append(' ');
        sb.append("UPDATE").append(' ');
        sb.append(this.database.sqlEnforceTDCU ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TRANSLATE").append(' ').append("TTI");
        sb.append(' ').append("TYPES").append(' ');
        sb.append(this.database.sqlTranslateTTI ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("CONCAT").append(' ');
        sb.append("NULLS").append(' ');
        sb.append(this.database.sqlConcatNulls ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("UNIQUE").append(' ');
        sb.append("NULLS").append(' ');
        sb.append(this.database.sqlUniqueNulls ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("CONVERT").append(' ');
        sb.append("TRUNCATE").append(' ');
        sb.append(this.database.sqlConvertTruncate ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("DOUBLE").append(' ');
        sb.append("NAN").append(' ');
        sb.append(this.database.sqlDoubleNaN ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("LONGVAR").append(' ');
        sb.append("IS").append(' ');
        sb.append("LOB").append(' ');
        sb.append(this.database.sqlLongvarIsLob ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        if (this.database.sqlSyntaxMss) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("MSS").append(' ');
            sb.append(this.database.sqlSyntaxMss ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxOra) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("ORA").append(' ');
            sb.append(this.database.sqlSyntaxOra ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxMys) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("MYS").append(' ');
            sb.append(this.database.sqlSyntaxMys ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxPgs) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("PGS").append(' ');
            sb.append(this.database.sqlSyntaxPgs ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("TRANSACTION");
        sb.append(' ').append("CONTROL").append(' ');
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                sb.append("MVCC");
                break;
            }
            case 1: {
                sb.append("MVLOCKS");
                break;
            }
            case 0: {
                sb.append("LOCKS");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("ISOLATION").append(' ').append("LEVEL");
        sb.append(' ');
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                sb.append("READ").append(' ').append("COMMITTED");
                break;
            }
            case 8: {
                sb.append("SERIALIZABLE");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("TRANSACTION");
        sb.append(' ').append("ROLLBACK").append(' ');
        sb.append("ON").append(' ');
        sb.append("DEADLOCK").append(' ');
        sb.append(this.database.defaultDeadlockRollback ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("TEXT").append(' ');
        sb.append("TABLE").append(' ').append("DEFAULTS");
        sb.append(' ').append('\'');
        sb.append(this.propTextSourceDefault).append('\'');
        list.add(sb.toString());
        sb.setLength(0);
        if (this.database.schemaManager.getDefaultTableType() == 5) {
            list.add("SET DATABASE DEFAULT TABLE TYPE CACHED");
        }
        boolean bl = millis = (delay = this.propWriteDelay) > 0 && delay < 1000;
        if (millis) {
            if (delay < 20) {
                delay = 20;
            }
        } else {
            delay /= 1000;
        }
        sb.setLength(0);
        sb.append("SET FILES ").append("WRITE").append(' ');
        sb.append("DELAY").append(' ').append(delay);
        if (millis) {
            sb.append(' ').append("MILLIS");
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("BACKUP");
        sb.append(' ').append("INCREMENT").append(' ');
        sb.append(this.propIncrementBackup ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CACHE");
        sb.append(' ').append("SIZE").append(' ');
        sb.append(this.propCacheMaxSize / 1024);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CACHE");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.propCacheMaxRows);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("SCALE");
        sb.append(' ').append(this.propCacheFileScale);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOB").append(' ').append("SCALE");
        sb.append(' ').append(this.getLobFileScale());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("DEFRAG");
        sb.append(' ').append(this.propCacheDefragLimit);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("NIO");
        sb.append(' ').append(this.propNioDataFile ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("NIO").append(' ').append("SIZE");
        sb.append(' ').append(this.propNioMaxSize / 0x100000L);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOG").append(' ');
        sb.append(this.propLogData ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOG").append(' ');
        sb.append("SIZE").append(' ').append(this.propLogSize);
        list.add(sb.toString());
        sb.setLength(0);
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public synchronized void backup(String destPath, boolean script, boolean blocking, boolean compressed) {
        boolean nameImpliesCompress;
        String dbPath = this.database.getPath();
        if (runtimeFileDelim == null) {
            runtimeFileDelim = new Character(System.getProperty("file.separator").charAt(0));
        }
        String instanceName = new File(dbPath).getName();
        if (destPath == null || destPath.length() < 1) {
            throw Error.error(3414, "0-length destination path");
        }
        char lastChar = destPath.charAt(destPath.length() - 1);
        boolean generateName = lastChar == '/' || lastChar == runtimeFileDelim.charValue();
        String defaultCompressionSuffix = compressed ? ".tar.gz" : ".tar";
        File archiveFile = generateName ? new File(destPath.substring(0, destPath.length() - 1), instanceName + '-' + backupFileFormat.format(new Date()) + defaultCompressionSuffix) : new File(destPath);
        boolean bl = nameImpliesCompress = archiveFile.getName().endsWith(".tar.gz") || archiveFile.getName().endsWith(".tgz");
        if (!nameImpliesCompress && !archiveFile.getName().endsWith(".tar")) {
            throw Error.error(null, 462, 0, new String[]{archiveFile.getName(), ".tar, .tar.gz, .tgz"});
        }
        if (compressed != nameImpliesCompress) {
            throw Error.error(null, 463, 0, new Object[]{new Boolean(compressed), archiveFile.getName()});
        }
        this.log.checkpointClose();
        try {
            try {
                this.database.logger.logInfoEvent("Initiating backup of instance '" + instanceName + "'");
                DbBackup backup = new DbBackup(archiveFile, dbPath);
                backup.setAbortUponModify(false);
                backup.write();
                this.database.logger.logInfoEvent("Successfully backed up instance '" + instanceName + "' to '" + destPath + "'");
            }
            catch (IllegalArgumentException iae) {
                throw Error.error(6609, iae.toString());
            }
            catch (IOException ioe) {
                throw Error.error(452, ioe.toString());
            }
            catch (TarMalformatException tme) {
                throw Error.error(452, tme.toString());
            }
            Object var14_16 = null;
            this.log.checkpointReopen();
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.log.checkpointReopen();
            throw throwable;
        }
    }

    public String getSecurePath(String path) {
        if (this.database.getType() == "res:") {
            return path;
        }
        if (!this.database.logger.propTextAllowFullPath) {
            if (path.indexOf("..") != -1) {
                return null;
            }
            String fullPath = new File(new File(this.database.getPath() + propertiesFileExtension).getAbsolutePath()).getParent();
            if (fullPath != null) {
                path = fullPath + File.separator + path;
            }
        }
        return path;
    }

    public DataFileCache openTextFilePersistence(Table table, String source, boolean readOnlyData, boolean reversed) {
        this.closeTextCache(table);
        source = this.getSecurePath(source);
        if (source == null) {
            throw Error.error(457, source);
        }
        TextCache c = new TextCache(table, source);
        c.open(readOnlyData || this.database.isFilesReadOnly());
        this.textCacheList.put(table.getName(), c);
        return c;
    }

    public void closeTextCache(Table table) {
        TextCache c = (TextCache)this.textCacheList.remove(table.getName());
        if (c != null) {
            try {
                c.close(true);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    void closeAllTextCaches(boolean script) {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            TextCache textCache = (TextCache)it.next();
            if (script && !textCache.table.isDataReadOnly()) {
                textCache.purge();
                continue;
            }
            textCache.close(true);
        }
    }

    boolean isAnyTextCacheModified() {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            if (!((TextCache)it.next()).isFileModified()) continue;
            return true;
        }
        return false;
    }
}

