/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.LobStore;

public class LobStoreMem
implements LobStore {
    final int lobBlockSize;
    int blocksInLargeBlock = 128;
    int largeBlockSize;
    HsqlArrayList byteStoreList;

    public LobStoreMem(int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.largeBlockSize = lobBlockSize * this.blocksInLargeBlock;
        this.byteStoreList = new HsqlArrayList();
    }

    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        byte[] dataBytes = new byte[blockCount * this.lobBlockSize];
        int dataBlockOffset = 0;
        while (blockCount > 0) {
            int largeBlockIndex = blockAddress / this.blocksInLargeBlock;
            byte[] largeBlock = (byte[])this.byteStoreList.get(largeBlockIndex);
            int blockOffset = blockAddress % this.blocksInLargeBlock;
            int currentBlockCount = blockCount;
            if (blockOffset + currentBlockCount > this.blocksInLargeBlock) {
                currentBlockCount = this.blocksInLargeBlock - blockOffset;
            }
            System.arraycopy(largeBlock, blockOffset * this.lobBlockSize, dataBytes, dataBlockOffset * this.lobBlockSize, currentBlockCount * this.lobBlockSize);
            blockAddress += currentBlockCount;
            dataBlockOffset += currentBlockCount;
            blockCount -= currentBlockCount;
        }
        return dataBytes;
    }

    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
        int dataBlockOffset = 0;
        while (blockCount > 0) {
            int largeBlockIndex = blockAddress / this.blocksInLargeBlock;
            int largeBlockLimit = (blockAddress + blockCount) / this.blocksInLargeBlock;
            if ((blockAddress + blockCount) % this.blocksInLargeBlock != 0) {
                ++largeBlockLimit;
            }
            if (largeBlockIndex >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] largeBlock = (byte[])this.byteStoreList.get(largeBlockIndex);
            int blockOffset = blockAddress % this.blocksInLargeBlock;
            int currentBlockCount = blockCount;
            if (blockOffset + currentBlockCount > this.blocksInLargeBlock) {
                currentBlockCount = this.blocksInLargeBlock - blockOffset;
            }
            System.arraycopy(dataBytes, dataBlockOffset * this.lobBlockSize, largeBlock, blockOffset * this.lobBlockSize, currentBlockCount * this.lobBlockSize);
            blockAddress += currentBlockCount;
            dataBlockOffset += currentBlockCount;
            blockCount -= currentBlockCount;
        }
    }

    public int getBlockSize() {
        return this.lobBlockSize;
    }

    public void close() {
        this.byteStoreList.clear();
    }

    public void synch() {
    }
}

