/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIFData
extends HashMap<String, String> {
    static final long serialVersionUID = 3086795680582315773L;
    private static Pattern pifRecordPattern = Pattern.compile("\\d+ +([^=]+)=(.*)");
    private Long sizeObject = null;

    public Long getSize() {
        return this.sizeObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIFData(InputStream stream) throws TarMalformatException, IOException {
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            int lineNum = 0;
            while ((s = br.readLine()) != null) {
                ++lineNum;
                Matcher m = pifRecordPattern.matcher(s);
                if (!m.matches()) {
                    throw new TarMalformatException(RB.pif_malformat.getString(lineNum, s));
                }
                String k = m.group(1);
                String v = m.group(2);
                if (v == null || v.length() < 1) {
                    this.remove(k);
                    continue;
                }
                this.put(k, v);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                stream.close();
                Object var11_13 = null;
                br = null;
            }
            catch (Throwable throwable2) {
                Object var11_14 = null;
                br = null;
                throw throwable2;
            }
            throw throwable;
        }
        try {
            stream.close();
            Object var11_11 = null;
            br = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            br = null;
            throw throwable;
        }
        String sizeString = (String)this.get("size");
        if (sizeString != null) {
            try {
                this.sizeObject = Long.valueOf(sizeString);
            }
            catch (NumberFormatException nfe) {
                throw new TarMalformatException(RB.pif_malformat_size.getString(sizeString));
            }
        }
    }
}

