/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.lib.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean noopMode;

    public static String report() {
        return loggerInstances.size() + " logger instances:  " + loggerInstances.keySet();
    }

    public static synchronized void clearLoggers(String prefixToZap) {
        HashSet<String> targetKeys = new HashSet<String>();
        Iterator it = loggerInstances.keySet().iterator();
        String dottedPrefix = prefixToZap + '.';
        while (it.hasNext()) {
            String k = (String)it.next();
            if (!k.equals(prefixToZap) && !k.startsWith(dottedPrefix)) continue;
            targetKeys.add(k);
        }
        loggerInstances.keySet().removeAll(targetKeys);
    }

    static void reconfigure() {
        noopMode = false;
        Class<?> log4jLoggerClass = null;
        loggerInstances.clear();
        log4jLoggerClass = null;
        log4jGetLogger = null;
        log4jLogMethod = null;
        try {
            log4jLoggerClass = Class.forName("org.apache.log4j.Logger");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (log4jLoggerClass != null) {
            try {
                if (jdkToLog4jLevels.size() < 1) {
                    Method log4jToLevel = Class.forName("org.apache.log4j.Level").getMethod("toLevel", String.class);
                    jdkToLog4jLevels.put(Level.ALL, log4jToLevel.invoke(null, "ALL"));
                    jdkToLog4jLevels.put(Level.FINER, log4jToLevel.invoke(null, "DEBUG"));
                    jdkToLog4jLevels.put(Level.WARNING, log4jToLevel.invoke(null, "ERROR"));
                    jdkToLog4jLevels.put(Level.SEVERE, log4jToLevel.invoke(null, "FATAL"));
                    jdkToLog4jLevels.put(Level.INFO, log4jToLevel.invoke(null, "INFO"));
                    jdkToLog4jLevels.put(Level.OFF, log4jToLevel.invoke(null, "OFF"));
                    jdkToLog4jLevels.put(Level.FINEST, log4jToLevel.invoke(null, "TRACE"));
                    jdkToLog4jLevels.put(Level.WARNING, log4jToLevel.invoke(null, "WARN"));
                }
                log4jLogMethod = log4jLoggerClass.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = log4jLoggerClass.getMethod("getLogger", String.class);
                return;
            }
            catch (Exception e) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j system: " + e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        log4jLoggerClass = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        String propVal = System.getProperty("hsqldb.reconfig_logging");
        if (propVal != null && propVal.equalsIgnoreCase("false")) {
            return;
        }
        try {
            LogManager lm = LogManager.getLogManager();
            if (FrameworkLogger.isDefaultJdkConfig()) {
                lm.reset();
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
                consoleHandler.setLevel(Level.INFO);
                lm.readConfiguration(FrameworkLogger.class.getResourceAsStream("/org/hsqldb/resources/jdklogging-default.properties"));
                Logger cmdlineLogger = Logger.getLogger("org.hsqldb.cmdline");
                cmdlineLogger.addHandler(consoleHandler);
                cmdlineLogger.setUseParentHandlers(false);
            } else {
                lm.readConfiguration();
            }
        }
        catch (Exception e) {
            noopMode = true;
            System.err.println("<clinit> failure initializing JDK logging system.  Continuing without Application logging.");
            e.printStackTrace();
        }
    }

    private FrameworkLogger(String s) {
        if (!noopMode) {
            if (log4jGetLogger == null) {
                this.jdkLogger = Logger.getLogger(s);
            } else {
                try {
                    this.log4jLogger = log4jGetLogger.invoke(null, s);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate Log4j Logger", e);
                }
            }
        }
        loggerInstances.put(s, this);
    }

    public static FrameworkLogger getLog(Class c) {
        return FrameworkLogger.getLog(c.getName());
    }

    public static FrameworkLogger getLog(Class c, String contextId) {
        return contextId == null ? FrameworkLogger.getLog(c) : FrameworkLogger.getLog(contextId + '.' + c.getName());
    }

    public static FrameworkLogger getLog(String baseId, String contextId) {
        return contextId == null ? FrameworkLogger.getLog(baseId) : FrameworkLogger.getLog(contextId + '.' + baseId);
    }

    public static FrameworkLogger getLog(String s) {
        if (loggerInstances.containsKey(s)) {
            return (FrameworkLogger)loggerInstances.get(s);
        }
        return new FrameworkLogger(s);
    }

    public void log(Level level, String message, Throwable t) {
        this.privlog(level, message, t, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String message, Throwable t, int revertMethods, Class skipClass) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            StackTraceElement[] elements = new Throwable().getStackTrace();
            String c = elements[revertMethods].getClassName();
            String m = elements[revertMethods].getMethodName();
            if (t == null) {
                this.jdkLogger.logp(level, c, m, message);
            } else {
                this.jdkLogger.logp(level, c, m, message, t);
            }
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, skipClass.getName(), jdkToLog4jLevels.get(level), message, t);
            }
            catch (Exception e) {
                throw new RuntimeException("Logging failed when attempting to log: " + message, e);
            }
        }
    }

    public void enduserlog(Level level, String message) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            String c = FrameworkLogger.class.getName();
            String m = "\\l";
            this.jdkLogger.logp(level, c, m, message);
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, FrameworkLogger.class.getName(), jdkToLog4jLevels.get(level), message, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Logging failed when attempting to log: " + message, e);
            }
        }
    }

    public void log(Level level, String message) {
        this.privlog(level, message, null, 2, FrameworkLogger.class);
    }

    public void finer(String message) {
        this.privlog(Level.FINER, message, null, 2, FrameworkLogger.class);
    }

    public void warning(String message) {
        this.privlog(Level.WARNING, message, null, 2, FrameworkLogger.class);
    }

    public void severe(String message) {
        this.privlog(Level.SEVERE, message, null, 2, FrameworkLogger.class);
    }

    public void info(String message) {
        this.privlog(Level.INFO, message, null, 2, FrameworkLogger.class);
    }

    public void finest(String message) {
        this.privlog(Level.FINEST, message, null, 2, FrameworkLogger.class);
    }

    public void error(String message) {
        this.privlog(Level.WARNING, message, null, 2, FrameworkLogger.class);
    }

    public void finer(String message, Throwable t) {
        this.privlog(Level.FINER, message, t, 2, FrameworkLogger.class);
    }

    public void warning(String message, Throwable t) {
        this.privlog(Level.WARNING, message, t, 2, FrameworkLogger.class);
    }

    public void severe(String message, Throwable t) {
        this.privlog(Level.SEVERE, message, t, 2, FrameworkLogger.class);
    }

    public void info(String message, Throwable t) {
        this.privlog(Level.INFO, message, t, 2, FrameworkLogger.class);
    }

    public void finest(String message, Throwable t) {
        this.privlog(Level.FINEST, message, t, 2, FrameworkLogger.class);
    }

    public void error(String message, Throwable t) {
        this.privlog(Level.WARNING, message, t, 2, FrameworkLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDefaultJdkConfig() {
        block16: {
            block15: {
                block14: {
                    globalCfgFile = new File(System.getProperty("java.home"), "lib/logging.properties");
                    if (!globalCfgFile.isFile()) {
                        return false;
                    }
                    fis = null;
                    lm = LogManager.getLogManager();
                    try {
                        try {
                            fis = new FileInputStream(globalCfgFile);
                            defaultProps = new Properties();
                            defaultProps.load(fis);
                            names = defaultProps.propertyNames();
                            i = 0;
                            while (names.hasMoreElements()) {
                                ++i;
                                name = (String)names.nextElement();
                                liveVal = lm.getProperty(name);
                                if (liveVal == null) {
                                    var8_10 = false;
                                    var10_13 = null;
                                    if (fis == null) return var8_10;
                                    break block14;
                                }
                                if (lm.getProperty(name).equals(liveVal)) continue;
                                var8_11 = false;
                                break block15;
                            }
                            var8_12 = true;
                            break block16;
                        }
                        catch (IOException ioe) {
                            var4_6 = false;
                            var10_16 = null;
                            if (fis == null) return var4_6;
                            try {
                                fis.close();
                                return var4_6;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            return var4_6;
                        }
                    }
                    catch (Throwable var9_23) {
                        var10_17 = null;
                        if (fis == null) throw var9_23;
                        try {}
                        catch (IOException ioe) {
                            throw var9_23;
                        }
                        fis.close();
                        throw var9_23;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 164->171)] { 
lbl52:
                // 1 sources

                fis.close();
                return var8_10;
lbl54:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return var8_10;
            }
            var10_14 = null;
            if (fis == null) return var8_11;
            ** try [egrp 2[TRYBLOCK] [8 : 164->171)] { 
lbl61:
            // 1 sources

            fis.close();
            return var8_11;
lbl63:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return var8_11;
        }
        var10_15 = null;
        if (fis == null) return var8_12;
        try {}
        catch (IOException ioe) {
            // empty catch block
            return var8_12;
        }
        fis.close();
        return var8_12;
    }

    static {
        try {
            FrameworkLogger.reconfigure();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

