/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public class Util {
    static final void throwError(HsqlException e) throws SQLException {
        SQLException se = new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
        se.initCause(e);
        throw se;
    }

    static final void throwError(Result r) throws SQLException {
        SQLException se = new SQLException(r.getMainString(), r.getSubString(), r.getErrorCode());
        if (r.getException() != null) {
            se.initCause(r.getException());
        }
        throw se;
    }

    public static final SQLException sqlException(HsqlException e) {
        SQLException se = new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
        se.initCause(e);
        return se;
    }

    public static final SQLException sqlException(HsqlException e, Throwable cause) {
        SQLException se = new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
        if (cause != null) {
            se.initCause(cause);
        }
        return se;
    }

    public static final SQLException sqlException(int id) {
        return Util.sqlException(Error.error(id));
    }

    public static final SQLException sqlExceptionSQL(int id) {
        return Util.sqlException(Error.error(id));
    }

    public static final SQLException sqlException(int id, String message) {
        return Util.sqlException(Error.error(id, message));
    }

    public static final SQLException sqlException(int id, String message, Exception cause) {
        return Util.sqlException(Error.error(id, message), cause);
    }

    public static final SQLException sqlException(int id, int add) {
        return Util.sqlException(Error.error(id, add));
    }

    static final SQLException sqlException(int id, int subId, Object[] add) {
        return Util.sqlException(Error.error(null, id, subId, add));
    }

    static final SQLException notSupported() {
        return Util.sqlException(Error.error(1500));
    }

    static SQLException notUpdatableColumn() {
        return Util.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return Util.sqlException(423);
    }

    static SQLException nullArgument(String name) {
        return Util.sqlException(423, name + ": null");
    }

    public static SQLException invalidArgument() {
        return Util.sqlException(423);
    }

    public static SQLException invalidArgument(String name) {
        return Util.sqlException(423, name);
    }

    public static SQLException outOfRangeArgument() {
        return Util.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String name) {
        return Util.sqlException(423, name);
    }

    public static SQLException connectionClosedException() {
        return Util.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result r) {
        return new SQLWarning(r.getMainString(), r.getSubString(), r.getErrorCode());
    }

    public static SQLException sqlException(Throwable t) {
        return new SQLException(t.getMessage(), Error.getStateString(458), 458);
    }

    public static SQLException sqlException(Result r) {
        SQLException se = new SQLException(r.getMainString(), r.getSubString(), r.getErrorCode());
        if (r.getException() != null) {
            se.initCause(r.getException());
        }
        return se;
    }
}

