/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.Util;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultProperties;

public class JDBCStatement
extends JDBCStatementBase
implements Statement {
    boolean poolable = false;

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.fetchResult(sql, 2, 2, null, null);
        return this.getResultSet();
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        this.fetchResult(sql, 1, 2, null, null);
        return this.resultIn.getUpdateCount();
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeResultData();
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Util.outOfRangeArgument();
        }
    }

    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Util.outOfRangeArgument();
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = enable;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0 || seconds > Short.MAX_VALUE) {
            throw Util.outOfRangeArgument();
        }
        this.queryTimeout = seconds;
    }

    public synchronized void cancel() throws SQLException {
        this.checkClosed();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.fetchResult(sql, 0, 2, null, null);
        return this.currentResultSet != null;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        this.checkClosed();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw Util.outOfRangeArgument();
        }
        this.fetchSize = rows;
    }

    public synchronized int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    public synchronized int getResultSetType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    public synchronized void addBatch(String sql) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            sql = this.connection.nativeSQL(sql);
        }
        if (this.batchResultOut == null) {
            this.batchResultOut = Result.newBatchedExecuteRequest();
        }
        this.batchResultOut.getNavigator().add(new Object[]{sql});
    }

    public synchronized void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchResultOut != null) {
            this.batchResultOut.getNavigator().clear();
        }
    }

    public synchronized int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.generatedResult = null;
        if (this.batchResultOut == null) {
            this.batchResultOut = Result.newBatchedExecuteRequest();
        }
        int batchCount = this.batchResultOut.getNavigator().getSize();
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
            this.performPostExecute();
        }
        catch (HsqlException e) {
            this.batchResultOut.getNavigator().clear();
            throw Util.sqlException(e);
        }
        this.batchResultOut.getNavigator().clear();
        if (this.resultIn.isError()) {
            throw Util.sqlException(this.resultIn);
        }
        RowSetNavigator navigator = this.resultIn.getNavigator();
        int[] updateCounts = new int[navigator.getSize()];
        for (int i = 0; i < updateCounts.length; ++i) {
            Object[] data = navigator.getNext();
            updateCounts[i] = (Integer)data[0];
        }
        if (updateCounts.length != batchCount) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(updateCounts);
            }
            this.errorResult.getMainString();
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), updateCounts);
        }
        return updateCounts;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    public synchronized boolean getMoreResults(int current) throws SQLException {
        return super.getMoreResults(current);
    }

    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw Util.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(sql, 1, autoGeneratedKeys, null, null);
        if (this.resultIn.isError()) {
            throw Util.sqlException(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw Util.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 1, 21, columnIndexes, null);
        return this.resultIn.getUpdateCount();
    }

    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            throw Util.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 1, 11, null, columnNames);
        return this.resultIn.getUpdateCount();
    }

    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw Util.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(sql, 0, autoGeneratedKeys, null, null);
        return this.resultIn.isData();
    }

    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw Util.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 0, 21, columnIndexes, null);
        return this.resultIn.isData();
    }

    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            throw Util.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 0, 11, null, columnNames);
        return this.resultIn.isData();
    }

    public synchronized int getResultSetHoldability() throws SQLException {
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    JDBCStatement(JDBCConnection c, int props) {
        this.resultOut = Result.newExecuteDirectRequest();
        this.connection = c;
        this.connectionIncarnation = this.connection.incarnation;
        this.rsProperties = props;
    }

    private void fetchResult(String sql, int statementRetType, int generatedKeys, int[] generatedIndexes, String[] generatedNames) throws SQLException {
        this.checkClosed();
        this.closeResultData();
        if (this.isEscapeProcessing) {
            sql = this.connection.nativeSQL(sql);
        }
        this.resultOut.setPrepareOrExecuteProperties(sql, this.maxRows, this.fetchSize, statementRetType, this.queryTimeout, this.rsProperties, generatedKeys, generatedIndexes, generatedNames);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            this.performPostExecute();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        if (this.resultIn.isError()) {
            throw Util.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.resultIn.getStatementType() == 2) {
            this.getMoreResults();
        }
    }
}

