/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class JDBCParameterMetaData
implements ParameterMetaData {
    ResultMetaData rmd;
    String[] classNames;
    int parameterCount;
    private boolean translateTTIType;

    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    public int isNullable(int param) throws SQLException {
        this.checkRange(param);
        return 2;
    }

    public boolean isSigned(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.translateType(this.rmd.columnTypes[--param]);
        return type.isNumberType();
    }

    public int getPrecision(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.translateType(this.rmd.columnTypes[--param]);
        if (type.isDateTimeType()) {
            return type.displaySize();
        }
        long size = type.precision;
        if (size > Integer.MAX_VALUE) {
            size = 0L;
        }
        return (int)size;
    }

    public int getScale(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.translateType(this.rmd.columnTypes[--param]);
        return type.scale;
    }

    public int getParameterType(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.translateType(this.rmd.columnTypes[--param]);
        return type.getJDBCTypeCode();
    }

    public String getParameterTypeName(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.translateType(this.rmd.columnTypes[--param]);
        return type.getNameString();
    }

    public String getParameterClassName(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.translateType(this.rmd.columnTypes[--param]);
        return type.getJDBCClassName();
    }

    public int getParameterMode(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.paramModes[--param];
    }

    JDBCParameterMetaData(JDBCConnection conn, ResultMetaData metaData) throws SQLException {
        this.rmd = metaData;
        this.parameterCount = this.rmd.getColumnCount();
        if (conn.clientProperties != null) {
            this.translateTTIType = conn.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    private Type translateType(Type type) {
        if (this.translateTTIType) {
            if (type.isIntervalType()) {
                type = ((IntervalType)type).getCharacterType();
            } else if (type.isDateTimeTypeWithZone()) {
                type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
            }
        }
        return type;
    }

    void checkRange(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            String msg = param + " is out of range";
            throw Util.outOfRangeArgument(msg);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable t) {
            return super.toString() + "[toStringImpl_exception=" + t + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        int count = this.getParameterCount();
        if (count == 0) {
            sb.append("[parameterCount=0]");
            return sb.toString();
        }
        Method[] methods = this.getClass().getDeclaredMethods();
        sb.append('[');
        int len = methods.length;
        for (int i = 0; i < count; ++i) {
            sb.append('\n');
            sb.append("    parameter_");
            sb.append(i + 1);
            sb.append('=');
            sb.append('[');
            for (int j = 0; j < len; ++j) {
                Method method = methods[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                sb.append(method.getName());
                sb.append('=');
                sb.append(method.invoke((Object)this, new Integer(i + 1)));
                if (j + 1 >= len) continue;
                sb.append(',');
                sb.append(' ');
            }
            sb.append(']');
            if (i + 1 >= count) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('\n');
        sb.append(']');
        return sb.toString();
    }
}

