/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.hsqldb.ClientConnection;
import org.hsqldb.ClientConnectionHTTP;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCCallableStatement;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCSavepoint;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.ResultProperties;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    HsqlProperties connProperties;
    HsqlProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;

    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement stmt = new JDBCStatement(this, props);
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement stmt = new JDBCCallableStatement(this, sql, 1003, 1007, this.rsHoldability);
            return stmt;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.length() == 0 || sql.indexOf(123) == -1) {
            return sql;
        }
        boolean changed = false;
        int state = 0;
        int len = sql.length();
        int nest = 0;
        StringBuffer sb = null;
        boolean outside_all = false;
        boolean outside_escape_inside_single_quotes = true;
        int outside_escape_inside_double_quotes = 2;
        int inside_escape = 3;
        int inside_escape_inside_single_quotes = 4;
        int inside_escape_inside_double_quotes = 5;
        int tail = 0;
        block6: for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    if (sb == null) {
                        sb = new StringBuffer(sql.length());
                    }
                    sb.append(sql.substring(tail, i));
                    tail = i = this.onStartEscapeSequence(sql, sb, i);
                    changed = true;
                    ++nest;
                    state = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --state;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    state -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        state = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        sb.append(sql.substring(tail, i));
                        sb.append(' ');
                        tail = ++i;
                        changed = true;
                        state = --nest == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    sb.append(sql.substring(tail, i));
                    tail = i = this.onStartEscapeSequence(sql, sb, i);
                    changed = true;
                    ++nest;
                    state = 3;
                }
            }
        }
        if (!changed) {
            return sql;
        }
        sb.append(sql.substring(tail, sql.length()));
        return sb.toString();
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(autoCommit);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(readOnly);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, catalog);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(level);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, this.rsHoldability);
        return new JDBCStatement(this, props);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public synchronized void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        this.rsHoldability = holdability;
    }

    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        JDBCSavepoint savepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(savepoint.name);
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
        return savepoint;
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (name == null) {
            throw Util.nullArgument();
        }
        if (name.startsWith("SYSTEM_SAVEPOINT_")) {
            throw Util.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(name);
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
        return new JDBCSavepoint(name, this);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(sp.name);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        try {
            this.sessionProxy.releaseSavepoint(sp.name);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new JDBCStatement(this, props);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                throw Util.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, autoGeneratedKeys, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 21, columnIndexes, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 11, null, columnNames);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        if (schema == null) {
            Util.nullArgument("schema");
        } else if (schema.length() == 0) {
            Util.invalidArgument("Zero-length schema");
        } else {
            new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(schema);
        }
    }

    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw Util.nullArgument("executor");
        }
        this.close();
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public JDBCConnection(HsqlProperties props) throws SQLException {
        boolean isTLS;
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String connType = props.getProperty("connection_type");
        String host = props.getProperty("host");
        int port = props.getIntegerProperty("port", 0);
        String path = props.getProperty("path");
        String database = props.getProperty("database");
        boolean bl = isTLS = connType == "hsqls://" || connType == "https://";
        if (user == null) {
            user = "SA";
        }
        if (password == null) {
            password = "";
        }
        Calendar cal = Calendar.getInstance();
        int zoneSeconds = HsqlDateTime.getZoneSeconds(cal);
        try {
            if (DatabaseURL.isInProcessDatabaseType(connType)) {
                this.sessionProxy = DatabaseManager.newSession(connType, database, user, password, props, null, zoneSeconds);
            } else if (connType == "hsql://" || connType == "hsqls://") {
                this.sessionProxy = new ClientConnection(host, port, path, database, isTLS, user, password, zoneSeconds);
                this.isNetConn = true;
            } else if (connType == "http://" || connType == "https://") {
                this.sessionProxy = new ClientConnectionHTTP(host, port, path, database, isTLS, user, password, zoneSeconds);
                this.isNetConn = true;
            } else {
                throw Util.invalidArgument(connType);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = props;
            this.clientProperties = this.sessionProxy.getClientProperties();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public JDBCConnection(SessionInterface c) {
        this.isInternal = true;
        this.sessionProxy = c;
    }

    public JDBCConnection(JDBCConnection c, JDBCConnectionEventListener eventListener) {
        this.sessionProxy = c.sessionProxy;
        this.connProperties = c.connProperties;
        this.clientProperties = c.clientProperties;
        this.isPooled = true;
        this.poolEventListener = eventListener;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = w;
            } else {
                this.rootWarning.setNextWarning(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = w;
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (HsqlException e) {
            throw Util.sqlException(1305, e.getMessage(), e);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String sql, StringBuffer sb, int i) throws SQLException {
        sb.append(' ');
        ++i;
        i = StringUtil.skipSpaces(sql, i);
        if (sql.regionMatches(true, i, "fn ", 0, 3) || sql.regionMatches(true, i, "oj ", 0, 3)) {
            i += 2;
        } else if (sql.regionMatches(true, i, "ts ", 0, 3)) {
            sb.append("TIMESTAMP");
            i += 2;
        } else if (sql.regionMatches(true, i, "d ", 0, 2)) {
            sb.append("DATE");
            ++i;
        } else if (sql.regionMatches(true, i, "t ", 0, 2)) {
            sb.append("TIME");
            ++i;
        } else if (sql.regionMatches(true, i, "call ", 0, 5)) {
            sb.append("CALL");
            i += 4;
        } else if (sql.regionMatches(true, i, "?= call ", 0, 8)) {
            sb.append("CALL");
            i += 7;
        } else if (sql.regionMatches(true, i, "? = call ", 0, 8)) {
            sb.append("CALL");
            i += 8;
        } else if (sql.regionMatches(true, i, "escape ", 0, 7)) {
            i += 6;
        } else {
            throw Util.sqlException(Error.error(425, sql.substring(--i)));
        }
        return i;
    }
}

